/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import java.util.Date;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEHeader;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.JWK;
import org.dogtagpki.acme.JWS;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="new-account")
@ACMEManagedService
public class ACMENewAccountService {
    public static Logger logger = LoggerFactory.getLogger(ACMENewAccountService.class);
    @Context
    UriInfo uriInfo;

    @POST
    @Produces(value={"application/json"})
    public Response createNewAccount(JWS jws) throws Exception {
        Response.ResponseBuilder builder;
        logger.info("Creating new account");
        Date currentTime = new Date();
        String protectedHeader = new String(jws.getProtectedHeaderAsBytes(), "UTF-8");
        logger.info("Header: " + protectedHeader);
        ACMEHeader header = ACMEHeader.fromJSON((String)protectedHeader);
        ACMEEngine engine = ACMEEngine.getInstance();
        engine.validateNonce(header.getNonce());
        JWK jwk = header.getJwk();
        logger.info("JWK: " + jwk);
        engine.validateJWS(jws, header.getAlg(), jwk);
        String accountID = engine.generateThumbprint(jwk);
        logger.info("Account ID: " + accountID);
        String payload = new String(jws.getPayloadAsBytes(), "UTF-8");
        logger.info("Payload: " + payload);
        URI accountURL = this.uriInfo.getBaseUriBuilder().path("acct").path(accountID).build(new Object[0]);
        ACMEAccount account = engine.getAccount(accountID, false);
        if (account == null) {
            account = ACMEAccount.fromJSON((String)payload);
            Boolean onlyReturnExisting = account.getOnlyReturnExisting();
            if (onlyReturnExisting != null && onlyReturnExisting.booleanValue()) {
                throw engine.createAccountDoesNotExistException(accountID);
            }
            logger.info("Creating new account");
            Boolean termsOfServiceAgreed = account.getTermsOfServiceAgreed();
            if (termsOfServiceAgreed == null || !termsOfServiceAgreed.booleanValue()) {
                throw new Exception("Missing terms of service agreement");
            }
            account.setID(accountID);
            account.setCreationTime(currentTime);
            account.setJWK(jwk);
            account.setStatus("valid");
            engine.createAccount(account);
            builder = Response.created((URI)accountURL);
        } else {
            logger.info("Account already exists");
            engine.validateAccount(accountID, account);
            builder = Response.ok();
            builder.location(accountURL);
        }
        URI ordersURL = this.uriInfo.getBaseUriBuilder().path("acct").path(accountID).path("orders").build(new Object[0]);
        account.setOrders(ordersURL);
        ACMENonce nonce = engine.createNonce();
        builder.header("Replay-Nonce", (Object)nonce.getID());
        URI directoryURL = this.uriInfo.getBaseUriBuilder().path("directory").build(new Object[0]);
        builder.link(directoryURL, "index");
        builder.entity((Object)account);
        return builder.build();
    }
}

