/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkcs11.PK11ECPublicKey;

public class AuditVerify {
    public static final String CRYPTO_PROVIDER = "Mozilla-JSS";
    private static final byte LINE_SEP_BYTE = 10;
    boolean verbose;
    X509Certificate signingCert;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setSigningCert(X509Certificate signingCert) throws Exception {
        if (signingCert == null) {
            throw new Exception("Missing signing certificate");
        }
        byte[] bytes = signingCert.getEncoded();
        X509CertImpl cert = new X509CertImpl(bytes);
        boolean[] keyUsage = cert.getKeyUsage();
        if (keyUsage == null || keyUsage.length < 1) {
            throw new Exception("Missing signing certificate key usage");
        }
        boolean valid = keyUsage[0];
        if (!valid) {
            throw new Exception("Invalid signing certificate key usage");
        }
        this.signingCert = signingCert;
    }

    private static void usage() {
        System.out.println("Usage: AuditVerify -d <dbdir> -n <signing certificate nickname> -a <log list file> [-P <cert/key db prefix>] [-v]");
        System.exit(1);
    }

    public static byte[] base64decode(String input) throws Exception {
        return Utils.base64decode((String)input);
    }

    private static void output(int linenum, String mesg) throws IOException {
        System.out.println("Line " + linenum + ": " + mesg);
    }

    private static void writeFile(String curfileName) {
        System.out.println("======\nFile: " + curfileName + "\n======");
    }

    private static void writeSigStatus(int linenum, String sigStartFile, int sigStartLine, String sigStopFile, int sigStopLine, String mesg) throws IOException {
        AuditVerify.output(linenum, mesg + ": signature of " + sigStartFile + ":" + sigStartLine + " to " + sigStopFile + ":" + sigStopLine);
    }

    public static boolean validPrefix(String configDir, String prefix) throws IOException {
        String[] matchingFiles;
        File dir = new File(configDir);
        if (!dir.isDirectory()) {
            System.out.println("ERROR: \"" + dir + "\" is not a directory");
            AuditVerify.usage();
        }
        return (matchingFiles = dir.list(new PrefixFilter(prefix))).length > 0;
    }

    public Result verify(List<String> logFiles) throws Exception {
        PublicKey pubk = this.signingCert.getPublicKey();
        String sigAlgorithm = null;
        if (pubk instanceof RSAPublicKey) {
            sigAlgorithm = "SHA-256/RSA";
        } else if (pubk instanceof PK11ECPublicKey) {
            sigAlgorithm = "SHA-256/EC";
        } else {
            throw new Exception("Unknown signing certificate key type: " + pubk.getAlgorithm());
        }
        if (this.verbose) {
            System.out.println("AuditVerify: Signing algorithm: " + sigAlgorithm);
        }
        Signature sig = Signature.getInstance(sigAlgorithm, CRYPTO_PROVIDER);
        int goodSigCount = 0;
        int badSigCount = 0;
        int lastFileWritten = -1;
        int sigStartLine = 1;
        int sigStopLine = 1;
        String sigStartFile = logFiles.get(0);
        String sigStopFile = null;
        int signedLines = 1;
        boolean verifySignature = false;
        for (int curfile = 0; curfile < logFiles.size(); ++curfile) {
            String curfileName = logFiles.get(curfile);
            if (this.verbose) {
                AuditVerify.writeFile(curfileName);
                lastFileWritten = curfile;
            }
            int linenum = 0;
            try (FileReader r = new FileReader(curfileName);
                 BufferedReader br = new BufferedReader(r);){
                String curLine;
                while ((curLine = br.readLine()) != null) {
                    ++linenum;
                    if (curLine.indexOf("AUDIT_LOG_SIGNING") != -1) {
                        if (!verifySignature) {
                            if (this.verbose) {
                                AuditVerify.output(linenum, "Ignoring first signature of log series");
                            }
                            verifySignature = true;
                        } else {
                            int sigStart = curLine.indexOf("sig: ");
                            if (sigStart < 0) {
                                AuditVerify.output(linenum, "INVALID SIGNATURE");
                                ++badSigCount;
                            } else {
                                byte[] logSig;
                                String signature = curLine.substring(sigStart + 5);
                                if (this.verbose) {
                                    System.out.println("AuditVerify: Signature: " + signature);
                                }
                                if (sig.verify(logSig = AuditVerify.base64decode(signature))) {
                                    if (this.verbose) {
                                        AuditVerify.writeSigStatus(linenum, sigStartFile, sigStartLine, sigStopFile, sigStopLine, "verification succeeded");
                                    }
                                    ++goodSigCount;
                                } else {
                                    if (lastFileWritten < curfile) {
                                        AuditVerify.writeFile(curfileName);
                                        lastFileWritten = curfile;
                                    }
                                    AuditVerify.writeSigStatus(linenum, sigStartFile, sigStartLine, sigStopFile, sigStopLine, "VERIFICATION FAILED");
                                    ++badSigCount;
                                }
                            }
                        }
                        sig.initVerify(pubk);
                        signedLines = 0;
                        sigStartLine = linenum;
                        sigStartFile = curfileName;
                    }
                    if (!verifySignature) continue;
                    byte[] lineBytes = curLine.getBytes("UTF-8");
                    sig.update(lineBytes);
                    sig.update((byte)10);
                    ++signedLines;
                    sigStopLine = linenum;
                    sigStopFile = curfileName;
                }
                continue;
            }
        }
        Result result = new Result();
        result.goodSigCount = goodSigCount;
        result.badSigCount = badSigCount;
        result.sigStartLine = sigStartLine;
        result.sigStopLine = sigStopLine;
        result.sigStartFile = sigStartFile;
        result.sigStopFile = sigStopFile;
        result.signedLines = signedLines;
        return result;
    }

    public static void main(String[] args) {
        try {
            String listLine;
            String dbdir = null;
            String logListFile = null;
            String signerNick = null;
            String prefix = null;
            boolean verbose = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-d")) {
                    if (++i >= args.length) {
                        AuditVerify.usage();
                    }
                    dbdir = args[i];
                    continue;
                }
                if (args[i].equals("-a")) {
                    if (++i >= args.length) {
                        AuditVerify.usage();
                    }
                    logListFile = args[i];
                    continue;
                }
                if (args[i].equals("-n")) {
                    if (++i >= args.length) {
                        AuditVerify.usage();
                    }
                    signerNick = args[i];
                    continue;
                }
                if (args[i].equals("-P")) {
                    if (++i >= args.length) {
                        AuditVerify.usage();
                    }
                    prefix = args[i];
                    continue;
                }
                if (args[i].equals("-v")) {
                    verbose = true;
                    continue;
                }
                System.out.println("Unrecognized argument(" + i + "): " + args[i]);
                AuditVerify.usage();
            }
            if (dbdir == null || logListFile == null || signerNick == null) {
                System.out.println("Argument omitted");
                AuditVerify.usage();
            }
            Vector<String> logFiles = new Vector<String>();
            BufferedReader r = new BufferedReader(new FileReader(logListFile));
            while ((listLine = r.readLine()) != null) {
                StringTokenizer tok = new StringTokenizer(listLine, ",");
                while (tok.hasMoreElements()) {
                    logFiles.addElement(((String)tok.nextElement()).trim());
                }
            }
            r.close();
            if (logFiles.size() == 0) {
                System.out.println("Error: no log files listed in " + logListFile);
                System.exit(1);
            }
            if (prefix == null) {
                if (!AuditVerify.validPrefix(dbdir, "")) {
                    System.out.println("ERROR: \"" + dbdir + "\" does not contain any security databases");
                    AuditVerify.usage();
                }
                CryptoManager.initialize((String)dbdir);
            } else {
                if (!AuditVerify.validPrefix(dbdir, prefix)) {
                    System.out.println("ERROR: \"" + prefix + "\" is not a valid prefix");
                    AuditVerify.usage();
                }
                CryptoManager.initialize((InitializationValues)new InitializationValues(dbdir, prefix, prefix, "secmod.db"));
            }
            if (verbose) {
                System.out.println("AuditVerify: Audit signing certificate: " + signerNick);
            }
            CryptoManager cm = CryptoManager.getInstance();
            X509Certificate signerCert = cm.findCertByNickname(signerNick);
            AuditVerify verifier = new AuditVerify();
            verifier.setVerbose(verbose);
            verifier.setSigningCert(signerCert);
            Result result = verifier.verify(logFiles);
            if (result.signedLines > 1) {
                System.out.println("ERROR: log entries after " + result.sigStartFile + ":" + result.sigStartLine + " are UNSIGNED");
                ++result.badSigCount;
            }
            System.out.println("\nVerification process complete.");
            System.out.println("Valid signatures: " + result.goodSigCount);
            System.out.println("Invalid signatures: " + result.badSigCount);
            if (result.badSigCount > 0) {
                System.exit(2);
            } else {
                System.exit(0);
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
        catch (ObjectNotFoundException onfe) {
            System.out.println("ERROR: certificate not found");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Verification process FAILED.");
        System.exit(1);
    }

    private static class PrefixFilter
    implements FilenameFilter {
        private String prefix;

        public PrefixFilter(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.indexOf(this.prefix + "cert") != -1;
        }
    }

    public class Result {
        public int goodSigCount;
        public int badSigCount;
        public int sigStartLine;
        public int sigStopLine;
        public String sigStartFile;
        public String sigStopFile;
        public int signedLines;
    }
}

