/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.profile;

import com.netscape.certsrv.tps.profile.ProfileClient;
import com.netscape.certsrv.tps.profile.ProfileData;
import com.netscape.cmstools.tps.TPSCLI;
import com.netscape.cmstools.tps.profile.ProfileAddCLI;
import com.netscape.cmstools.tps.profile.ProfileFindCLI;
import com.netscape.cmstools.tps.profile.ProfileMappingCLI;
import com.netscape.cmstools.tps.profile.ProfileModifyCLI;
import com.netscape.cmstools.tps.profile.ProfileRemoveCLI;
import com.netscape.cmstools.tps.profile.ProfileShowCLI;
import java.io.IOException;
import java.util.Map;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(ProfileCLI.class);
    public TPSCLI tpsCLI;
    public ProfileClient profileClient;

    public ProfileCLI(TPSCLI tpsCLI) {
        super("profile", "Profile management commands", (CLI)tpsCLI);
        this.tpsCLI = tpsCLI;
        this.addModule((CLI)new ProfileAddCLI(this));
        this.addModule((CLI)new ProfileFindCLI(this));
        this.addModule((CLI)new ProfileModifyCLI(this));
        this.addModule((CLI)new ProfileRemoveCLI(this));
        this.addModule((CLI)new ProfileShowCLI(this));
        this.addModule(new ProfileMappingCLI(this));
    }

    public String getManPage() {
        return "pki-tps-profile";
    }

    public ProfileClient getProfileClient() throws Exception {
        if (this.profileClient != null) {
            return this.profileClient;
        }
        this.profileClient = (ProfileClient)this.parent.getClient("profiles");
        return this.profileClient;
    }

    public static void printProfileData(ProfileData profileData, boolean showProperties) throws IOException {
        System.out.println("  Profile ID: " + profileData.getID());
        if (profileData.getStatus() != null) {
            System.out.println("  Status: " + profileData.getStatus());
        }
        if (showProperties) {
            System.out.println("  Properties:");
            Map properties = profileData.getProperties();
            if (properties != null) {
                for (String name : properties.keySet()) {
                    String value = (String)properties.get(name);
                    System.out.println("    " + name + ": " + value);
                }
            }
        }
    }
}

