/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.LDAPDatabase;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.util.Date;
import java.util.Map;
import org.dogtagpki.server.tps.dbs.TPSCertRecord;

public class TPSCertDatabase
extends LDAPDatabase<TPSCertRecord> {
    public TPSCertDatabase(DBSubsystem dbSubsystem, String baseDN) throws EBaseException {
        super("Certificate", dbSubsystem, baseDN, TPSCertRecord.class);
    }

    public void addRecord(String id, TPSCertRecord certRecord) throws Exception {
        certRecord.setCreateTime(new Date());
        super.addRecord(id, (IDBObj)certRecord);
    }

    public void updateRecord(String id, TPSCertRecord certRecord) throws Exception {
        certRecord.setModifyTime(new Date());
        super.updateRecord(id, (IDBObj)certRecord);
    }

    public String createDN(String id) {
        return "cn=" + id + "," + this.baseDN;
    }

    public String createFilter(String keyword, Map<String, String> attributes) {
        StringBuilder sb = new StringBuilder();
        if (keyword != null) {
            keyword = LDAPUtil.escapeFilter((Object)keyword);
            sb.append("(|(id=*" + keyword + "*)(tokenID=*" + keyword + "*)(userID=*" + keyword + "*))");
        }
        this.createFilter(sb, attributes);
        if (sb.length() == 0) {
            sb.append("(id=*)");
        }
        return sb.toString();
    }
}

