/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.authority;

import com.netscape.certsrv.authority.AuthorityData;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.client.SubsystemClient;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class AuthorityClient
extends Client {
    public AuthorityClient(SubsystemClient subsystemClient) throws Exception {
        this(subsystemClient.client, subsystemClient.getName());
    }

    public AuthorityClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "authorities");
    }

    public List<AuthorityData> listCAs() throws Exception {
        return this.findCAs(null, null, null, null);
    }

    public List<AuthorityData> findCAs(String id, String parentID, String dn, String issuerDN) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("id", id);
        }
        if (parentID != null) {
            params.put("parentID", parentID);
        }
        if (dn != null) {
            params.put("dn", dn);
        }
        if (issuerDN != null) {
            params.put("issuerDN", issuerDN);
        }
        GenericType<List<AuthorityData>> type = new GenericType<List<AuthorityData>>(){};
        return this.get(null, params, type);
    }

    public AuthorityData getCA(String caIDString) throws Exception {
        return this.get(caIDString, AuthorityData.class);
    }

    public String getChainPEM(String caIDString) throws Exception {
        WebTarget target = this.target(caIDString + "/chain", null);
        MediaType mediaType = MediaType.valueOf((String)"application/x-pem-file");
        Response response = target.request(new MediaType[]{mediaType}).get();
        return this.client.getEntity(response, String.class);
    }

    public AuthorityData createCA(AuthorityData data) throws Exception {
        Entity<AuthorityData> entity = this.client.entity(data);
        return this.post(null, null, entity, AuthorityData.class);
    }

    public AuthorityData modifyCA(AuthorityData data) throws Exception {
        Entity<AuthorityData> entity = this.client.entity(data);
        return this.put(data.getID(), null, entity, AuthorityData.class);
    }

    public void deleteCA(String aidString) throws Exception {
        this.delete(aidString, Void.class);
    }
}

