/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.system;

import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.key.KeyData;
import com.netscape.certsrv.system.TPSConnectorCollection;
import com.netscape.certsrv.system.TPSConnectorData;
import java.util.HashMap;
import javax.ws.rs.client.Entity;

public class TPSConnectorClient
extends Client {
    public TPSConnectorClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "admin/tps-connectors");
    }

    public TPSConnectorCollection findConnectors(String host, String port, Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (host != null) {
            params.put("host", host);
        }
        if (port != null) {
            params.put("port", port);
        }
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get(null, params, TPSConnectorCollection.class);
    }

    public TPSConnectorData getConnector(String id) throws Exception {
        return this.get(id, TPSConnectorData.class);
    }

    public TPSConnectorData getConnector(String host, String port) throws Exception {
        TPSConnectorCollection connectors = this.findConnectors(host, port, null, null);
        if (connectors.getEntries().isEmpty()) {
            throw new ResourceNotFoundException("Connector not found: " + host + ":" + port);
        }
        return connectors.getEntries().iterator().next();
    }

    public TPSConnectorData createConnector(String host, String port) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (host != null) {
            params.put("host", host);
        }
        if (port != null) {
            params.put("port", port);
        }
        return this.post(null, params, null, TPSConnectorData.class);
    }

    public TPSConnectorData modifyConnector(String id, TPSConnectorData data) throws Exception {
        Entity<TPSConnectorData> entity = this.client.entity(data);
        return this.post(id, null, entity, TPSConnectorData.class);
    }

    public void deleteConnector(String id) throws Exception {
        this.delete(id, Void.class);
    }

    public void deleteConnector(String host, String port) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (host != null) {
            params.put("host", host);
        }
        if (port != null) {
            params.put("port", port);
        }
        this.delete(null, params, Void.class);
    }

    public KeyData createSharedSecret(String id) throws Exception {
        return this.post(id + "/shared-secret", null, null, KeyData.class);
    }

    public KeyData replaceSharedSecret(String id) throws Exception {
        return this.put(id + "/shared-secret", null, null, KeyData.class);
    }

    public void deleteSharedSecret(String id) throws Exception {
        this.delete(id + "/shared-secret", Void.class);
    }

    public KeyData getSharedSecret(String id) throws Exception {
        return this.get(id + "/shared-secret", KeyData.class);
    }
}

