/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import com.netscape.cmsutil.ocsp.CertStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class RevokedInfo
implements CertStatus {
    private static final Tag TAG = SEQUENCE.TAG;
    private GeneralizedTime mRevokedAt;
    private static final Template templateInstance = new Template();

    public RevokedInfo(GeneralizedTime revokedAt) {
        this.mRevokedAt = revokedAt;
    }

    public Tag getTag() {
        return Tag.get((long)1L);
    }

    public void encode(Tag t, OutputStream os) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.mRevokedAt);
        seq.encode(t, os);
    }

    public void encode(OutputStream os) throws IOException {
        this.encode(this.getTag(), os);
    }

    public GeneralizedTime getRevocationTime() {
        return this.mRevokedAt;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)new GeneralizedTime.Template());
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new INTEGER.Template()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            GeneralizedTime revokedAt = (GeneralizedTime)seq.elementAt(0);
            return new RevokedInfo(revokedAt);
        }
    }
}

