/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class Signature
implements ASN1Value {
    private AlgorithmIdentifier signatureAlgorithm;
    private BIT_STRING signature;
    private SEQUENCE certs;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public BIT_STRING getSignature() {
        return this.signature;
    }

    public int getCertificateCount() {
        return this.certs == null ? 0 : this.certs.size();
    }

    public Certificate getCertificateAt(int index) {
        if (this.certs == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Certificate)this.certs.elementAt(index);
    }

    public Signature(AlgorithmIdentifier signatureAlgorithm, BIT_STRING signature, SEQUENCE certs) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.sequence.addElement((ASN1Value)signatureAlgorithm);
        this.signature = signature;
        this.sequence.addElement((ASN1Value)signature);
        this.certs = certs;
        this.sequence.addElement((ASN1Value)certs);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)BIT_STRING.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new SEQUENCE.OF_Template((ASN1Template)new Certificate.Template())));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            SEQUENCE certs = null;
            if (seq.elementAt(2) != null) {
                certs = (SEQUENCE)((EXPLICIT)seq.elementAt(2)).getContent();
            }
            return new Signature((AlgorithmIdentifier)seq.elementAt(0), (BIT_STRING)seq.elementAt(1), certs);
        }
    }
}

