/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.security.Credential;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;

@WebServlet(name="kraGenerateKeyPair", urlPatterns={"/agent/kra/getApprovalStatus"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="kra"), @WebInitParam(name="templatePath", value="/agent/kra/getApprovalStatus.template"), @WebInitParam(name="ID", value="kraKRAGetApprovalStatus"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.kra.request.status")})
public class GetApprovalStatus
extends CMSServlet {
    private static final long serialVersionUID = -8257339915430654983L;
    private static final String INFO = "getApprovalStatus";
    private static final String TPL_FILE = "getApprovalStatus.template";
    private static final String TPL_FINISH = "finishRecovery.template";
    private static final String OUT_ERROR = "errorDetails";
    private static final String OUT_STATUS = "status";
    private KeyRecoveryAuthority mService;
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        KRAEngine engine = KRAEngine.getInstance();
        this.mService = engine.getKRA();
        this.mTemplates.remove(CMSRequest.SUCCESS);
    }

    public String getServletInfo() {
        return INFO;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        cmsReq.setStatus(CMSRequest.SUCCESS);
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        boolean rComplete = false;
        try {
            String recoveryID = req.getParameter("recoveryID");
            header.addStringValue("recoveryID", recoveryID);
            Hashtable<String, Object> params = this.mService.getRecoveryParams(recoveryID);
            if (params == null) {
                logger.error(CMS.getLogMessage((String)"CMSGW_NO_RECOVERY_TOKEN_FOUND_1", (Object[])new Object[]{recoveryID}));
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NO_RECOVERY_TOKEN_FOUND", (String[])new String[]{recoveryID}));
            }
            header.addStringValue("serialNumber", (String)params.get("keyID"));
            header.addStringValue("serialNumberInHex", new BigInteger((String)params.get("keyID")).toString(16));
            int requiredNumber = this.mService.getNoOfRequiredAgents();
            header.addIntegerValue("noOfRequiredAgents", requiredNumber);
            Vector<Credential> dc = this.mService.getAppAgents(recoveryID);
            Enumeration<Credential> agents = dc.elements();
            while (agents.hasMoreElements()) {
                ArgBlock rarg = new ArgBlock();
                rarg.addStringValue("agentName", agents.nextElement().getIdentifier());
                argSet.addRepeatRecord(rarg);
            }
            if (dc.size() >= requiredNumber) {
                byte[] pkcs12 = this.mService.getPk12(recoveryID);
                if (pkcs12 != null) {
                    rComplete = true;
                    header.addStringValue(OUT_STATUS, "complete");
                } else if (this.mService.getError(recoveryID) != null) {
                    header.addStringValue(OUT_ERROR, this.mService.getError(recoveryID));
                    rComplete = true;
                }
            }
        }
        catch (EBaseException e) {
            header.addStringValue(OUT_ERROR, e.toString(locale[0]));
            rComplete = true;
        }
        try {
            this.mFormPath = rComplete ? "/" + this.mService.getId() + "/finishRecovery.template" : "/" + this.mService.getId() + "/getApprovalStatus.template";
            if (this.mOutputTemplatePath != null) {
                this.mFormPath = this.mOutputTemplatePath;
            }
            try {
                form = this.getTemplate(this.mFormPath, req, locale);
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
            }
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }
}

