/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import com.netscape.kra.AsymKeyGenService;
import com.netscape.kra.EnrollmentService;
import com.netscape.kra.KeyRecoveryAuthority;
import com.netscape.kra.NetkeyKeygenService;
import com.netscape.kra.RecoveryService;
import com.netscape.kra.SecurityDataRecoveryService;
import com.netscape.kra.SecurityDataService;
import com.netscape.kra.SymKeyGenService;
import com.netscape.kra.TokenKeyRecoveryService;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAService
implements IService {
    public static Logger logger = LoggerFactory.getLogger(KRAService.class);
    public static final String ENROLLMENT = "enrollment";
    public static final String RECOVERY = "recovery";
    public static final String NETKEY_KEYGEN = "netkeyKeygen";
    public static final String NETKEY_KEYRECOVERY = "netkeyKeyRecovery";
    public static final String SECURITY_DATA_ENROLLMENT = "securityDataEnrollment";
    public static final String SECURITY_DATA_RECOVERY = "securityDataRecovery";
    public static final String SYMKEY_GENERATION = "symkeyGenRequest";
    public static final String ASYMKEY_GENERATION = "asymkeyGenRequest";
    private Hashtable<String, IService> mServices = new Hashtable();

    public KRAService(KeyRecoveryAuthority kra) {
        this.mServices.put(ENROLLMENT, new EnrollmentService(kra));
        this.mServices.put(RECOVERY, new RecoveryService(kra));
        this.mServices.put(NETKEY_KEYGEN, new NetkeyKeygenService(kra));
        this.mServices.put(NETKEY_KEYRECOVERY, new TokenKeyRecoveryService(kra));
        this.mServices.put(SECURITY_DATA_ENROLLMENT, new SecurityDataService(kra));
        this.mServices.put(SECURITY_DATA_RECOVERY, new SecurityDataRecoveryService(kra));
        this.mServices.put(SYMKEY_GENERATION, new SymKeyGenService(kra));
        this.mServices.put(ASYMKEY_GENERATION, new AsymKeyGenService(kra));
    }

    public boolean serviceRequest(Request r) throws EBaseException {
        logger.info("KRAService: Processing request " + r.getRequestId().toHexString());
        String type = r.getRequestType();
        logger.info("KRAService: - type: " + type);
        IService s = this.mServices.get(type);
        logger.info("KRAService: - service: " + s);
        if (s == null) {
            logger.error("KRAService: Unable to find service " + type);
            r.setExtData("Result", Request.RES_ERROR);
            r.setExtData("Error", (Throwable)new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_OPERATION", (String[])new String[0])));
            return true;
        }
        logger.info("KRAService: - service class: " + s.getClass().getSimpleName());
        try {
            return s.serviceRequest(r);
        }
        catch (EBaseException e) {
            logger.error("KRAService: Unable to process request: " + e.getMessage(), (Throwable)e);
            r.setExtData("Result", Request.RES_ERROR);
            r.setExtData("Error", (Throwable)e);
            if (e.getMessage().equals(CMS.getUserMessage((String)"CMS_KRA_INVALID_TRANSPORT_CERT", (String[])new String[0]))) {
                r.setRequestStatus(RequestStatus.REJECTED);
                return true;
            }
            return false;
        }
    }
}

