/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CertificateAuthority;
import com.netscape.ca.KeyRetriever;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.CAMissingCertException;
import com.netscape.certsrv.ca.CAMissingKeyException;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.security.PublicKey;
import java.util.Collection;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRetrieverRunner
implements Runnable {
    public static final Logger logger = LoggerFactory.getLogger(KeyRetrieverRunner.class);
    private KeyRetriever keyRetriever;
    private CertificateAuthority certificateAuthority;
    private AuthorityID aid;
    private String nickname;
    private Collection<String> hosts;
    private boolean useOAEPKeyWrap = false;

    public KeyRetrieverRunner(KeyRetriever keyRetriever, CertificateAuthority certificateAuthority) {
        this.keyRetriever = keyRetriever;
        this.certificateAuthority = certificateAuthority;
        this.aid = certificateAuthority.getAuthorityID();
        this.nickname = certificateAuthority.getNickname();
        this.hosts = certificateAuthority.getAuthorityKeyHosts();
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        try {
            this.useOAEPKeyWrap = cs.getUseOAEPKeyWrap();
        }
        catch (EBaseException e1) {
            throw new RuntimeException("Invalid value for keyWrap.useOAEP: " + e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long d = 10000L;
            while (!this._run()) {
                logger.debug("Retrying in " + d / 1000L + " seconds");
                try {
                    Thread.sleep(d);
                }
                catch (InterruptedException e) {
                    break;
                }
                d += d / 2L;
            }
        }
        finally {
            CAEngine engine = CAEngine.getInstance();
            engine.removeKeyRetriever(this.aid);
        }
    }

    private boolean _run() {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        KeyRetriever.Result krr = null;
        try {
            krr = this.keyRetriever.retrieveKey(this.nickname, this.hosts);
        }
        catch (Throwable e) {
            logger.warn("Caught exception during execution of KeyRetriever.retrieveKey", e);
            return false;
        }
        if (krr == null) {
            logger.warn("KeyRetriever did not return a result.");
            return false;
        }
        logger.debug("Importing key and cert");
        byte[] certBytes = krr.getCertificate();
        byte[] paoData = krr.getPKIArchiveOptions();
        try {
            CryptoManager manager = CryptoManager.getInstance();
            CryptoToken token = manager.getInternalKeyStorageToken();
            X509Certificate cert = manager.importCACertPackage(certBytes);
            PublicKey pubkey = cert.getPublicKey();
            token.getCryptoStore().deleteCert(cert);
            PrivateKey unwrappingKey = engine.getCA().mSigningUnit.getPrivateKey();
            CryptoUtil.importPKIArchiveOptions((CryptoToken)token, (PrivateKey)unwrappingKey, (PublicKey)pubkey, (byte[])paoData, (boolean)this.useOAEPKeyWrap);
            cert = manager.importUserCACertPackage(certBytes, this.nickname);
        }
        catch (Throwable e) {
            logger.warn("Caught exception during cert/key import", e);
            return false;
        }
        logger.debug("Reinitialising SigningUnit");
        CertificateAuthority ca = engine.getCA(this.aid);
        if (ca == null) {
            logger.debug("Authority was deleted; returning.");
            return true;
        }
        boolean initSigUnitSucceeded = false;
        try {
            logger.info("CertificateAuthority: reinitializing signing units in KeyRetrieverRunner");
            ca.initCertSigningUnit();
            ca.initCRLSigningUnit();
            ca.initOCSPSigningUnit();
            initSigUnitSucceeded = true;
        }
        catch (CAMissingCertException e) {
            logger.warn("CertificateAuthority: CA signing cert not (yet) present in NSS database");
            this.certificateAuthority.signingUnitException = e;
        }
        catch (CAMissingKeyException e) {
            logger.warn("CertificateAuthority: CA signing key not (yet) present in NSS database");
            this.certificateAuthority.signingUnitException = e;
        }
        catch (Throwable e) {
            logger.warn("Caught exception during SigningUnit re-init", e);
            return false;
        }
        if (!initSigUnitSucceeded) {
            logger.warn("Failed to re-init SigningUnit");
            return false;
        }
        logger.debug("Adding self to authorityKeyHosts attribute");
        try {
            String host = cs.getHostname() + ":" + engine.getEESSLPort();
            engine.addAuthorityKeyHost(ca, host);
        }
        catch (Throwable e) {
            logger.warn("Failed to add self to authorityKeyHosts", e);
            return true;
        }
        return true;
    }
}

