/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalProcessConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(ExternalProcessConstraint.class);
    public static final String CONFIG_EXECUTABLE = "executable";
    public static final String CONFIG_TIMEOUT = "timeout";
    public static final long DEFAULT_TIMEOUT = 10L;
    protected static final Map<String, String> envVars = new TreeMap<String, String>();
    protected Map<String, String> extraEnvVars = new TreeMap<String, String>();
    protected String executable;
    protected long timeout;

    public ExternalProcessConstraint() {
        this.addConfigName(CONFIG_EXECUTABLE);
        this.addConfigName(CONFIG_TIMEOUT);
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
        super.init(config);
        this.executable = this.getConfig(CONFIG_EXECUTABLE);
        if (this.executable == null || this.executable.isEmpty()) {
            throw new EProfileException("Missing required config param 'executable'");
        }
        this.timeout = 10L;
        String timeoutConfig = this.getConfig(CONFIG_TIMEOUT);
        if (timeoutConfig != null && !timeoutConfig.isEmpty()) {
            try {
                this.timeout = Integer.valueOf(timeoutConfig).longValue();
            }
            catch (NumberFormatException e) {
                throw new EProfileException("Invalid timeout value", (Throwable)e);
            }
            if (this.timeout < 1L) {
                throw new EProfileException("Invalid timeout value: must be positive");
            }
        }
        ConfigStore envConfig = config.getSubStore("params.env", ConfigStore.class);
        Enumeration names = envConfig.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            try {
                this.extraEnvVars.put(name, envConfig.getString(name));
            }
            catch (EBaseException e) {
                logger.warn("ExternalProcessConstraint: caught exception processing 'params.env' config: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_EXECUTABLE)) {
            return new Descriptor("string", null, null, "Executable path");
        }
        if (name.equals(CONFIG_TIMEOUT)) {
            return new Descriptor("integer", null, null, "Timeout in seconds");
        }
        return null;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        boolean timedOut;
        Process p;
        String v;
        logger.debug("About to execute command: " + this.executable);
        ProcessBuilder pb = new ProcessBuilder(this.executable);
        Map<String, String> env = pb.environment();
        for (String k : envVars.keySet()) {
            v = request.getExtDataInString(envVars.get(k));
            if (v == null) continue;
            env.put(k, v);
        }
        for (String k : this.extraEnvVars.keySet()) {
            v = request.getExtDataInString(this.extraEnvVars.get(k));
            if (v == null) continue;
            env.put(k, v);
        }
        String stdout = "";
        String stderr = "";
        try {
            p = pb.start();
            boolean bl = timedOut = !p.waitFor(this.timeout, TimeUnit.SECONDS);
            if (timedOut) {
                p.destroyForcibly();
            } else {
                stdout = IOUtils.toString((InputStream)p.getInputStream(), (String)"UTF-8");
            }
            stderr = IOUtils.toString((InputStream)p.getErrorStream(), (String)"UTF-8");
        }
        catch (Throwable e) {
            String msg = "Caught exception while executing command: " + this.executable;
            logger.error(msg + ": " + e.getMessage(), e);
            throw new ERejectException(msg, e);
        }
        if (timedOut) {
            throw new ERejectException("Request validation timed out");
        }
        int exitValue = p.exitValue();
        logger.debug("ExternalProcessConstraint: exit value: " + exitValue);
        logger.debug("ExternalProcessConstraint: stdout: " + stdout);
        logger.debug("ExternalProcessConstraint: stderr: " + stderr);
        if (exitValue != 0) {
            throw new ERejectException(stdout);
        }
    }

    static {
        envVars.put("DOGTAG_CERT_REQUEST", "cert_request");
        envVars.put("DOGTAG_USER", "auth_token.userid");
        envVars.put("DOGTAG_PROFILE_ID", "profileId");
        envVars.put("DOGTAG_AUTHORITY_ID", "req_authority_id");
        envVars.put("DOGTAG_USER_DATA", "user_data");
    }
}

