/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.mappers;

import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cms.publish.mappers.LdapDNCompsMap;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.security.cert.CRLException;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCrlIssuerCompsMap
extends LdapDNCompsMap {
    public static Logger logger = LoggerFactory.getLogger(LdapCrlIssuerCompsMap.class);

    public LdapCrlIssuerCompsMap() {
    }

    public LdapCrlIssuerCompsMap(String baseDN, ObjectIdentifier[] dnComps, ObjectIdentifier[] filterComps) {
        this.init(baseDN, dnComps, filterComps);
    }

    public LdapCrlIssuerCompsMap(String crlAttr, String baseDN, ObjectIdentifier[] dnComps, ObjectIdentifier[] filterComps) {
        super(crlAttr, baseDN, dnComps, filterComps);
    }

    @Override
    public String getImplName() {
        return "LdapCrlIssuerCompsMap";
    }

    @Override
    public String getDescription() {
        return "LdapCrlIssuerCompsMap";
    }

    @Override
    public Vector<String> getDefaultParams() {
        Vector<String> v = super.getDefaultParams();
        return v;
    }

    @Override
    public Vector<String> getInstanceParams() {
        Vector<String> v = super.getInstanceParams();
        return v;
    }

    @Override
    protected void init(String baseDN, ObjectIdentifier[] dnComps, ObjectIdentifier[] filterComps) {
        super.init(baseDN, dnComps, filterComps);
    }

    public String map(LDAPConnection conn, Object obj) throws ELdapException {
        if (conn == null) {
            return null;
        }
        X509CRLImpl crl = (X509CRLImpl)obj;
        try {
            String result = null;
            X500Name issuerDN = (X500Name)crl.getIssuerDN();
            logger.debug("LdapCrlIssuerCompsMap: " + issuerDN);
            byte[] crlbytes = crl.getEncoded();
            result = super.map(conn, issuerDN, crlbytes);
            return result;
        }
        catch (CRLException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_CANT_DECODE_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_GET_DER_ENCODED_CRL_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }

    public String map(LDAPConnection conn, Request req, Object obj) throws ELdapException {
        return this.map(conn, obj);
    }
}

