/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert.scep;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.ldap.LdapConnFactory;
import com.netscape.certsrv.profile.EDeferException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.servlet.cert.scep.SCEPConfig;
import com.netscape.cms.servlet.profile.SSLClientCertProvider;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestList;
import com.netscape.cmscore.request.RequestNotifier;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmscore.security.PWCBsdr;
import com.netscape.cmscore.util.Debug;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.scep.CRSPKIMessage;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.extensions.CertInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attribute;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attributes;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AVA;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.DNSName;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.ExtensionsRequested;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.IPAddressName;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs7.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.PasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caSCEP", urlPatterns={"/cgi-bin/pkiclient.exe"}, initParams={@WebInitParam(name="authority", value="ca"), @WebInitParam(name="profileId", value="caRouterCert")})
public class CRSEnrollment
extends HttpServlet {
    public static Logger logger = LoggerFactory.getLogger(CRSEnrollment.class);
    private static final long serialVersionUID = 8483002540957382369L;
    private static final String OAEP_SHA = "SHA-256";
    protected ProfileSubsystem mProfileSubsystem;
    protected String mProfileId = null;
    protected CertificateAuthority mAuthority;
    protected ConfigStore mConfig;
    protected AuthSubsystem mAuthSubsystem;
    protected String mAppendDN = null;
    protected String mEntryObjectclass = null;
    protected boolean mCreateEntry = false;
    protected boolean mFlattenDN = false;
    private String mAuthManagerName;
    private String mSubstoreName;
    private boolean mEnabled = false;
    private boolean mUseCA = true;
    private String mNickname = null;
    private String mTokenName = "";
    private String mHashAlgorithm = "SHA1";
    private String mHashAlgorithmList = null;
    private String[] mAllowedHashAlgorithm;
    private String mConfiguredEncryptionAlgorithm = "DES3";
    private String mEncryptionAlgorithm = "DES3";
    private String mEncryptionAlgorithmList = null;
    private String[] mAllowedEncryptionAlgorithm;
    private SecureRandom mRandom = null;
    private int mNonceSizeLimit = 0;
    private CertificateAuthority ca;
    private boolean mIsDynamicProfileId = false;
    private String mAllowedDynamicProfileIdList = null;
    private String[] mAllowedDynamicProfileId;
    private boolean mUseOAEPKeyWrap = false;
    protected MessageDigest mSHADigest = null;
    private static final String PROP_SUBSTORENAME = "substorename";
    private static final String PROP_AUTHORITY = "authority";
    private static final String PROP_CRSAUTHMGR = "authName";
    private static final String PROP_APPENDDN = "appendDN";
    private static final String PROP_CREATEENTRY = "createEntry";
    private static final String PROP_FLATTENDN = "flattenDN";
    private static final String PROP_ENTRYOC = "entryObjectclass";
    private static final String URL_OPERATION = "operation";
    private static final String URL_MESSAGE = "message";
    private static final String OP_GETCACERT = "GetCACert";
    private static final String OP_GETCACAPS = "GetCACaps";
    private static final String OP_PKIOPERATION = "PKIOperation";
    public static final String AUTH_PASSWORD = "pwd";
    public static final String AUTH_CREDS = "AuthCreds";
    public static final String AUTH_TOKEN = "AuthToken";
    public static final String AUTH_FAILED = "AuthFailed";
    public static final String SANE_DNSNAME = "DNSName";
    public static final String SANE_IPADDRESS = "IPAddress";
    public static final String CERTINFO = "CertInfo";
    public static final String SUBJECTNAME = "SubjectName";
    public static final String SERVLET_NAME_DYN_PROFILE = "caDynamicProfileSCEP";
    public static ObjectIdentifier OID_UNSTRUCTUREDNAME = null;
    public static ObjectIdentifier OID_UNSTRUCTUREDADDRESS = null;
    public static ObjectIdentifier OID_SERIALNUMBER = null;

    public static Hashtable<String, String> toHashtable(HttpServletRequest req) {
        Hashtable<String, String> httpReqHash = new Hashtable<String, String>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            httpReqHash.put(name, req.getParameter(name));
        }
        return httpReqHash;
    }

    public void init(ServletConfig sc) {
        int i;
        String crsCA = sc.getInitParameter(PROP_AUTHORITY);
        if (crsCA == null) {
            crsCA = "ca";
        }
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        this.ca = this.mAuthority = (CertificateAuthority)engine.getSubsystem(crsCA);
        if (this.mAuthority == null) {
            logger.warn("CRSEnrollment: " + CMS.getLogMessage((String)"CMSGW_CANT_FIND_AUTHORITY", (Object[])new Object[]{crsCA}));
        }
        try {
            int i2;
            CAConfig authorityConfig = this.mAuthority.getConfig();
            SCEPConfig scepConfig = authorityConfig.getSCEPConfig();
            this.mEnabled = scepConfig.getEnable();
            this.mUseOAEPKeyWrap = cs.getUseOAEPKeyWrap();
            if (sc.getServletName().equals(SERVLET_NAME_DYN_PROFILE)) {
                this.mIsDynamicProfileId = true;
                logger.debug("CRSEnrollment: init: expecting dynamic ProfileId in URL");
            }
            this.mHashAlgorithm = scepConfig.getHashAlgorithm();
            this.mConfiguredEncryptionAlgorithm = scepConfig.getEncryptionAlgorithm();
            this.mNonceSizeLimit = scepConfig.getNonceSizeLimit();
            this.mHashAlgorithmList = scepConfig.getAllowedHashAlgorithms();
            this.mAllowedHashAlgorithm = this.mHashAlgorithmList.split(",");
            this.mEncryptionAlgorithmList = scepConfig.getAllowedEncryptionAlgorithms();
            this.mAllowedEncryptionAlgorithm = this.mEncryptionAlgorithmList.split(",");
            if (this.mIsDynamicProfileId) {
                this.mAllowedDynamicProfileIdList = scepConfig.getAllowedDynamicProfileIds();
                logger.debug("CRSEnrollment: init: mAllowedDynamicProfileIdList: " + this.mAllowedDynamicProfileIdList);
                this.mAllowedDynamicProfileId = this.mAllowedDynamicProfileIdList.split(",");
                for (i2 = 0; i2 < this.mAllowedDynamicProfileId.length; ++i2) {
                    this.mAllowedDynamicProfileId[i2] = this.mAllowedDynamicProfileId[i2].trim();
                    logger.debug("CRSEnrollment: init: mAllowedDynamicProfileId[" + i2 + "]=" + this.mAllowedDynamicProfileId[i2]);
                }
            }
            this.mNickname = scepConfig.getNickname(this.ca.getNickname());
            if (this.mNickname.equals(this.ca.getNickname())) {
                this.mTokenName = this.ca.getSigningUnit().getTokenName();
            } else {
                this.mTokenName = scepConfig.getTokenName();
                this.mUseCA = false;
            }
            if (!(CryptoUtil.isInternalToken((String)this.mTokenName) || (i2 = this.mNickname.indexOf(58)) > -1 && this.mTokenName.length() == i2 && this.mNickname.startsWith(this.mTokenName))) {
                this.mNickname = this.mTokenName + ":" + this.mNickname;
            }
        }
        catch (EBaseException e) {
            logger.warn("CRSEnrollment: init: EBaseException: " + e.getMessage(), (Throwable)e);
        }
        this.mEncryptionAlgorithm = this.mConfiguredEncryptionAlgorithm;
        logger.debug("CRSEnrollment: init: SCEP support is " + (this.mEnabled ? "enabled" : "disabled") + ".");
        logger.debug("CRSEnrollment: init: SCEP nickname: " + this.mNickname);
        logger.debug("CRSEnrollment: init:   CA nickname: " + this.ca.getNickname());
        logger.debug("CRSEnrollment: init:    Token name: " + this.mTokenName);
        logger.debug("CRSEnrollment: init: Is SCEP using CA keys: " + this.mUseCA);
        logger.debug("CRSEnrollment: init: mNonceSizeLimit: " + this.mNonceSizeLimit);
        logger.debug("CRSEnrollment: init: mHashAlgorithm: " + this.mHashAlgorithm);
        logger.debug("CRSEnrollment: init: mHashAlgorithmList: " + this.mHashAlgorithmList);
        logger.debug("CRSEnrollment: init: mUseOAEPKeyWrap: " + this.mUseOAEPKeyWrap);
        for (i = 0; i < this.mAllowedHashAlgorithm.length; ++i) {
            this.mAllowedHashAlgorithm[i] = this.mAllowedHashAlgorithm[i].trim();
            logger.debug("CRSEnrollment: init: mAllowedHashAlgorithm[" + i + "]=" + this.mAllowedHashAlgorithm[i]);
        }
        logger.debug("CRSEnrollment: init: mEncryptionAlgorithm: " + this.mEncryptionAlgorithm);
        logger.debug("CRSEnrollment: init: mEncryptionAlgorithmList: " + this.mEncryptionAlgorithmList);
        for (i = 0; i < this.mAllowedEncryptionAlgorithm.length; ++i) {
            this.mAllowedEncryptionAlgorithm[i] = this.mAllowedEncryptionAlgorithm[i].trim();
            logger.debug("CRSEnrollment: init: mAllowedEncryptionAlgorithm[" + i + "]=" + this.mAllowedEncryptionAlgorithm[i]);
        }
        try {
            this.mProfileSubsystem = engine.getProfileSubsystem();
            if (!this.mIsDynamicProfileId) {
                this.mProfileId = sc.getInitParameter("profileId");
                logger.debug("CRSEnrollment: init: mProfileId=" + this.mProfileId);
            }
            this.mAuthSubsystem = engine.getAuthSubsystem();
            this.mAuthManagerName = sc.getInitParameter(PROP_CRSAUTHMGR);
            this.mAppendDN = sc.getInitParameter(PROP_APPENDDN);
            String tmp = sc.getInitParameter(PROP_CREATEENTRY);
            this.mCreateEntry = tmp != null && tmp.trim().equalsIgnoreCase("true");
            tmp = sc.getInitParameter(PROP_FLATTENDN);
            this.mFlattenDN = tmp != null && tmp.trim().equalsIgnoreCase("true");
            this.mEntryObjectclass = sc.getInitParameter(PROP_ENTRYOC);
            if (this.mEntryObjectclass == null) {
                this.mEntryObjectclass = "cep";
            }
            this.mSubstoreName = sc.getInitParameter(PROP_SUBSTORENAME);
            if (this.mSubstoreName == null) {
                this.mSubstoreName = "default";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        OID_UNSTRUCTUREDNAME = X500NameAttrMap.getDefault().getOid("UNSTRUCTUREDNAME");
        OID_UNSTRUCTUREDADDRESS = X500NameAttrMap.getDefault().getOid("UNSTRUCTUREDADDRESS");
        OID_SERIALNUMBER = X500NameAttrMap.getDefault().getOid("SERIALNUMBER");
        try {
            this.mSHADigest = MessageDigest.getInstance(OAEP_SHA);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        this.mRandom = jssSubsystem.getRandomNumberGenerator();
    }

    public void service(HttpServletRequest httpReq, HttpServletResponse httpResp) throws ServletException {
        block13: {
            CAEngine engine = CAEngine.getInstance();
            boolean running_state = engine.isInRunningState();
            if (!running_state) {
                throw new ServletException("CMS server is not ready to serve.");
            }
            if (this.mIsDynamicProfileId) {
                this.mProfileId = this.extractProfileIdFromURL(httpReq);
                logger.debug("CRSEnrollment: service: (dynamic) mProfileId=" + this.mProfileId);
                if (!this.isDynamicProfileIdAllowed(this.mAllowedDynamicProfileId, this.mProfileId)) {
                    logger.error("CRSEnrollment: serve: (dynamic) ProfileId '" + this.mProfileId + "' is not allowed (" + this.mAllowedDynamicProfileIdList + ").");
                    throw new ServletException("(dynamic) ProfileId '" + this.mProfileId + "' is not allowed (" + this.mAllowedDynamicProfileIdList + ").");
                }
            }
            String operation = null;
            String message = null;
            this.mEncryptionAlgorithm = this.mConfiguredEncryptionAlgorithm;
            ArgBlock input = new ArgBlock(CRSEnrollment.toHashtable(httpReq));
            try {
                operation = (String)input.get(URL_OPERATION);
                logger.debug("operation=" + operation);
                message = (String)input.get(URL_MESSAGE);
                logger.debug("message=" + message);
                if (!this.mEnabled) {
                    logger.error("CRSEnrollment: SCEP support is disabled.");
                    throw new ServletException("SCEP support is disabled.");
                }
                if (operation == null) {
                    throw new ServletException("Bad request: operation missing from URL");
                }
                if (operation.equals(OP_GETCACERT)) {
                    this.handleGetCACert(httpReq, httpResp);
                    break block13;
                }
                if (operation.equals(OP_GETCACAPS)) {
                    this.handleGetCACaps(httpReq, httpResp);
                    break block13;
                }
                if (operation.equals(OP_PKIOPERATION)) {
                    String decodeMode = (String)input.get("decode");
                    if (decodeMode == null || decodeMode.equals("false")) {
                        this.handlePKIOperation(httpReq, httpResp, message);
                    } else {
                        this.decodePKIMessage(httpReq, httpResp, message);
                    }
                    break block13;
                }
                logger.error("Invalid operation " + operation);
                throw new ServletException("unknown operation requested: " + operation);
            }
            catch (ServletException e) {
                logger.error("CRSEnrollment: " + e.getMessage(), (Throwable)e);
                throw new ServletException(e.getMessage().toString());
            }
            catch (Exception e) {
                logger.warn("CRSEnrollment: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private String extractProfileIdFromURL(HttpServletRequest httpReq) throws ServletException {
        String pathInfo = httpReq.getPathInfo();
        if (!pathInfo.matches("^/[^/]+/pkiclient\\.exe$")) {
            throw new ServletException("dynamic ProfileId URL must be in the form of '" + httpReq.getContextPath() + httpReq.getServletPath() + "/PROFILE_ID/pkiclient.exe'");
        }
        return pathInfo.split("/")[1];
    }

    private boolean isAlgorithmAllowed(String[] allowedAlgorithm, String algorithm) {
        return this.isInAllowedList(allowedAlgorithm, algorithm);
    }

    private boolean isDynamicProfileIdAllowed(String[] allowedDynamicProfileId, String profileId) {
        return this.isInAllowedList(allowedDynamicProfileId, profileId);
    }

    private boolean isInAllowedList(String[] allowedList, String searchedItem) {
        boolean allowed = false;
        if (searchedItem != null && searchedItem.length() > 0) {
            for (int i = 0; i < allowedList.length; ++i) {
                if (!searchedItem.equalsIgnoreCase(allowedList[i])) continue;
                allowed = true;
            }
        }
        return allowed;
    }

    public AuthToken authenticate(AuthCredentials credentials, AuthManager authenticator, HttpServletRequest request) throws EBaseException {
        Enumeration authNames = authenticator.getValueNames();
        if (authNames != null) {
            while (authNames.hasMoreElements()) {
                String authName = (String)authNames.nextElement();
                credentials.set(authName, (Object)request.getParameter(authName));
            }
        }
        credentials.set("clientHost", (Object)request.getRemoteHost());
        AuthToken authToken = authenticator.authenticate(credentials);
        if (authToken == null) {
            return null;
        }
        SessionContext sc = SessionContext.getContext();
        if (sc != null) {
            sc.put((Object)"authManagerId", (Object)authenticator.getName());
            String userid = authToken.getInString("userid");
            if (userid != null) {
                sc.put((Object)"userid", (Object)userid);
            }
        }
        return authToken;
    }

    public void handleGetCACert(HttpServletRequest httpReq, HttpServletResponse httpResp) throws ServletException {
        java.security.cert.X509Certificate[] chain = null;
        CertificateChain certChain = this.mAuthority.getCACertChain();
        try {
            if (certChain == null) {
                throw new ServletException("Internal Error: cannot get CA Cert");
            }
            chain = certChain.getChain();
            byte[] bytes = null;
            int i = 0;
            String message = httpReq.getParameter(URL_MESSAGE);
            logger.debug("handleGetCACert message=" + message);
            if (message != null) {
                try {
                    int j = Integer.parseInt(message);
                    if (j < chain.length) {
                        i = j;
                    }
                }
                catch (NumberFormatException j) {
                    // empty catch block
                }
            }
            logger.debug("handleGetCACert selected chain=" + i);
            if (this.mUseCA) {
                bytes = chain[i].getEncoded();
            } else {
                CryptoContext cx = new CryptoContext();
                bytes = cx.getSigningCert().getEncoded();
            }
            httpResp.setContentType("application/x-x509-ca-cert");
            httpResp.setContentLength(bytes.length);
            httpResp.getOutputStream().write(bytes);
            httpResp.getOutputStream().flush();
            logger.debug("Output certificate chain:");
            logger.debug(Debug.dump((byte[])bytes));
        }
        catch (Exception e) {
            logger.error("CRSEnrollment: " + CMS.getLogMessage((String)"CMSGW_ERROR_SENDING_DER_ENCODE_CERT", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            throw new ServletException("Failed sending DER encoded version of CA cert to client");
        }
    }

    public void handleGetCACaps(HttpServletRequest httpReq, HttpServletResponse httpResp) throws ServletException {
        try {
            StringBuilder response = new StringBuilder();
            if (this.isAlgorithmAllowed(this.mAllowedEncryptionAlgorithm, "AES")) {
                response.append("AES\n");
            }
            if (this.isAlgorithmAllowed(this.mAllowedEncryptionAlgorithm, "DES3")) {
                response.append("DES3\n");
            }
            if (this.isAlgorithmAllowed(this.mAllowedHashAlgorithm, "SHA1")) {
                response.append("SHA-1\n");
            }
            if (this.isAlgorithmAllowed(this.mAllowedHashAlgorithm, "SHA256")) {
                response.append("SHA-256\n");
            }
            if (this.isAlgorithmAllowed(this.mAllowedHashAlgorithm, "SHA512")) {
                response.append("SHA-512\n");
            }
            httpResp.setContentType("text/plain");
            httpResp.setContentLength(response.length());
            httpResp.getOutputStream().print(response.toString());
            httpResp.getOutputStream().flush();
            logger.debug("Output CA Capabilities:");
            logger.debug(response.toString());
        }
        catch (Exception e) {
            logger.error("CRSEnrollment: failed sending CA capabilities", (Throwable)e);
            throw new ServletException("Failed sending CA capabilities:" + e.getMessage(), (Throwable)e);
        }
    }

    public String getPasswordFromP10(PKCS10 p10) {
        PKCS10Attributes p10atts = p10.getAttributes();
        Enumeration e = p10atts.getElements();
        try {
            while (e.hasMoreElements()) {
                PKCS10Attribute p10a = (PKCS10Attribute)e.nextElement();
                CertAttrSet attr = p10a.getAttributeValue();
                if (!attr.getName().equals("ChallengePassword") || attr.get("password") == null) continue;
                return (String)attr.get("password");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void decodePKIMessage(HttpServletRequest httpReq, HttpServletResponse httpResp, String msg) throws ServletException {
        CryptoContext cx = null;
        CRSPKIMessage req = null;
        byte[] response = null;
        Object responseData = "";
        byte[] decodedPKIMessage = Utils.base64decode((String)msg);
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(decodedPKIMessage);
            if (decodedPKIMessage.length < 50) {
                throw new ServletException("CRS request is too small to be a real request (" + decodedPKIMessage.length + " bytes)");
            }
            try {
                req = new CRSPKIMessage(is);
                String ea = req.getEncryptionAlgorithm();
                if (!this.isAlgorithmAllowed(this.mAllowedEncryptionAlgorithm, ea)) {
                    logger.error("CRSEnrollment: decodePKIMessage:  Encryption algorithm '" + ea + "' is not allowed (" + this.mEncryptionAlgorithmList + ").");
                    throw new ServletException("Encryption algorithm '" + ea + "' is not allowed (" + this.mEncryptionAlgorithmList + ").");
                }
                String da = req.getDigestAlgorithmName();
                if (!this.isAlgorithmAllowed(this.mAllowedHashAlgorithm, da)) {
                    logger.error("CRSEnrollment: decodePKIMessage:  Hashing algorithm '" + da + "' is not allowed (" + this.mHashAlgorithmList + ").");
                    throw new ServletException("Hashing algorithm '" + da + "' is not allowed (" + this.mHashAlgorithmList + ").");
                }
                if (ea != null) {
                    this.mEncryptionAlgorithm = ea;
                }
            }
            catch (Exception e) {
                logger.error("CRSEnrollment: " + e.getMessage(), (Throwable)e);
                throw new ServletException("Could not decode the request.");
            }
            cx = new CryptoContext();
            this.verifyRequest(req, cx);
            this.unwrapPKCS10(req, cx);
            Profile profile = this.mProfileSubsystem.getProfile(this.mProfileId);
            if (profile == null) {
                logger.error("Profile '" + this.mProfileId + "' not found.");
                throw new ServletException("Profile '" + this.mProfileId + "' not found.");
            }
            logger.debug("Found profile '" + this.mProfileId + "'.");
            AuthManager authenticator = null;
            try {
                logger.debug("Retrieving authenticator");
                authenticator = this.mProfileSubsystem.getProfileAuthenticator(profile);
                if (authenticator == null) {
                    logger.error("Authenticator not found.");
                    throw new ServletException("Authenticator not found.");
                }
                logger.debug("Got authenticator=" + authenticator.getClass().getName());
            }
            catch (EProfileException e) {
                throw new ServletException("Authenticator not found.");
            }
            AuthCredentials credentials = new AuthCredentials();
            AuthToken authToken = null;
            SessionContext context = SessionContext.getContext();
            context.put((Object)"sslClientCertProvider", (Object)new SSLClientCertProvider(httpReq));
            try {
                authToken = this.authenticate(credentials, authenticator, httpReq);
            }
            catch (Exception e) {
                logger.error("Authentication failure: " + e.getMessage(), (Throwable)e);
                throw new ServletException("Authentication failure: " + e.getMessage());
            }
            if (authToken == null) {
                logger.error("Authentication failure.");
                throw new ServletException("Authentication failure.");
            }
            String transactionID = req.getTransactionID();
            responseData = (String)responseData + "<TransactionID>" + transactionID + "</TransactionID>";
            responseData = (String)responseData + "<RemoteAddr>" + httpReq.getRemoteAddr() + "</RemoteAddr>";
            responseData = (String)responseData + "<RemoteHost>" + httpReq.getRemoteHost() + "</RemoteHost>";
            String mt = req.getMessageType();
            responseData = (String)responseData + "<MessageType>" + mt + "</MessageType>";
            PKCS10 p10 = req.getP10();
            X500Name p10subject = p10.getSubjectName();
            responseData = (String)responseData + "<SubjectName>" + p10subject.toString() + "</SubjectName>";
            Object pkcs10Attr = "";
            PKCS10Attributes p10atts = p10.getAttributes();
            Enumeration e = p10atts.getElements();
            while (e.hasMoreElements()) {
                PKCS10Attribute p10a = (PKCS10Attribute)e.nextElement();
                CertAttrSet attr = p10a.getAttributeValue();
                if (attr.getName().equals("ChallengePassword") && attr.get("password") != null) {
                    pkcs10Attr = (String)pkcs10Attr + "<ChallengePassword><Password>" + (String)attr.get("password") + "</Password></ChallengePassword>";
                }
                Object extensionsStr = "";
                if (!attr.getName().equals("EXTENSIONS_REQUESTED")) continue;
                Enumeration exts = ((ExtensionsRequested)attr).getExtensions().elements();
                while (exts.hasMoreElements()) {
                    Extension ext = (Extension)exts.nextElement();
                    if (!ext.getExtensionId().equals(OIDMap.getOID((String)"x509.info.extensions.SubjectAlternativeName"))) continue;
                    SubjectAlternativeNameExtension sane = new SubjectAlternativeNameExtension(Boolean.valueOf(false), (Object)ext.getExtensionValue());
                    Vector v = (Vector)sane.get("subject_name");
                    Enumeration gne = v.elements();
                    StringBuffer subjAltNameStr = new StringBuffer();
                    while (gne.hasMoreElements()) {
                        GeneralNameInterface gni = (GeneralNameInterface)gne.nextElement();
                        if (!(gni instanceof GeneralName)) continue;
                        GeneralName genName = (GeneralName)gni;
                        String gn = genName.toString();
                        int colon = gn.indexOf(58);
                        String gnType = gn.substring(0, colon).trim();
                        String gnValue = gn.substring(colon + 1).trim();
                        subjAltNameStr.append("<");
                        subjAltNameStr.append(gnType);
                        subjAltNameStr.append(">");
                        subjAltNameStr.append(gnValue);
                        subjAltNameStr.append("</");
                        subjAltNameStr.append(gnType);
                        subjAltNameStr.append(">");
                    }
                    extensionsStr = "<SubjAltName>" + subjAltNameStr.toString() + "</SubjAltName>";
                }
                pkcs10Attr = (String)pkcs10Attr + "<Extensions>" + (String)extensionsStr + "</Extensions>";
            }
            responseData = (String)responseData + "<PKCS10>" + (String)pkcs10Attr + "</PKCS10>";
        }
        catch (ServletException e) {
            throw new ServletException(e.getMessage().toString());
        }
        catch (CRSInvalidSignatureException e) {
            logger.warn("handlePKIMessage exception " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("handlePKIMessage exception " + e.getMessage(), (Throwable)e);
            throw new ServletException("Failed to process message in CEP servlet: " + e.getMessage());
        }
        try {
            int i2;
            responseData = "<XMLResponse>" + (String)responseData + "</XMLResponse>";
            response = ((String)responseData).getBytes();
            httpResp.setContentType("application/xml");
            httpResp.setContentLength(response.length);
            httpResp.getOutputStream().write(response);
            httpResp.getOutputStream().flush();
            int i1 = ((String)responseData).indexOf("<Password>");
            if (i1 > -1 && (i2 = ((String)responseData).indexOf("</Password>", i1 += 10)) > -1) {
                responseData = ((String)responseData).substring(0, i1) + "********" + ((String)responseData).substring(i2, ((String)responseData).length());
            }
            logger.debug("Output (decoding) PKIOperation response:");
            logger.debug((String)responseData);
        }
        catch (Exception e) {
            throw new ServletException("Failed to create response for CEP message" + e.getMessage());
        }
    }

    public void handlePKIOperation(HttpServletRequest httpReq, HttpServletResponse httpResp, String msg) throws ServletException {
        X509CertImpl cert;
        byte[] response;
        CRSPKIMessage crsResp;
        CRSPKIMessage req;
        CryptoContext cx;
        block23: {
            cx = null;
            req = null;
            crsResp = null;
            response = null;
            cert = null;
            byte[] decodedPKIMessage = Utils.base64decode((String)msg);
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(decodedPKIMessage);
                if (decodedPKIMessage.length < 50) {
                    throw new ServletException("CRS request is too small to be a real request (" + decodedPKIMessage.length + " bytes)");
                }
                try {
                    req = new CRSPKIMessage(is);
                    String ea = req.getEncryptionAlgorithm();
                    if (!this.isAlgorithmAllowed(this.mAllowedEncryptionAlgorithm, ea)) {
                        logger.error("CRSEnrollment: handlePKIOperation:  Encryption algorithm '" + ea + "' is not allowed (" + this.mEncryptionAlgorithmList + ").");
                        throw new ServletException("Encryption algorithm '" + ea + "' is not allowed (" + this.mEncryptionAlgorithmList + ").");
                    }
                    String da = req.getDigestAlgorithmName();
                    if (!this.isAlgorithmAllowed(this.mAllowedHashAlgorithm, da)) {
                        logger.error("CRSEnrollment: handlePKIOperation:  Hashing algorithm '" + da + "' is not allowed (" + this.mHashAlgorithmList + ").");
                        throw new ServletException("Hashing algorithm '" + da + "' is not allowed (" + this.mHashAlgorithmList + ").");
                    }
                    if (ea != null) {
                        this.mEncryptionAlgorithm = ea;
                    }
                    crsResp = new CRSPKIMessage();
                }
                catch (ServletException e) {
                    throw new ServletException(e.getMessage().toString());
                }
                catch (Exception e) {
                    logger.error("CRSEnrollmenet: " + e.getMessage(), (Throwable)e);
                    throw new ServletException("Could not decode the request.");
                }
                crsResp.setMessageType("3");
                cx = new CryptoContext();
                this.verifyRequest(req, cx);
                String transactionID = req.getTransactionID();
                if (transactionID == null) {
                    throw new ServletException("Error: malformed PKIMessage - missing transactionID");
                }
                crsResp.setTransactionID(transactionID);
                byte[] sn = req.getSenderNonce();
                if (sn == null) {
                    throw new ServletException("Error: malformed PKIMessage - missing sendernonce");
                }
                if (this.mNonceSizeLimit > 0 && sn.length > this.mNonceSizeLimit) {
                    byte[] snLimited = this.mNonceSizeLimit > 0 ? new byte[this.mNonceSizeLimit] : null;
                    System.arraycopy(sn, 0, snLimited, 0, this.mNonceSizeLimit);
                    crsResp.setRecipientNonce(snLimited);
                } else {
                    crsResp.setRecipientNonce(sn);
                }
                byte[] serverNonce = new byte[16];
                this.mRandom.nextBytes(serverNonce);
                crsResp.setSenderNonce(serverNonce);
                String mt = req.getMessageType();
                if (mt == null) {
                    throw new ServletException("Error: malformed PKIMessage - missing messageType");
                }
                if (mt.equals("19")) {
                    logger.debug("Processing PKCSReq");
                    try {
                        Request cmsRequest = this.findRequestByTransactionID(req.getTransactionID(), true);
                        cert = this.handlePKCSReq(httpReq, cmsRequest, req, crsResp, cx);
                        break block23;
                    }
                    catch (CRSFailureException e) {
                        throw new ServletException("Couldn't handle CEP request (PKCSReq) - " + e.getMessage());
                    }
                }
                if (mt.equals("20")) {
                    logger.debug("Processing GetCertInitial");
                    cert = this.handleGetCertInitial(req, crsResp);
                } else {
                    logger.warn("Invalid request type " + mt);
                }
            }
            catch (ServletException e) {
                throw e;
            }
            catch (CRSInvalidSignatureException e) {
                logger.error("handlePKIMessage exception " + e.getMessage(), (Throwable)e);
                crsResp.setFailInfo("1");
            }
            catch (Exception e) {
                logger.error("handlePKIMessage exception " + e.getMessage(), (Throwable)e);
                throw new ServletException("Failed to process message in CEP servlet: " + e.getMessage());
            }
        }
        try {
            this.processCertRep(cx, cert, crsResp, req);
            response = crsResp.getResponse();
            httpResp.setContentType("application/x-pki-message");
            httpResp.setContentLength(response.length);
            httpResp.getOutputStream().write(response);
            httpResp.getOutputStream().flush();
            logger.debug("Output PKIOperation response:");
            logger.debug(Utils.base64encode((byte[])response, (boolean)true));
        }
        catch (Exception e) {
            throw new ServletException("Failed to create response for CEP message" + e.getMessage());
        }
    }

    public Request findRequestByTransactionID(String txid, boolean ignoreRejected) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        RequestRepository requestRepository = engine.getRequestRepository();
        RequestQueue rq = engine.getRequestQueue();
        Request foundRequest = null;
        RequestList rids = rq.findRequestsBySourceId(txid);
        if (rids == null) {
            return null;
        }
        while (rids.hasMoreElements()) {
            Request request;
            RequestId rid = (RequestId)rids.nextElement();
            if (rid == null || (request = requestRepository.readRequest(rid)) == null || ignoreRejected && !request.getRequestStatus().equals((Object)RequestStatus.PENDING) && !request.getRequestStatus().equals((Object)RequestStatus.COMPLETE)) continue;
            if (foundRequest != null) {
                // empty if block
            }
            foundRequest = request;
        }
        return foundRequest;
    }

    public X509CertImpl handleGetCertInitial(CRSPKIMessage req, CRSPKIMessage resp) {
        Request foundRequest = null;
        try {
            foundRequest = this.findRequestByTransactionID(req.getTransactionID(), false);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        if (foundRequest == null) {
            resp.setFailInfo("4");
            resp.setPKIStatus("2");
            return null;
        }
        return this.makeResponseFromRequest(req, resp, foundRequest);
    }

    public void verifyRequest(CRSPKIMessage req, CryptoContext cx) throws CRSInvalidSignatureException {
        byte[] reqAAbytes = req.getAA();
        byte[] reqAAsig = req.getAADigest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createEntry(String dn) {
        boolean result = false;
        CAEngine engine = CAEngine.getInstance();
        CAPublisherProcessor ldapPub = engine.getPublisherProcessor();
        if (ldapPub == null || !ldapPub.isCertPublishingEnabled()) {
            logger.warn("CRSEnrollment: " + CMS.getLogMessage((String)"CMSGW_ERROR_CREATE_ENTRY_FROM_CEP", (Object[])new Object[0]));
            return result;
        }
        LdapConnFactory connFactory = ldapPub.getLdapConnModule().getLdapConnFactory();
        if (connFactory == null) {
            return result;
        }
        LDAPConnection connection = null;
        try {
            connection = connFactory.getConn();
            String[] objectclasses = new String[]{"top", this.mEntryObjectclass};
            LDAPAttribute ocAttrs = new LDAPAttribute("objectclass", objectclasses);
            LDAPAttributeSet attrSet = new LDAPAttributeSet();
            attrSet.add(ocAttrs);
            LDAPEntry newEntry = new LDAPEntry(dn, attrSet);
            connection.add(newEntry);
            result = true;
        }
        catch (Exception e) {
            logger.warn("CRSEnrollment: " + CMS.getLogMessage((String)"CMSGW_FAIL_CREAT_ENTRY_EXISTS", (Object[])new Object[]{dn}), (Throwable)e);
        }
        finally {
            try {
                connFactory.returnConn(connection);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public void unwrapPKCS10(CRSPKIMessage req, CryptoContext cx) throws ServletException, NotInitializedException, CryptoContext.CryptoContextException, CRSFailureException {
        byte[] decryptedP10bytes = null;
        boolean padding = false;
        try {
            SymmetricKey.Type skt;
            KeyWrapper kw = cx.getKeyWrapper();
            OAEPParameterSpec keyWrapConfig = null;
            if (this.mUseOAEPKeyWrap) {
                keyWrapConfig = new OAEPParameterSpec(OAEP_SHA, "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
                padding = true;
            }
            kw.initUnwrap(cx.getPrivateKey(), keyWrapConfig);
            EncryptionAlgorithm ea = switch (String.valueOf(this.mEncryptionAlgorithm)) {
                case "DES3" -> {
                    skt = SymmetricKey.DES3;
                    yield EncryptionAlgorithm.DES3_CBC;
                }
                case "AES" -> {
                    skt = SymmetricKey.AES;
                    yield EncryptionAlgorithm.AES_128_CBC;
                }
                default -> {
                    skt = SymmetricKey.DES;
                    yield EncryptionAlgorithm.DES_CBC;
                }
            };
            SymmetricKey sk = kw.unwrapSymmetric(req.getWrappedKey(), skt, SymmetricKey.Usage.DECRYPT, padding ? ea.getKeyStrength() / 8 : 0);
            SymmetricKey skinternal = this.moveSymmetricToInternalToken(cx, sk, skt, ea);
            Cipher cip = skinternal.getOwningToken().getCipherContext(ea);
            cip.initDecrypt(skinternal, (AlgorithmParameterSpec)new IVParameterSpec(req.getIV()));
            decryptedP10bytes = cip.doFinal(req.getEncryptedPkcs10());
            logger.debug("decryptedP10bytes:");
            logger.debug(Debug.dump((byte[])decryptedP10bytes));
            req.setP10(new PKCS10(decryptedP10bytes));
        }
        catch (Exception e) {
            logger.error("failed to unwrap PKCS10 " + e.getMessage(), (Throwable)e);
            throw new CRSFailureException("Could not unwrap PKCS10 blob: " + e.getMessage());
        }
    }

    private SymmetricKey moveSymmetricToInternalToken(CryptoContext cx, SymmetricKey sk, SymmetricKey.Type skt, EncryptionAlgorithm ea) throws Exception {
        boolean padding = false;
        KeyPairGeneratorSpi.Usage[] usage = new KeyPairGeneratorSpi.Usage[]{KeyPairGeneratorSpi.Usage.WRAP, KeyPairGeneratorSpi.Usage.UNWRAP, KeyPairGeneratorSpi.Usage.ENCRYPT, KeyPairGeneratorSpi.Usage.DECRYPT};
        KeyPair keyPairWrap = CryptoUtil.generateRSAKeyPair((CryptoToken)cx.getInternalToken(), (int)2048, (Boolean)true, (Boolean)true, (Boolean)false, (KeyPairGeneratorSpi.Usage[])usage, (KeyPairGeneratorSpi.Usage[])usage);
        KeyWrapAlgorithm kwAlg = KeyWrapAlgorithm.RSA;
        OAEPParameterSpec algSpec = null;
        if (this.mUseOAEPKeyWrap) {
            kwAlg = KeyWrapAlgorithm.RSA_OAEP;
            algSpec = new OAEPParameterSpec(OAEP_SHA, "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            padding = true;
        }
        KeyWrapper kw = sk.getOwningToken().getKeyWrapper(kwAlg);
        kw.initWrap(keyPairWrap.getPublic(), (AlgorithmParameterSpec)algSpec);
        byte[] wrappedSK = kw.wrap(sk);
        KeyWrapper kwInt = cx.getInternalToken().getKeyWrapper(kwAlg);
        PrivateKey pk = (PrivateKey)keyPairWrap.getPrivate();
        kwInt.initUnwrap(pk, (AlgorithmParameterSpec)algSpec);
        return kwInt.unwrapSymmetric(wrappedSK, skt, SymmetricKey.Usage.DECRYPT, padding ? ea.getKeyStrength() / 8 : 0);
    }

    private void getDetailFromRequest(CRSPKIMessage req, CRSPKIMessage crsResp) throws CRSFailureException {
        SubjectAlternativeNameExtension sane = null;
        try {
            PKCS10 p10 = req.getP10();
            if (p10 == null) {
                crsResp.setFailInfo("1");
                crsResp.setPKIStatus("2");
                throw new CRSFailureException("Failed to decode pkcs10 from CEP request");
            }
            AuthCredentials authCreds = new AuthCredentials();
            CertInfo certInfo = new CertInfo();
            X509Key key = p10.getSubjectPublicKeyInfo();
            X500Name p10subject = p10.getSubjectName();
            X500Name subject = null;
            Enumeration rdne = p10subject.getRDNs();
            Vector<RDN> rdnv = new Vector<RDN>();
            Hashtable<String, String> sanehash = new Hashtable<String, String>();
            X500NameAttrMap xnap = X500NameAttrMap.getDefault();
            while (rdne.hasMoreElements()) {
                RDN rdn = (RDN)rdne.nextElement();
                int i = 0;
                AVA[] oldavas = rdn.getAssertion();
                for (i = 0; i < rdn.getAssertionLength(); ++i) {
                    AVA[] newavas = new AVA[]{oldavas[i]};
                    authCreds.set(xnap.getName(oldavas[i].getOid()), (Object)oldavas[i].getValue().getAsString());
                    if (oldavas[i].getOid().equals(OID_UNSTRUCTUREDNAME)) {
                        sanehash.put(SANE_DNSNAME, oldavas[i].getValue().getAsString());
                    }
                    if (oldavas[i].getOid().equals(OID_UNSTRUCTUREDADDRESS)) {
                        sanehash.put(SANE_IPADDRESS, oldavas[i].getValue().getAsString());
                    }
                    RDN newrdn = new RDN(newavas);
                    if (!this.mFlattenDN) continue;
                    rdnv.addElement(newrdn);
                }
            }
            subject = this.mFlattenDN ? new X500Name(rdnv) : p10subject;
            KeyUsageExtension kue = new KeyUsageExtension();
            kue.set("digital_signature", (Object)true);
            kue.set("key_encipherment", (Object)true);
            PKCS10Attributes p10atts = p10.getAttributes();
            Enumeration e = p10atts.getElements();
            while (e.hasMoreElements()) {
                PKCS10Attribute p10a = (PKCS10Attribute)e.nextElement();
                CertAttrSet attr = p10a.getAttributeValue();
                if (attr.getName().equals("ChallengePassword") && attr.get("password") != null) {
                    req.put(AUTH_PASSWORD, attr.get("password"));
                    req.put("ChallengePassword", (Object)this.hashPassword((String)attr.get("password")));
                }
                if (!attr.getName().equals("EXTENSIONS_REQUESTED")) continue;
                Enumeration exts = ((ExtensionsRequested)attr).getExtensions().elements();
                while (exts.hasMoreElements()) {
                    Extension ext = (Extension)exts.nextElement();
                    if (ext.getExtensionId().equals(OIDMap.getOID((String)"x509.info.extensions.KeyUsage"))) {
                        kue = new KeyUsageExtension(Boolean.valueOf(false), (Object)ext.getExtensionValue());
                    }
                    if (!ext.getExtensionId().equals(OIDMap.getOID((String)"x509.info.extensions.SubjectAlternativeName"))) continue;
                    sane = new SubjectAlternativeNameExtension(Boolean.valueOf(false), (Object)ext.getExtensionValue());
                    Vector v = (Vector)sane.get("subject_name");
                    Enumeration gne = v.elements();
                    while (gne.hasMoreElements()) {
                        GeneralNameInterface gni = (GeneralNameInterface)gne.nextElement();
                        if (!(gni instanceof GeneralName)) continue;
                        GeneralName genName = (GeneralName)gni;
                        String gn = genName.toString();
                        int colon = gn.indexOf(58);
                        String gnType = gn.substring(0, colon).trim();
                        String gnValue = gn.substring(colon + 1).trim();
                        authCreds.set(gnType, (Object)gnValue);
                    }
                }
            }
            if (authCreds != null) {
                req.put(AUTH_CREDS, (Object)authCreds);
            }
            try {
                if (sane == null) {
                    sane = this.makeDefaultSubjectAltName(sanehash);
                }
            }
            catch (Exception sane_e) {
                logger.warn("CRSEnrollment: " + CMS.getLogMessage((String)"CMSGW_ENROLL_FAIL_NO_SUBJ_ALT_NAME", (Object[])new Object[]{sane_e.getMessage()}), (Object)e);
            }
            try {
                if (this.mAppendDN != null && !this.mAppendDN.equals("")) {
                    new X500Name(subject.toString());
                    subject = new X500Name(subject.toString().concat("," + this.mAppendDN));
                }
            }
            catch (Exception sne) {
                logger.warn("CRSEnrollment: Unable to use appendDN parameter: " + this.mAppendDN + ". Error is " + sne.getMessage() + " Using unmodified subjectname", (Throwable)sne);
            }
            if (subject != null) {
                req.put(SUBJECTNAME, (Object)subject);
            }
            if (key == null || subject == null) {
                // empty if block
            }
            certInfo.set("version", (Object)new CertificateVersion(2));
            certInfo.set("subject", (Object)new CertificateSubjectName(subject));
            certInfo.set("key", (Object)new CertificateX509Key(key));
            CertificateExtensions ext = new CertificateExtensions();
            if (kue != null) {
                ext.set("KeyUsage", (Object)kue);
            }
            if (sane != null) {
                ext.set("SubjectAlternativeName", (Object)sane);
            }
            certInfo.set("extensions", (Object)ext);
            req.put(CERTINFO, (Object)certInfo);
        }
        catch (Exception e) {
            crsResp.setFailInfo("1");
            crsResp.setPKIStatus("2");
            return;
        }
    }

    private SubjectAlternativeNameExtension makeDefaultSubjectAltName(Hashtable<String, String> ht) {
        int itemCount = ht.size();
        GeneralNameInterface[] gn = new GeneralNameInterface[ht.size()];
        itemCount = 0;
        Enumeration<String> en = ht.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            if (key.equals(SANE_DNSNAME)) {
                gn[itemCount++] = new DNSName(ht.get(key));
            }
            if (!key.equals(SANE_IPADDRESS)) continue;
            gn[itemCount++] = new IPAddressName(ht.get(key));
        }
        try {
            return new SubjectAlternativeNameExtension(new GeneralNames(gn));
        }
        catch (Exception e) {
            logger.warn("CRSEnrollment: " + CMS.getLogMessage((String)"CMSGW_ENROLL_FAIL_NO_SUBJ_ALT_NAME", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            return null;
        }
    }

    private boolean authenticateUser(CRSPKIMessage req) {
        boolean authenticationFailed = true;
        if (this.mAuthManagerName == null) {
            return false;
        }
        String password = (String)req.get((Object)AUTH_PASSWORD);
        AuthCredentials authCreds = (AuthCredentials)req.get((Object)AUTH_CREDS);
        if (authCreds == null) {
            authCreds = new AuthCredentials();
        }
        AuthToken token = null;
        if (password != null && !password.equals("")) {
            try {
                authCreds.set(AUTH_PASSWORD, (Object)password);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            token = this.mAuthSubsystem.authenticate(authCreds, this.mAuthManagerName);
            authCreds.delete(AUTH_PASSWORD);
            authenticationFailed = false;
        }
        catch (EInvalidCredentials ex) {
            authenticationFailed = true;
        }
        catch (EMissingCredential mc) {
            authenticationFailed = false;
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        if (token != null) {
            req.put(AUTH_TOKEN, (Object)token);
        }
        return authenticationFailed;
    }

    private boolean areFingerprintsEqual(Request req, Hashtable<String, byte[]> fingerprints) {
        byte[] new_md5;
        Hashtable old_fprints = req.getExtDataInHashtable("fingerprints");
        if (old_fprints == null) {
            return false;
        }
        byte[] old_md5 = Utils.base64decode((String)((String)old_fprints.get("MD5")));
        if (old_md5.length != (new_md5 = fingerprints.get("MD5")).length) {
            return false;
        }
        for (int i = 0; i < old_md5.length; ++i) {
            if (old_md5[i] == new_md5[i]) continue;
            return false;
        }
        return true;
    }

    public X509CertImpl handlePKCSReq(HttpServletRequest httpReq, Request cmsRequest, CRSPKIMessage req, CRSPKIMessage crsResp, CryptoContext cx) throws Exception {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        try {
            this.unwrapPKCS10(req, cx);
            Hashtable<String, byte[]> fingerprints = this.makeFingerPrints(req);
            if (cmsRequest != null) {
                if (this.areFingerprintsEqual(cmsRequest, fingerprints)) {
                    logger.debug("created response from request");
                    return this.makeResponseFromRequest(req, crsResp, cmsRequest);
                }
                logger.warn("CRSEnrollment: " + CMS.getLogMessage((String)"CMSGW_ENROLL_FAIL_DUP_TRANS_ID", (Object[])new Object[0]));
                crsResp.setFailInfo("2");
                crsResp.setPKIStatus("2");
                return null;
            }
            this.getDetailFromRequest(req, crsResp);
            boolean authFailed = this.authenticateUser(req);
            if (authFailed) {
                logger.warn("CRSEnrollment: " + CMS.getLogMessage((String)"CMSGW_ENROLL_FAIL_NO_AUTH", (Object[])new Object[0]));
                crsResp.setFailInfo("7");
                crsResp.setPKIStatus("2");
                String auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_NON_PROFILE_CERT_REQUEST_5", (Object[])new Object[]{httpReq.getRemoteAddr(), "Failure", req.getTransactionID(), "CRSEnrollment", "<null>"});
                auditor.log(auditMessage);
                return null;
            }
            Request ireq = this.postRequest(httpReq, req, crsResp);
            logger.debug("created response");
            return this.makeResponseFromRequest(req, crsResp, ireq);
        }
        catch (CryptoContext.CryptoContextException e) {
            logger.warn("CRSEnrollment: " + CMS.getLogMessage((String)"CMSGW_ENROLL_FAIL_NO_DECRYPT_PKCS10", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            crsResp.setFailInfo("1");
            crsResp.setPKIStatus("2");
        }
        catch (EBaseException e) {
            logger.warn("CRSEnrollment: " + CMS.getLogMessage((String)"CMSGW_ERNOLL_FAIL_NO_NEW_REQUEST_POSTED", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            crsResp.setFailInfo("11");
            crsResp.setPKIStatus("2");
        }
        return null;
    }

    private Request postRequest(HttpServletRequest httpReq, CRSPKIMessage req, CRSPKIMessage crsResp) throws Exception {
        CAEngine engine = CAEngine.getInstance();
        X500Name subject = (X500Name)req.get((Object)SUBJECTNAME);
        if (this.mCreateEntry) {
            if (subject == null) {
                logger.error("CRSEnrollment::postRequest() - subject is null!");
                return null;
            }
            this.createEntry(subject.toString());
        }
        if (this.mProfileId != null) {
            PKCS10 pkcs10data = req.getP10();
            String pkcs10blob = Utils.base64encode((byte[])pkcs10data.toByteArray(), (boolean)true);
            logger.debug("Found profile=" + this.mProfileId);
            Profile profile = this.mProfileSubsystem.getProfile(this.mProfileId);
            if (profile == null) {
                logger.error("profile " + this.mProfileId + " not found");
                return null;
            }
            HashMap<String, String> ctx = new HashMap<String, String>();
            AuthManager authenticator = null;
            try {
                logger.debug("Retrieving authenticator");
                authenticator = this.mProfileSubsystem.getProfileAuthenticator(profile);
                if (authenticator == null) {
                    logger.debug("No authenticator Found");
                } else {
                    logger.debug("Got authenticator=" + authenticator.getClass().getName());
                }
            }
            catch (EProfileException eProfileException) {
                // empty catch block
            }
            AuthToken authToken = null;
            SessionContext context = SessionContext.getContext();
            context.put((Object)"profileContext", ctx);
            context.put((Object)"sslClientCertProvider", (Object)new SSLClientCertProvider(httpReq));
            String p10Password = this.getPasswordFromP10(pkcs10data);
            AuthCredentials credentials = new AuthCredentials();
            credentials.set("UID", (Object)httpReq.getRemoteAddr());
            credentials.set("PWD", (Object)p10Password);
            if (authenticator != null) {
                authToken = this.authenticate(credentials, authenticator, httpReq);
            }
            Request[] reqs = null;
            logger.debug("CRSEnrollment: Creating profile requests");
            ctx.put("cert_request_type", "pkcs10");
            ctx.put("cert_request", pkcs10blob);
            Locale locale = Locale.getDefault();
            reqs = profile.createRequests(ctx, locale);
            if (reqs == null) {
                logger.error("CRSEnrollment: No request has been created");
                return null;
            }
            logger.debug("CRSEnrollment: Request (" + reqs.length + ") have been created");
            reqs[0].setSourceId(req.getTransactionID());
            reqs[0].setExtData("profile", "true");
            reqs[0].setExtData("profileId", this.mProfileId);
            reqs[0].setExtData("cert_request_type", "pkcs10");
            reqs[0].setExtData("cert_request", pkcs10blob);
            reqs[0].setExtData("requestor_name", "");
            reqs[0].setExtData("requestor_email", "");
            reqs[0].setExtData("requestor_phone", "");
            reqs[0].setExtData("profileRemoteHost", httpReq.getRemoteHost());
            reqs[0].setExtData("profileRemoteAddr", httpReq.getRemoteAddr());
            reqs[0].setExtData("profileApprovedBy", profile.getApprovedBy());
            String setId = profile.getPolicySetId(reqs[0]);
            if (setId == null) {
                logger.debug("CRSEnrollment: setId null");
                throw new CRSFailureException("CRSEnrollment: profile policy setId not found");
            }
            logger.debug("CRSEnrollment: setId : " + setId);
            reqs[0].setExtData("profileSetId", setId);
            logger.debug("CRSEnrollment: Populating inputs");
            profile.populateInput(ctx, reqs[0]);
            logger.debug("CRSEnrollment: Populating requests");
            profile.populate(reqs[0]);
            logger.debug("CRSEnrollment: Submitting request");
            try {
                profile.submit(authToken, reqs[0]);
                engine.getRequestQueue().markAsServiced(reqs[0]);
                logger.debug("CRSEnrollment: Request marked as serviced");
            }
            catch (EDeferException e) {
                crsResp.setPKIStatus("3");
                reqs[0].setRequestStatus(RequestStatus.PENDING);
                RequestNotifier notify = engine.getRequestQueue().getPendingNotify();
                if (notify != null) {
                    notify.notify(reqs[0]);
                }
                logger.debug("CRSEnrollment: request is placed in pending mode");
            }
            logger.debug("CRSEnrollment: Done submitting request");
            return reqs[0];
        }
        CertRequestRepository requestRepository = engine.getCertRequestRepository();
        Request pkiReq = requestRepository.createRequest("enrollment");
        AuthToken token = (AuthToken)req.get((Object)AUTH_TOKEN);
        if (token != null) {
            pkiReq.setExtData("AUTH_TOKEN", token);
        }
        pkiReq.setExtData("HTTP_PARAMS", "certType", "CEP-Request");
        X509CertInfo certInfo = (X509CertInfo)req.get((Object)CERTINFO);
        pkiReq.setExtData("CERT_INFO", new X509CertInfo[]{certInfo});
        pkiReq.setExtData("cepsubstore", this.mSubstoreName);
        try {
            String chpwd = (String)req.get((Object)"ChallengePassword");
            if (chpwd != null) {
                pkiReq.setExtData("challengePhrase", chpwd);
            }
        }
        catch (Exception chpwd) {
            // empty catch block
        }
        Hashtable fingerprints = (Hashtable)req.get((Object)"fingerprints");
        if (fingerprints.size() > 0) {
            Hashtable<String, String> encodedPrints = new Hashtable<String, String>(fingerprints.size());
            Enumeration e = fingerprints.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                byte[] value = (byte[])fingerprints.get(key);
                encodedPrints.put(key, Utils.base64encode((byte[])value, (boolean)true));
            }
            pkiReq.setExtData("fingerprints", encodedPrints);
        }
        pkiReq.setSourceId(req.getTransactionID());
        RequestQueue rq = engine.getRequestQueue();
        rq.processRequest(pkiReq);
        crsResp.setPKIStatus("0");
        logger.info("Enrollment request reqID {} {} authenticated by {} is {}. DN requested: {} {}", new Object[]{pkiReq.getRequestId(), "fromRouter", this.mAuthManagerName == null ? "noAuthManager" : this.mAuthManagerName, "pending", subject, ""});
        return pkiReq;
    }

    public Hashtable<String, byte[]> makeFingerPrints(CRSPKIMessage req) {
        Hashtable<String, byte[]> fingerprints = new Hashtable<String, byte[]>();
        String[] hashes = new String[]{"MD2", "MD5", "SHA1", "SHA256", "SHA512"};
        PKCS10 p10 = req.getP10();
        for (int i = 0; i < hashes.length; ++i) {
            try {
                MessageDigest md = MessageDigest.getInstance(hashes[i]);
                md.update(p10.getCertRequestInfo());
                fingerprints.put(hashes[i], md.digest());
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        if (fingerprints != null) {
            req.put("fingerprints", fingerprints);
        }
        return fingerprints;
    }

    private X509CertImpl makeResponseFromRequest(CRSPKIMessage crsReq, CRSPKIMessage crsResp, Request pkiReq) {
        X509CertImpl issuedCert = null;
        RequestStatus status = pkiReq.getRequestStatus();
        String profileId = pkiReq.getExtDataInString("profileId");
        if (profileId != null) {
            logger.debug("CRSEnrollment: Found profile request");
            X509CertImpl cert = pkiReq.getExtDataInCert("req_issued_cert");
            if (cert == null) {
                logger.debug("CRSEnrollment: No certificate has been found");
            } else {
                logger.debug("CRSEnrollment: Found certificate");
            }
            crsResp.setPKIStatus("0");
            return cert;
        }
        if (status.equals((Object)RequestStatus.COMPLETE)) {
            Integer success = pkiReq.getExtDataInInteger("Result");
            if (success.equals(Request.RES_SUCCESS)) {
                X509CertImpl[] issuedCertBuf = pkiReq.getExtDataInCertArray("issuedCerts");
                if (issuedCertBuf == null || issuedCertBuf.length == 0) {
                    logger.error("CRSEnrollment::makeResponseFromRequest() - Bad operation");
                    return null;
                }
                issuedCert = issuedCertBuf[0];
                crsResp.setPKIStatus("0");
            } else {
                crsResp.setPKIStatus("2");
                crsResp.setFailInfo("0");
            }
        } else if (status == RequestStatus.REJECTED || status == RequestStatus.CANCELED) {
            crsResp.setPKIStatus("2");
            crsResp.setFailInfo("2");
        } else {
            crsResp.setPKIStatus("3");
        }
        return issuedCert;
    }

    protected String hashPassword(String pwd) {
        String salt = "lala123";
        byte[] pwdDigest = this.mSHADigest.digest((salt + pwd).getBytes());
        String b64E = Utils.base64encode((byte[])pwdDigest, (boolean)true);
        return "{SHA-256}" + b64E;
    }

    private void processCertRep(CryptoContext cx, X509CertImpl issuedCert, CRSPKIMessage crsResp, CRSPKIMessage crsReq) throws CRSFailureException {
        byte[] msgdigest = null;
        byte[] encryptedDesKey = null;
        try {
            if (issuedCert != null) {
                SymmetricKey.Type skt;
                EncryptionAlgorithm ea = switch (String.valueOf(this.mEncryptionAlgorithm)) {
                    case "DES3" -> {
                        skt = SymmetricKey.DES3;
                        yield EncryptionAlgorithm.DES3_CBC;
                    }
                    case "AES" -> {
                        skt = SymmetricKey.AES;
                        yield EncryptionAlgorithm.AES_128_CBC;
                    }
                    default -> {
                        skt = SymmetricKey.DES;
                        yield EncryptionAlgorithm.DES_CBC;
                    }
                };
                byte[] toBeEncrypted = crsResp.makeSignedRep(1, issuedCert.getEncoded());
                SymmetricKey sk = cx.getKeyGenerator().generate();
                byte[] padded = Cipher.pad((byte[])toBeEncrypted, (int)ea.getBlockSize());
                Cipher cipher = cx.getInternalToken().getCipherContext(ea);
                byte[] iv = new byte[ea.getBlockSize()];
                SecureRandom random = new SecureRandom();
                random.nextBytes(iv);
                IVParameterSpec desIV = new IVParameterSpec(iv);
                cipher.initEncrypt(sk, (AlgorithmParameterSpec)desIV);
                byte[] encryptedData = cipher.doFinal(padded);
                crsResp.makeEncryptedContentInfo(desIV.getIV(), encryptedData, this.mEncryptionAlgorithm);
                PublicKey rcpPK = crsReq.getSignerPublicKey();
                SymmetricKey skinternal = this.moveSymmetricToInternalToken(cx, sk, skt, ea);
                KeyWrapper kw = cx.getInternalKeyWrapper();
                OAEPParameterSpec keyWrapConfig = null;
                if (this.mUseOAEPKeyWrap) {
                    keyWrapConfig = new OAEPParameterSpec(OAEP_SHA, "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
                }
                kw.initWrap(rcpPK, keyWrapConfig);
                encryptedDesKey = kw.wrap(skinternal);
                crsResp.setRcpIssuerAndSerialNumber(crsReq.getSgnIssuerAndSerialNumber());
                crsResp.makeRecipientInfo(0, encryptedDesKey);
            }
            byte[] ed = crsResp.makeEnvelopedData(0);
            MessageDigest md = MessageDigest.getInstance(this.mHashAlgorithm);
            msgdigest = md.digest(ed);
            crsResp.setMsgDigest(msgdigest);
        }
        catch (Exception e) {
            throw new CRSFailureException("Failed to create inner response to CEP message: " + e.getMessage());
        }
        try {
            crsResp.setTransactionID(crsReq.getTransactionID());
            crsResp.makeAuthenticatedAttributes();
            byte[] signingcertbytes = cx.getSigningCert().getEncoded();
            Certificate.Template sgncertT = new Certificate.Template();
            Certificate sgncert = (Certificate)sgncertT.decode((InputStream)new ByteArrayInputStream(signingcertbytes));
            IssuerAndSerialNumber sgniasn = new IssuerAndSerialNumber(sgncert.getInfo().getIssuer(), sgncert.getInfo().getSerialNumber());
            crsResp.setSgnIssuerAndSerialNumber(sgniasn);
            crsResp.makeSignerInfo(1, cx.getPrivateKey(), this.mHashAlgorithm);
            crsResp.makeSignedData(1, signingcertbytes, this.mHashAlgorithm);
            crsResp.debug();
        }
        catch (Exception e) {
            throw new CRSFailureException("Failed to create outer response to CEP request: " + e.getMessage());
        }
    }

    class CryptoContext {
        private CryptoManager cm;
        private CryptoToken internalToken;
        private CryptoToken keyStorageToken;
        private CryptoToken internalKeyStorageToken = null;
        private KeyGenerator keyGen;
        private Enumeration<?> externalTokens = null;
        private X509Certificate signingCert;
        private PrivateKey signingCertPrivKey;
        private int signingCertKeySize;

        public CryptoContext() throws CryptoContextException {
            try {
                KeyGenAlgorithm kga = switch (String.valueOf(CRSEnrollment.this.mEncryptionAlgorithm)) {
                    case "DES3" -> KeyGenAlgorithm.DES3;
                    case "AES" -> KeyGenAlgorithm.AES;
                    default -> KeyGenAlgorithm.DES;
                };
                this.cm = CryptoManager.getInstance();
                this.internalToken = this.cm.getInternalCryptoToken();
                this.keyGen = this.internalToken.getKeyGenerator(kga);
                if (kga.equals(KeyGenAlgorithm.AES)) {
                    this.keyGen.initialize(128);
                }
                this.keyStorageToken = CryptoUtil.getKeyStorageToken((String)CRSEnrollment.this.mTokenName);
                if (CryptoUtil.isInternalToken((String)CRSEnrollment.this.mTokenName)) {
                    this.internalKeyStorageToken = this.keyStorageToken;
                    logger.debug("CRSEnrollment: CryptoContext: internal token name: '" + CRSEnrollment.this.mTokenName + "'");
                }
                if (!CRSEnrollment.this.mUseCA && this.internalKeyStorageToken == null) {
                    PWCBsdr cb = new PWCBsdr();
                    this.keyStorageToken.login((PasswordCallback)cb);
                }
                this.signingCert = this.cm.findCertByNickname(CRSEnrollment.this.mNickname);
                this.signingCertPrivKey = this.cm.findPrivKeyByCert(this.signingCert);
                byte[] encPubKeyInfo = this.signingCert.getPublicKey().getEncoded();
                SEQUENCE.Template outer = SEQUENCE.getTemplate();
                outer.addElement((ASN1Template)ANY.getTemplate());
                outer.addElement((ASN1Template)BIT_STRING.getTemplate());
                SEQUENCE outerSeq = (SEQUENCE)ASN1Util.decode((ASN1Template)outer, (byte[])encPubKeyInfo);
                BIT_STRING bs = (BIT_STRING)outerSeq.elementAt(1);
                byte[] encPubKey = bs.getBits();
                if (bs.getPadCount() != 0) {
                    throw new CryptoContextException("Internal error: Invalid Public key. Not an integral number of bytes.");
                }
                SEQUENCE.Template inner = new SEQUENCE.Template();
                inner.addElement(INTEGER.getTemplate());
                inner.addElement(INTEGER.getTemplate());
                SEQUENCE pubKeySeq = (SEQUENCE)ASN1Util.decode((ASN1Template)inner, (byte[])encPubKey);
                INTEGER modulus = (INTEGER)pubKeySeq.elementAt(0);
                this.signingCertKeySize = modulus.bitLength();
                try (FileOutputStream fos = new FileOutputStream("pubkey.der");){
                    fos.write(this.signingCert.getPublicKey().getEncoded());
                }
                catch (Exception e) {
                    logger.warn("Unable to store public key: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (InvalidBERException e) {
                throw new CryptoContextException("Internal Error: Bad internal Certificate Representation. Not a valid RSA-signed certificate");
            }
            catch (NotInitializedException e) {
                throw new CryptoContextException("Crypto Manager not initialized");
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoContextException("Cannot create DES key generator");
            }
            catch (ObjectNotFoundException e) {
                throw new CryptoContextException("Certificate not found: " + CRSEnrollment.this.ca.getNickname());
            }
            catch (TokenException e) {
                throw new CryptoContextException("Problem with Crypto Token: " + e.getMessage());
            }
            catch (NoSuchTokenException e) {
                throw new CryptoContextException("Crypto Token not found: " + e.getMessage());
            }
            catch (IncorrectPasswordException e) {
                throw new CryptoContextException("Incorrect Password.");
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CryptoContextException("Invalid algorithm parameter: " + e.getMessage());
            }
        }

        public KeyGenerator getKeyGenerator() {
            return this.keyGen;
        }

        public CryptoToken getInternalToken() {
            return this.internalToken;
        }

        public void setExternalTokens(Enumeration<?> tokens) {
            this.externalTokens = tokens;
        }

        public Enumeration<?> getExternalTokens() {
            return this.externalTokens;
        }

        public CryptoToken getInternalKeyStorageToken() {
            return this.internalKeyStorageToken;
        }

        public CryptoToken getKeyStorageToken() {
            return this.keyStorageToken;
        }

        public CryptoManager getCryptoManager() {
            return this.cm;
        }

        public KeyWrapper getKeyWrapper() throws CryptoContextException {
            KeyWrapAlgorithm keyWrapAlg = KeyWrapAlgorithm.RSA;
            if (CRSEnrollment.this.mUseOAEPKeyWrap) {
                keyWrapAlg = KeyWrapAlgorithm.RSA_OAEP;
            }
            try {
                return this.signingCertPrivKey.getOwningToken().getKeyWrapper(keyWrapAlg);
            }
            catch (TokenException e) {
                throw new CryptoContextException("Problem with Crypto Token: " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoContextException(e.getMessage());
            }
        }

        public KeyWrapper getInternalKeyWrapper() throws CryptoContextException {
            KeyWrapAlgorithm keyWrapAlg = KeyWrapAlgorithm.RSA;
            if (CRSEnrollment.this.mUseOAEPKeyWrap) {
                keyWrapAlg = KeyWrapAlgorithm.RSA_OAEP;
            }
            try {
                return this.getInternalToken().getKeyWrapper(keyWrapAlg);
            }
            catch (TokenException e) {
                throw new CryptoContextException("Problem with Crypto Token: " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoContextException(e.getMessage());
            }
        }

        public PrivateKey getPrivateKey() {
            return this.signingCertPrivKey;
        }

        public X509Certificate getSigningCert() {
            return this.signingCert;
        }

        class CryptoContextException
        extends Exception {
            private static final long serialVersionUID = -1124116326126256475L;

            public CryptoContextException() {
            }

            public CryptoContextException(String s) {
                super(s);
            }
        }
    }

    class CRSInvalidSignatureException
    extends Exception {
        private static final long serialVersionUID = 9096408193567657944L;

        public CRSInvalidSignatureException() {
        }

        public CRSInvalidSignatureException(String s) {
            super(s);
        }
    }

    class CRSFailureException
    extends Exception {
        private static final long serialVersionUID = 1962741611501549051L;

        public CRSFailureException() {
        }

        public CRSFailureException(String s) {
            super(s);
        }
    }

    class CRSPolicyException
    extends Exception {
        private static final long serialVersionUID = 5846593800658787396L;

        public CRSPolicyException() {
        }

        public CRSPolicyException(String s) {
            super(s);
        }
    }
}

