/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.profile;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileConfig;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.registry.PluginInfo;
import com.netscape.cmscore.registry.PluginRegistry;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;

public abstract class AbstractProfileSubsystem
extends Subsystem {
    protected static final String PROP_CHECK_OWNER = "checkOwner";
    protected static final String PROP_ENABLE = "enable";
    protected static final String PROP_ENABLE_BY = "enableBy";
    protected ConfigStore mConfig;
    protected LinkedHashMap<String, Profile> mProfiles = new LinkedHashMap();
    protected Hashtable<String, String> mProfileClassIds = new Hashtable();

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public String getId() {
        return null;
    }

    public void setId(String id) throws EBaseException {
    }

    public boolean isProfileEnable(String id) throws EBaseException {
        Profile profile = this.mProfiles.get(id);
        String enable = profile.getConfigStore().getString(PROP_ENABLE, null);
        return Boolean.valueOf(enable);
    }

    public String getProfileEnableBy(String id) throws EBaseException {
        if (!this.isProfileEnable(id)) {
            return null;
        }
        Profile profile = this.mProfiles.get(id);
        return profile.getConfigStore().getString(PROP_ENABLE_BY, null);
    }

    public void enableProfile(String id, String enableBy) throws EProfileException {
        Profile profile = this.mProfiles.get(id);
        profile.getConfigStore().putString(PROP_ENABLE, "true");
        profile.getConfigStore().putString(PROP_ENABLE_BY, enableBy);
    }

    public Profile getProfile(String id) throws EProfileException {
        return this.mProfiles.get(id);
    }

    public void disableProfile(String id) throws EProfileException {
        Profile profile = this.mProfiles.get(id);
        profile.getConfigStore().putString(PROP_ENABLE, "false");
    }

    public synchronized void commitProfile(String id) throws EProfileException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig engineConfig = engine.getConfig();
        PluginRegistry registry = engine.getPluginRegistry();
        ProfileConfig profileConfig = this.mProfiles.get(id).getConfigStore();
        String classId = this.mProfileClassIds.get(id);
        PluginInfo info = registry.getPluginInfo("profile", classId);
        String className = info.getClassName();
        Profile newProfile = null;
        try {
            newProfile = (Profile)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new EProfileException("Could not instantiate class '" + classId + "' for profile '" + id + "': " + e.getMessage(), (Throwable)e);
        }
        newProfile.setId(id);
        try {
            newProfile.init(engineConfig, registry, profileConfig);
        }
        catch (EBaseException e) {
            throw new EProfileException("Failed to initialise profile '" + id + "': " + e);
        }
        this.mProfiles.put(id, newProfile);
        this.commitConfigStore(id, profileConfig);
    }

    protected void commitConfigStore(String id, ConfigStore cs) throws EProfileException {
        try {
            cs.commit(false);
        }
        catch (EBaseException e) {
            throw new EProfileException("Failed to commit config store of profile '" + id + ": " + e, (Throwable)e);
        }
    }

    public String getProfileClassId(String id) {
        return this.mProfileClassIds.get(id);
    }

    public AuthManager getProfileAuthenticator(Profile profile) throws EBaseException {
        String authenticatorID = profile.getAuthenticatorId();
        if (StringUtils.isEmpty((CharSequence)authenticatorID)) {
            return null;
        }
        CAEngine engine = CAEngine.getInstance();
        AuthSubsystem authSub = engine.getAuthSubsystem();
        AuthManager auth = authSub.get(authenticatorID);
        if (auth == null) {
            throw new EProfileException("Unable to load authenticator: " + authenticatorID);
        }
        return auth;
    }

    public Enumeration<String> getProfileIds() {
        return Collections.enumeration(this.mProfiles.keySet());
    }

    public boolean checkOwner() {
        try {
            return this.mConfig.getBoolean(PROP_CHECK_OWNER, false);
        }
        catch (EBaseException e) {
            return false;
        }
    }
}

