/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.rest;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.UnauthorizedException;
import com.netscape.certsrv.cert.AgentCertResource;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.cert.CertNotFoundException;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRetrievalRequest;
import com.netscape.certsrv.cert.CertRevokeRequest;
import com.netscape.certsrv.dbs.EDBRecordNotFoundException;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cms.servlet.cert.RevocationProcessor;
import com.netscape.cms.servlet.processors.CAProcessor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.RevocationInfo;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.JssSubsystem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.catalina.realm.GenericPrincipal;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.rest.CertRequestDAO;
import org.mozilla.jss.netscape.security.pkcs.ContentInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.pkcs.SignerInfo;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509ExtensionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentCertService
extends PKIService
implements AgentCertResource {
    public static final Logger logger = LoggerFactory.getLogger(AgentCertService.class);
    CertificateAuthority authority;
    CertificateRepository repo;
    SecureRandom random;

    public AgentCertService() {
        CAEngine engine = CAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        this.authority = engine.getCA();
        if (engine.getEnableNonces()) {
            this.random = jssSubsystem.getRandomNumberGenerator();
        }
        this.repo = engine.getCertificateRepository();
    }

    public Response reviewCert(CertId id) {
        logger.info("Reviewing certificate " + id.toHexString());
        return this.createOKResponse(this.getCertData(id, true));
    }

    CertData getCertData(CertId id) {
        return this.getCertData(id, false);
    }

    CertData getCertData(CertId id, boolean generateNonce) {
        if (id == null) {
            throw new BadRequestException("Unable to get certificate: Missing certificate ID");
        }
        CertRetrievalRequest data = new CertRetrievalRequest(id);
        CertData certData = null;
        try {
            certData = this.getCert(data, generateNonce);
        }
        catch (EDBRecordNotFoundException e) {
            throw new CertNotFoundException(id);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
        return certData;
    }

    public Response revokeCACert(CertId id, CertRevokeRequest request) {
        logger.info("Revoking CA certificate " + id.toHexString());
        return this.revokeCert(id, request, true);
    }

    public Response revokeCert(CertId id, CertRevokeRequest request) {
        logger.info("Revoking certificate " + id.toHexString());
        return this.revokeCert(id, request, false);
    }

    Response revokeCert(CertId id, CertRevokeRequest request, boolean caCert) {
        RevocationProcessor processor;
        if (id == null) {
            logger.warn("Unable to revoke cert: Missing certificate ID");
            throw new BadRequestException("Unable to revoke cert: Missing certificate ID");
        }
        if (request == null) {
            logger.warn("revokeCert: request is null");
            throw new BadRequestException("Unable to revoke cert: invalid request");
        }
        CertData data = this.getCertData(id);
        RevocationReason revReason = RevocationReason.valueOf((String)request.getReason());
        if (revReason == RevocationReason.REMOVE_FROM_CRL) {
            return this.unrevokeCert(id);
        }
        CAEngine engine = CAEngine.getInstance();
        X500Name caX500DN = null;
        try {
            processor = new RevocationProcessor("caDoRevoke-agent", this.getLocale(this.headers));
            processor.setCMSEngine(engine);
            processor.init();
            processor.setStartTime(new Date().getTime());
            processor.setInitiative("fromAgent");
            processor.setSerialNumber(id);
            processor.setRevocationReason(revReason);
            processor.setRequestType(revReason == RevocationReason.CERTIFICATE_HOLD ? "on-hold" : "revoke");
            processor.setInvalidityDate(request.getInvalidityDate());
            processor.setComments(request.getComments());
            processor.setAuthority(this.authority);
            caX500DN = this.authority.getCACert().getSubjectName();
        }
        catch (EBaseException e) {
            logger.error("Unable to revoke certificate: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to revoke certificate: " + e.getMessage(), (Throwable)e);
        }
        try {
            X509Certificate clientCert = null;
            try {
                clientCert = CAProcessor.getSSLClientCertificate(this.servletRequest);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            CertRecord clientRecord = null;
            BigInteger clientSerialNumber = null;
            String clientSubjectDN = null;
            if (clientCert != null) {
                clientSerialNumber = clientCert.getSerialNumber();
                clientSubjectDN = clientCert.getSubjectDN().toString();
                X500Name x500issuerDN = (X500Name)clientCert.getIssuerDN();
                if (x500issuerDN.equals((Object)caX500DN)) {
                    logger.info("CertService.revokeCert: client cert issued by this CA");
                    clientRecord = processor.getCertificateRecord(clientSerialNumber);
                    if (clientRecord.getStatus().equals("REVOKED")) {
                        throw new UnauthorizedException(CMS.getLogMessage((String)"CMSGW_UNAUTHORIZED", (Object[])new Object[0]));
                    }
                } else {
                    logger.info("CertService.revokeCert: client cert not issued by this CA");
                    if (engine.getAllowExtCASignedAgentCerts()) {
                        logger.info("CertService.revokeCert: allowExtCASignedAgentCerts true;");
                    } else {
                        logger.error("CertService.revokeCert: allowExtCASignedAgentCerts false;");
                        throw new UnauthorizedException(CMS.getLogMessage((String)"CMSGW_UNAUTHORIZED", (Object[])new Object[0]));
                    }
                }
            }
            if (engine.getEnableNonces() && !processor.isMemberOfSubsystemGroup(clientCert)) {
                processor.validateNonce(this.servletRequest, "cert-revoke", id.toBigInteger(), request.getNonce());
            }
            CertRecord targetRecord = clientRecord != null && id.toBigInteger().equals(clientSerialNumber) ? clientRecord : processor.getCertificateRecord(id);
            X509CertImpl targetCert = targetRecord.getCertificate();
            processor.createCRLExtension();
            GenericPrincipal principal = (GenericPrincipal)this.servletRequest.getUserPrincipal();
            String subjectDN = principal.hasRole("Certificate Manager Agents") ? null : clientSubjectDN;
            processor.validateCertificateToRevoke(subjectDN, targetRecord, caCert);
            processor.addCertificateToRevoke(targetCert);
            processor.createRevocationRequest();
            processor.auditChangeRequest("Success");
        }
        catch (PKIException e) {
            logger.warn("Unable to pre-process revocation request: " + e.getMessage());
            processor.auditChangeRequest("Failure");
            throw e;
        }
        catch (EBaseException e) {
            logger.error("Unable to pre-process revocation request: " + e.getMessage(), (Throwable)e);
            processor.auditChangeRequest("Failure");
            throw new PKIException("Unable to revoke cert: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to pre-process revocation request: " + e.getMessage(), (Throwable)e);
            processor.auditChangeRequest("Failure");
            throw new PKIException("Unable to revoke cert: " + e.getMessage(), (Throwable)e);
        }
        try {
            processor.processRevocationRequest();
            processor.auditChangeRequestProcessed("Success");
        }
        catch (EBaseException e) {
            logger.error("Unable to process revocation request: " + e.getMessage(), (Throwable)e);
            processor.auditChangeRequestProcessed("Failure");
            throw new PKIException("Unable to revoke certificate: " + e.getMessage(), (Throwable)e);
        }
        try {
            Request certRequest = processor.getRequest();
            CertRequestDAO dao = new CertRequestDAO();
            CertRequestInfo requestInfo = dao.getRequest(certRequest.getRequestId(), this.uriInfo);
            return this.createOKResponse(requestInfo);
        }
        catch (EBaseException e) {
            logger.error("Unable to create revocation response: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to create revocation response: " + e.getMessage(), (Throwable)e);
        }
    }

    public Response unrevokeCert(CertId id) {
        RevocationProcessor processor;
        if (id == null) {
            logger.warn("Unable to unrevoke certificate: Missing certificate ID");
            throw new BadRequestException("Unable to unrevoke certificate: Missing certificate ID");
        }
        logger.info("Unrevoking certificate " + id.toHexString());
        if (this.request == null) {
            logger.warn("unrevokeCert: request is null");
            throw new BadRequestException("Unable to unrevoke cert: invalid request");
        }
        CertData data = this.getCertData(id);
        CAEngine engine = (CAEngine)this.getCMSEngine();
        try {
            processor = new RevocationProcessor("caDoUnrevoke", this.getLocale(this.headers));
            processor.setCMSEngine(engine);
            processor.init();
            processor.setInitiative("fromAgent");
            processor.setSerialNumber(id);
            processor.setRevocationReason(RevocationReason.CERTIFICATE_HOLD);
            processor.setAuthority(this.authority);
        }
        catch (EBaseException e) {
            logger.error("Unable to create revocation processor: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to unrevoke certificate: " + e.getMessage(), (Throwable)e);
        }
        try {
            processor.addSerialNumberToUnrevoke(id.toBigInteger());
            processor.createUnrevocationRequest();
            processor.auditChangeRequest("Success");
        }
        catch (EBaseException e) {
            logger.error("Unable to pre-process unrevocation request: " + e.getMessage(), (Throwable)e);
            processor.auditChangeRequest("Failure");
            throw new PKIException("Unable to unrevoke certificate: " + e.getMessage(), (Throwable)e);
        }
        try {
            processor.processUnrevocationRequest();
            processor.auditChangeRequestProcessed("Success");
        }
        catch (EBaseException e) {
            logger.error("Unable to process unrevocation request: " + e.getMessage(), (Throwable)e);
            processor.auditChangeRequestProcessed("Failure");
            throw new PKIException("Unable to unrevoke certificate: " + e.getMessage(), (Throwable)e);
        }
        try {
            Request certRequest = processor.getRequest();
            CertRequestDAO dao = new CertRequestDAO();
            return this.createOKResponse(dao.getRequest(certRequest.getRequestId(), this.uriInfo));
        }
        catch (EBaseException e) {
            logger.error("Unable to create unrevocation response: " + e.getMessage(), (Throwable)e);
            throw new PKIException("Unable to create unrevocation response: " + e.getMessage(), (Throwable)e);
        }
    }

    CertData getCert(CertRetrievalRequest data, boolean generateNonce) throws Exception {
        CRLExtensions revExts;
        Date notAfter;
        X500Name subjectDN;
        CAEngine engine = CAEngine.getInstance();
        CertId certId = data.getCertId();
        CertRecord record = this.repo.readCertificateRecord(certId.toBigInteger());
        X509CertImpl cert = record.getCertificate();
        CertData certData = new CertData();
        certData.setSerialNumber(certId);
        X500Name issuerDN = cert.getIssuerName();
        if (issuerDN != null) {
            certData.setIssuerDN(issuerDN.toString());
        }
        if ((subjectDN = cert.getSubjectName()) != null) {
            certData.setSubjectDN(subjectDN.toString());
        }
        String base64 = CertUtil.toPEM((X509Certificate)cert);
        certData.setEncoded(base64);
        CertPrettyPrint print = new CertPrettyPrint((Certificate)cert);
        certData.setPrettyPrint(print.toString(this.getLocale(this.headers)));
        X509Certificate[] certChain = engine.getCertChain((X509Certificate)cert);
        PKCS7 pkcs7 = new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), certChain, new SignerInfo[0]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        pkcs7.encodeSignedData((OutputStream)bos, false);
        byte[] p7Bytes = bos.toByteArray();
        String p7Str = Utils.base64encode((byte[])p7Bytes, (boolean)true);
        certData.setPkcs7CertChain(p7Str);
        Date notBefore = cert.getNotBefore();
        if (notBefore != null) {
            certData.setNotBefore(notBefore.toString());
        }
        if ((notAfter = cert.getNotAfter()) != null) {
            certData.setNotAfter(notAfter.toString());
        }
        certData.setRevokedOn(record.getRevokedOn());
        certData.setRevokedBy(record.getRevokedBy());
        RevocationInfo revInfo = record.getRevocationInfo();
        if (revInfo != null && (revExts = revInfo.getCRLEntryExtensions()) != null) {
            try {
                CRLReasonExtension ext = (CRLReasonExtension)revExts.get("CRLReason");
                certData.setRevocationReason(Integer.valueOf(ext.getReason().getCode()));
            }
            catch (X509ExtensionException x509ExtensionException) {
                // empty catch block
            }
        }
        certData.setStatus(record.getStatus());
        if (engine.getEnableNonces() && generateNonce) {
            long n = this.random.nextLong();
            Map<Object, Long> nonces = engine.getNonces(this.servletRequest, "cert-revoke");
            nonces.put(certId.toBigInteger(), n);
            certData.setNonce(Long.valueOf(n));
        }
        return certData;
    }
}

