/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.authentication.DirBasedAuthentication;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.request.Request;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidPwdPinDirAuthentication
extends DirBasedAuthentication {
    public static Logger logger = LoggerFactory.getLogger(UidPwdPinDirAuthentication.class);
    public static final String CRED_UID = "uid";
    public static final String CRED_PWD = "pwd";
    public static final String CRED_PIN = "pin";
    protected static String[] mRequiredCreds = new String[]{"uid", "pwd", "pin"};
    public static final String PROP_REMOVE_PIN = "removePin";
    public static final String PROP_PIN_ATTR = "pinAttr";
    public static final boolean DEF_REMOVE_PIN = false;
    public static final String DEF_PIN_ATTR = "pin";
    protected static final byte SENTINEL_SHA = 0;
    protected static final byte SENTINEL_MD5 = 1;
    protected static final byte SENTINEL_SHA256 = 2;
    protected static final byte SENTINEL_NONE = 45;
    protected static String[] mConfigParams = new String[]{"removePin", "pinAttr", "dnpattern", "ldapStringAttributes", "ldapByteAttributes", "ldap.ldapconn.host", "ldap.ldapconn.port", "ldap.ldapconn.secureConn", "ldap.ldapconn.version", "ldap.ldapauth.bindDN", "ldap.ldapauth.bindPWPrompt", "ldap.ldapauth.clientCertNickname", "ldap.ldapauth.authtype", "ldap.basedn", "ldap.minConns", "ldap.maxConns"};
    protected boolean mRemovePin = false;
    protected String mPinAttr = "pin";
    protected MessageDigest mSHADigest = null;
    protected MessageDigest mMD5Digest = null;
    protected MessageDigest mSHA256Digest = null;
    private LdapBoundConnFactory removePinLdapFactory;
    private LDAPConnection removePinLdapConnection;
    private LDAPConfig removePinLdapConfigStore;

    @Override
    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        super.init(authenticationConfig, name, implName, config);
        EngineConfig cs = this.engine.getConfig();
        this.mRemovePin = config.getBoolean(PROP_REMOVE_PIN, false);
        this.mPinAttr = config.getString(PROP_PIN_ATTR, "pin");
        if (this.mPinAttr.equals("")) {
            this.mPinAttr = "pin";
        }
        if (this.mRemovePin) {
            PKISocketConfig socketConfig = cs.getSocketConfig();
            this.removePinLdapConfigStore = config.getLDAPConfig();
            this.removePinLdapFactory = new LdapBoundConnFactory("UidPwdPinDirAuthentication");
            this.removePinLdapFactory.setCMSEngine(this.engine);
            this.removePinLdapFactory.init(socketConfig, this.removePinLdapConfigStore, this.engine.getPasswordStore());
            this.removePinLdapConnection = this.removePinLdapFactory.getConn();
        }
        try {
            this.mSHADigest = MessageDigest.getInstance("SHA1");
            this.mMD5Digest = MessageDigest.getInstance("MD5");
            this.mSHA256Digest = MessageDigest.getInstance("SHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.getMessage()));
        }
    }

    protected void verifyPassword(String Password2) {
    }

    @Override
    protected String authenticate(LDAPConnection conn, AuthCredentials authCreds, AuthToken token) throws EBaseException {
        String userdn = null;
        String uid = null;
        String pwd = null;
        String pin = null;
        try {
            uid = (String)authCreds.get(CRED_UID);
            if (uid == null) {
                throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", CRED_UID));
            }
            pwd = (String)authCreds.get(CRED_PWD);
            if (pwd == null) {
                throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", CRED_PWD));
            }
            if (pwd.equals("")) {
                logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_EMPTY_PASSWORD", uid));
                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
            }
            pin = (String)authCreds.get("pin");
            if (pin == null) {
                throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", "pin"));
            }
            if (pin.equals("")) {
                logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_EMPTY_PIN", uid));
                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
            }
            LDAPSearchResults res = conn.search(this.mBaseDN, 2, "(uid=" + uid + ")", null, false);
            if (!res.hasMoreElements()) {
                logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_USER_NOT_EXIST", uid));
                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
            }
            LDAPEntry entry = (LDAPEntry)res.nextElement();
            userdn = entry.getDN();
            conn.authenticate(userdn, pwd);
            logger.info("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_AUTHENTICATED", uid));
            this.checkpin(conn, userdn, uid, pin);
            token.set(CRED_UID, uid);
            return userdn;
        }
        catch (ELdapException e) {
            logger.error("Authenticating: closing bad connection: " + e.getMessage(), (Throwable)e);
            try {
                conn.disconnect();
            }
            catch (Exception f) {
                logger.warn("Authenticating: conn.disconnect() exception: " + f.getMessage(), (Throwable)f);
            }
            logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CANNOT_CONNECT_LDAP", e.toString()));
            throw e;
        }
        catch (LDAPException e) {
            logger.error("Authenticating: closing bad connection: " + e.getMessage(), (Throwable)e);
            try {
                conn.disconnect();
            }
            catch (Exception f) {
                logger.warn("Authenticating: conn.disconnect() exception: " + f.getMessage(), (Throwable)f);
            }
            switch (e.getLDAPResultCode()) {
                case 9: 
                case 32: {
                    logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_USER_NOT_EXIST", uid));
                    throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                }
                case 49: {
                    logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_BAD_PASSWORD", uid));
                    throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                }
                case 81: {
                    logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("LDAP_SERVER_DOWN", new Object[0]));
                    throw new ELdapException(CMS.getUserMessage("CMS_LDAP_SERVER_UNAVAILABLE", conn.getHost(), "" + conn.getPort()));
                }
            }
            logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("OPERATION_ERROR", e.getMessage()));
            throw new ELdapException(CMS.getUserMessage("CMS_LDAP_OTHER_LDAP_EXCEPTION", e.errorCodeToString()));
        }
    }

    protected void checkpin(LDAPConnection conn, String userdn, String uid, String pin) throws EBaseException, LDAPException {
        int i;
        LDAPSearchResults res = null;
        LDAPEntry entry = null;
        res = conn.search(userdn, 0, "(objectclass=*)", new String[]{this.mPinAttr}, false);
        if (!res.hasMoreElements()) {
            logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_NO_ENTRY_RETURNED", uid, userdn));
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        entry = (LDAPEntry)res.nextElement();
        LDAPAttribute pinAttr = entry.getAttribute(this.mPinAttr);
        if (pinAttr == null) {
            logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_NO_PIN_FOUND", uid));
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        Enumeration pinValues = pinAttr.getByteValues();
        if (!pinValues.hasMoreElements()) {
            logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_NO_PIN_FOUND", uid));
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        byte[] entrypin = (byte[])pinValues.nextElement();
        if (entrypin == null || entrypin.length < 2) {
            logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_NO_PIN_FOUND", uid));
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        byte hashtype = entrypin[0];
        byte[] pinDigest = null;
        String toBeDigested = userdn + pin;
        if (hashtype == 0) {
            pinDigest = this.mSHADigest.digest(toBeDigested.getBytes());
        } else if (hashtype == 1) {
            pinDigest = this.mMD5Digest.digest(toBeDigested.getBytes());
        } else if (hashtype == 2) {
            pinDigest = this.mSHA256Digest.digest(toBeDigested.getBytes());
        } else if (hashtype == 45) {
            pinDigest = toBeDigested.getBytes();
        } else {
            logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_UKNOWN_ENCODING_TYPE", this.mPinAttr, "*", userdn));
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        if (pinDigest.length != entrypin.length - 1) {
            logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_LENGTH_NOT_MATCHED", uid));
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        for (i = 0; i < entrypin.length - 1 && pinDigest[i] == entrypin[i + 1]; ++i) {
        }
        if (i != entrypin.length - 1) {
            logger.error("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_BAD_PASSWORD", uid));
            throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
        }
        if (this.mRemovePin) {
            try {
                this.removePinLdapConnection.modify(userdn, new LDAPModification(1, new LDAPAttribute(this.mPinAttr, entrypin)));
            }
            catch (LDAPException e) {
                logger.warn("UidPwdPinDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_CANT_REMOVE_PIN", userdn));
            }
        }
    }

    @Override
    public String[] getConfigParams() {
        return mConfigParams;
    }

    @Override
    public String[] getRequiredCreds() {
        return mRequiredCreds;
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_UID_PIN_NAME", new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_UID_PIN_TEXT", new String[0]);
    }

    @Override
    public Enumeration<String> getValueNames() {
        Vector<String> v = new Vector<String>();
        v.addElement(CRED_UID);
        v.addElement(CRED_PWD);
        v.addElement("pin");
        return v.elements();
    }

    @Override
    public boolean isValueWriteable(String name) {
        if (name.equals(CRED_UID)) {
            return true;
        }
        if (name.equals(CRED_PWD)) {
            return false;
        }
        return false;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(CRED_UID)) {
            return new Descriptor("string", null, null, CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_UID", new String[0]));
        }
        if (name.equals(CRED_PWD)) {
            return new Descriptor("password", null, null, CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_PWD", new String[0]));
        }
        if (name.equals("pin")) {
            return new Descriptor("password", null, null, CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_PIN", new String[0]));
        }
        return null;
    }

    @Override
    public void populate(AuthToken token, Request request) throws EProfileException {
        request.setExtData("authenticatedName", token.getInString("userDN"));
    }

    @Override
    public boolean isSSLClientRequired() {
        return false;
    }

    static {
        mExtendedPluginInfo.add("removePin;boolean;SEE DOCUMENTATION for pin removal");
        mExtendedPluginInfo.add("pinAttr;string;directory attribute to use for pin (default 'pin')");
        mExtendedPluginInfo.add("ldap.ldapauth.bindDN;string;DN to bind as for pin removal. For example 'CN=PinRemoval User'");
        mExtendedPluginInfo.add("ldap.ldapauth.bindPWPrompt;password;Enter password used to bind as the above user");
        mExtendedPluginInfo.add("ldap.ldapauth.clientCertNickname;string;If you want to use SSL client auth to the directory, set the client cert nickname here");
        mExtendedPluginInfo.add("ldap.ldapauth.authtype;choice(BasicAuth,SslClientAuth),required;How to bind to the directory (for pin removal only)");
        mExtendedPluginInfo.add("HELP_TEXT;Authenticate the username, password and pin provided by the user against an LDAP directory. Works with the Dir/Pin Based Enrollment HTML form");
        mExtendedPluginInfo.add("HELP_TOKEN;configuration-authrules-uidpwdpindirauth");
    }
}

