/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.logging;

import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.SignedAuditEvent;
import com.netscape.cms.logging.Logger;
import com.netscape.cms.logging.SignedAuditLogger;
import java.util.Map;

public class Auditor {
    public static final String SIGNED_AUDIT_SCOPE = "Scope";
    public static final String SIGNED_AUDIT_OPERATION = "Operation";
    public static final String SIGNED_AUDIT_RESOURCE = "Resource";
    public static final String SIGNED_AUDIT_EMPTY_NAME_VALUE_PAIR = "Unknown";
    protected Logger signedAuditLogger;

    public void init() {
        this.signedAuditLogger = new SignedAuditLogger();
    }

    public String getSubjectID() {
        SessionContext context = SessionContext.getExistingContext();
        if (context == null) {
            return "$Unidentified$";
        }
        String subjectID = (String)context.get((Object)"userid");
        if (subjectID == null) {
            return "$NonRoleUser$";
        }
        return subjectID.trim();
    }

    public String getParamString(String scope, String type, String id, Map<String, String> params) {
        StringBuilder parameters = new StringBuilder();
        if (scope != null) {
            parameters.append("Scope;;" + scope);
        } else {
            parameters.append(SIGNED_AUDIT_EMPTY_NAME_VALUE_PAIR);
        }
        if (type != null) {
            parameters.append("+");
            parameters.append("Operation;;" + type);
        }
        if (id != null) {
            parameters.append("+");
            parameters.append("Resource;;" + id);
        }
        return this.getParamString(parameters, params);
    }

    public String getParamString(Map<String, String> params) {
        return this.getParamString(new StringBuilder(), params);
    }

    public String getParamString(StringBuilder parameters, Map<String, String> params) {
        if (params == null) {
            return parameters.toString();
        }
        SignedAuditEvent.encodeMap(parameters, params);
        return parameters.toString();
    }

    public LogEvent create(int level, String msg, Object[] params, boolean multiline) {
        return this.signedAuditLogger.create(level, msg, params, multiline);
    }

    public void log(String message) {
        this.signedAuditLogger.log(message);
    }

    public void log(LogEvent event) {
        this.signedAuditLogger.log(event);
    }
}

