/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.core.policy;

import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.util.AssertionException;
import java.util.Enumeration;
import java.util.Vector;
import org.dogtagpki.legacy.core.policy.ExpressionComps;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleExpression
implements IExpression {
    public static Logger logger = LoggerFactory.getLogger(SimpleExpression.class);
    private String mPfx;
    private String mVar;
    private String mVal;
    private String mPartialMatch;
    private int mOp;
    private boolean hasWildCard;
    public static final char WILDCARD_CHAR = '*';
    public static SimpleExpression NULL_EXPRESSION = new SimpleExpression("null", 1, "null");

    public static IExpression parse(String input) throws EPolicyException {
        String var = null;
        int op = -1;
        String val = null;
        ExpressionComps comps = SimpleExpression.parseForEquality(input);
        if (comps == null) {
            comps = SimpleExpression.parseForInEquality(input);
        }
        if (comps == null) {
            comps = SimpleExpression.parseForGE(input);
        }
        if (comps == null) {
            comps = SimpleExpression.parseForLE(input);
        }
        if (comps == null) {
            comps = SimpleExpression.parseForGT(input);
        }
        if (comps == null) {
            comps = SimpleExpression.parseForLT(input);
        }
        if (comps == null) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_BAD_POLICY_EXPRESSION", input));
        }
        String pfx = null;
        String rawVar = comps.getAttr();
        int dotIdx = rawVar.indexOf(46);
        if (dotIdx != -1) {
            pfx = rawVar.substring(0, dotIdx).trim();
            var = rawVar.substring(dotIdx + 1).trim();
        } else {
            var = rawVar;
        }
        op = comps.getOp();
        val = comps.getVal();
        return new SimpleExpression(pfx, var, op, val);
    }

    public SimpleExpression(String var, int op, String val) {
        this(null, var, op, val);
    }

    public SimpleExpression(String prefix, String var, int op, String val) {
        this.mPfx = prefix;
        this.mVar = var;
        this.mOp = op;
        this.mVal = val;
        int firstIndex = this.mVal.indexOf(42);
        if (firstIndex >= 0) {
            this.hasWildCard = true;
            int nextIndex = this.mVal.indexOf(42, firstIndex + 1);
            this.mPartialMatch = nextIndex == -1 ? (firstIndex == 0 ? this.mVal.substring(1) : this.mVal.substring(0, firstIndex)) : this.mVal.substring(firstIndex + 1, nextIndex);
        } else {
            this.hasWildCard = false;
        }
    }

    @Override
    public boolean evaluate(Request req) throws EPolicyException {
        String givenVal = req.getExtDataInString(this.mPfx, this.mVar);
        logger.trace("mPfx: " + this.mPfx + " mVar: " + this.mVar + ",Given Value: " + givenVal + ", Value to compare with: " + this.mVal);
        return this.matchValue(givenVal);
    }

    private boolean matchVector(Vector<?> value) throws EPolicyException {
        boolean result = false;
        Enumeration<?> e = value.elements();
        while (e.hasMoreElements() && !(result = this.matchValue(e.nextElement()))) {
        }
        return result;
    }

    private boolean matchStringArray(String[] value) throws EPolicyException {
        boolean result = false;
        for (int i = 0; i < value.length && !(result = this.matchValue(value[i])); ++i) {
        }
        return result;
    }

    private boolean matchValue(Object value) throws EPolicyException {
        boolean result;
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            result = this.matchStringValue((String)value);
        } else if (value instanceof Integer) {
            result = this.matchIntegerValue((Integer)value);
        } else if (value instanceof Boolean) {
            result = this.matchBooleanValue((Boolean)value);
        } else if (value instanceof Vector) {
            result = this.matchVector((Vector)value);
        } else if (value instanceof String[]) {
            result = this.matchStringArray((String[])value);
        } else {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_INVALID_ATTR_VALUE", value.getClass().getName()));
        }
        return result;
    }

    private boolean matchStringValue(String givenVal) throws EPolicyException {
        return switch (this.mOp) {
            case 1 -> {
                if (this.hasWildCard) {
                    yield givenVal.indexOf(this.mPartialMatch) >= 0;
                }
                yield givenVal.equalsIgnoreCase(this.mVal);
            }
            case 2 -> {
                if (this.hasWildCard) {
                    yield givenVal.indexOf(this.mPartialMatch) < 0;
                }
                yield !givenVal.equalsIgnoreCase(this.mVal);
            }
            case 4 -> givenVal.compareTo(this.mVal) < 0;
            case 3 -> givenVal.compareTo(this.mVal) > 0;
            case 5 -> givenVal.compareTo(this.mVal) >= 0;
            case 6 -> givenVal.compareTo(this.mVal) >= 0;
            default -> throw new AssertionException("Invalid operation code");
        };
    }

    private boolean matchIntegerValue(Integer intVal) throws EPolicyException {
        int storedVal;
        int givenVal = intVal;
        try {
            storedVal = Integer.valueOf(this.mVal);
        }
        catch (Exception e) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_INVALID_ATTR_VALUE", this.mVal));
        }
        return switch (this.mOp) {
            case 1 -> givenVal == storedVal;
            case 2 -> givenVal != storedVal;
            case 4 -> givenVal < storedVal;
            case 3 -> givenVal > storedVal;
            case 5 -> givenVal >= storedVal;
            case 6 -> givenVal >= storedVal;
            default -> throw new AssertionException("Invalid operation code");
        };
    }

    private boolean matchBooleanValue(Boolean givenVal) throws EPolicyException {
        if (!this.mVal.equalsIgnoreCase("true") && !this.mVal.equalsIgnoreCase("false")) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_INVALID_ATTR_VALUE", this.mVal));
        }
        Boolean storedVal = Boolean.valueOf(this.mVal);
        return switch (this.mOp) {
            case 1 -> givenVal.equals(storedVal);
            case 2, 3, 4, 5, 6 -> !givenVal.equals(storedVal);
            default -> throw new AssertionException("Invalid operation code");
        };
    }

    @Override
    public String toString() {
        String op = null;
        switch (this.mOp) {
            case 1: {
                op = "==";
                break;
            }
            case 2: {
                op = "!=";
                break;
            }
            case 3: {
                op = ">";
                break;
            }
            case 4: {
                op = "<";
                break;
            }
            case 5: {
                op = ">=";
                break;
            }
            case 6: {
                op = "<=";
            }
        }
        if (this.mPfx == null || this.mPfx.length() <= 0) {
            return this.mVar + " " + op + " " + this.mVal;
        }
        return this.mPfx + "." + this.mVar + " " + op + " " + this.mVal;
    }

    private static ExpressionComps parseForEquality(String expression) {
        int index = expression.indexOf("==");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 1;
        String val = expression.substring(index + 2).trim();
        return new ExpressionComps(attr, op, val);
    }

    private static ExpressionComps parseForInEquality(String expression) {
        int index = expression.indexOf("!=");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 2;
        String val = expression.substring(index + 2).trim();
        return new ExpressionComps(attr, op, val);
    }

    private static ExpressionComps parseForGT(String expression) {
        int index = expression.indexOf(">");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 3;
        String val = expression.substring(index + 1).trim();
        return new ExpressionComps(attr, op, val);
    }

    private static ExpressionComps parseForLT(String expression) {
        int index = expression.indexOf("<");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 4;
        String val = expression.substring(index + 1).trim();
        return new ExpressionComps(attr, op, val);
    }

    private static ExpressionComps parseForGE(String expression) {
        int index = expression.indexOf(">=");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 5;
        String val = expression.substring(index + 2).trim();
        return new ExpressionComps(attr, op, val);
    }

    private static ExpressionComps parseForLE(String expression) {
        int index = expression.indexOf("<=");
        if (index < 0) {
            return null;
        }
        String attr = expression.substring(0, index).trim();
        int op = 6;
        String val = expression.substring(index + 2).trim();
        return new ExpressionComps(attr, op, val);
    }
}

