/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class TransportVersion
implements Comparable<TransportVersion> {
    public static final TransportVersion ZERO = new TransportVersion(0, "00000000-0000-0000-0000-000000000000");
    public static final TransportVersion V_7_0_0 = new TransportVersion(7000099, "7505fd05-d982-43ce-a63f-ff4c6c8bdeec");
    public static final TransportVersion V_7_0_1 = new TransportVersion(7000199, "ae772780-e6f9-46a1-b0a0-20ed0cae37f7");
    public static final TransportVersion V_7_1_0 = new TransportVersion(7010099, "fd09007c-1c54-450a-af99-9f941e1a53c2");
    public static final TransportVersion V_7_1_1 = new TransportVersion(7010199, "f7ddb16c-3495-42ef-8d54-1461570ca68c");
    public static final TransportVersion V_7_2_0 = new TransportVersion(7020099, "b74dbc52-e727-472c-af21-2156482e8796");
    public static final TransportVersion V_7_2_1 = new TransportVersion(7020199, "a3217b94-f436-4aab-a020-162c83ba18f2");
    public static final TransportVersion V_7_3_0 = new TransportVersion(7030099, "4f04e4c9-c5aa-49e4-8b99-abeb4e284a5a");
    public static final TransportVersion V_7_3_1 = new TransportVersion(7030199, "532b9bc9-e11f-48a2-b997-67ca68ffb354");
    public static final TransportVersion V_7_3_2 = new TransportVersion(7030299, "60da3953-8415-4d4f-a18d-853c3e68ebd6");
    public static final TransportVersion V_7_4_0 = new TransportVersion(7040099, "ec7e58aa-55b4-4064-a9dd-fd723a2ba7a8");
    public static final TransportVersion V_7_4_1 = new TransportVersion(7040199, "a316c26d-8e6a-4608-b1ec-062331552b98");
    public static final TransportVersion V_7_4_2 = new TransportVersion(7040299, "031a77e1-3640-4c8a-80cf-28ded96bab48");
    public static final TransportVersion V_7_5_0 = new TransportVersion(7050099, "cc6e14dc-9dc7-4b74-8e15-1f99a6cfbe03");
    public static final TransportVersion V_7_5_1 = new TransportVersion(7050199, "9d12be44-16dc-44a8-a89a-45c9174ea596");
    public static final TransportVersion V_7_5_2 = new TransportVersion(7050299, "484ed9de-7f5b-4e6b-a79a-0cb5e7570093");
    public static final TransportVersion V_7_6_0 = new TransportVersion(7060099, "4637b8ae-f3df-43ae-a065-ad4c29f3373a");
    public static final TransportVersion V_7_6_1 = new TransportVersion(7060199, "fe5b9f95-a311-4a92-943b-30ec256a331c");
    public static final TransportVersion V_7_6_2 = new TransportVersion(0x6BBB4B, "5396cb30-d91c-4789-85e8-77efd552c785");
    public static final TransportVersion V_7_7_0 = new TransportVersion(7070099, "7bb73c48-ddb8-4437-b184-30371c35dd4b");
    public static final TransportVersion V_7_7_1 = new TransportVersion(7070199, "85507b0f-0fca-4daf-a80b-451fe75e04a0");
    public static final TransportVersion V_7_8_0 = new TransportVersion(7080099, "c3cc74af-d15e-494b-a907-6ad6dd2f4660");
    public static final TransportVersion V_7_8_1 = new TransportVersion(7080199, "7acb9f6e-32f2-45ce-b87d-ca1f165b8e7a");
    public static final TransportVersion V_7_9_0 = new TransportVersion(7090099, "9388fe76-192a-4053-b51c-d2a7b8eae545");
    public static final TransportVersion V_7_9_1 = new TransportVersion(7090199, "30fa10fc-df6b-4435-bd9e-acdb9ae1b268");
    public static final TransportVersion V_7_9_2 = new TransportVersion(7090299, "b58bb181-cecc-464e-b955-f6c1c1e7b4d0");
    public static final TransportVersion V_7_9_3 = new TransportVersion(7090399, "4406926c-e2b6-4b9a-a72a-1bee8357ad3e");
    public static final TransportVersion V_7_10_0 = new TransportVersion(7100099, "4efca195-38e4-4f74-b877-c26fb2a40733");
    public static final TransportVersion V_7_10_1 = new TransportVersion(7100199, "0070260c-aa0b-4fc2-9c87-5cd5f23b005f");
    public static final TransportVersion V_7_10_2 = new TransportVersion(7100299, "b369e2ed-261c-4b2f-8b42-0f0ba0549f8c");
    public static final TransportVersion V_7_11_0 = new TransportVersion(7110099, "3b43bcbc-1c5e-4cc2-a3b4-8ac8b64239e8");
    public static final TransportVersion V_7_11_1 = new TransportVersion(7110199, "2f75d13c-adde-4762-a46e-def8acce62b7");
    public static final TransportVersion V_7_11_2 = new TransportVersion(7110299, "2c852a4b-236d-4e8b-9373-336c9b52685a");
    public static final TransportVersion V_7_12_0 = new TransportVersion(7120099, "3be9ff6f-2d9f-4fc2-ba91-394dd5ebcf33");
    public static final TransportVersion V_7_12_1 = new TransportVersion(7120199, "ee4fdfac-2039-4b00-b42d-579cbde7120c");
    public static final TransportVersion V_7_13_0 = new TransportVersion(7130099, "e1fe494a-7c66-4571-8f8f-1d7e6d8df1b3");
    public static final TransportVersion V_7_13_1 = new TransportVersion(7130199, "66bc8d82-36da-4d54-b22d-aca691dc3d70");
    public static final TransportVersion V_7_13_2 = new TransportVersion(0x6CCCBB, "2a6fc74c-4c44-4264-a619-37437cd2c5a0");
    public static final TransportVersion V_7_13_3 = new TransportVersion(7130399, "a31592f5-f8d2-490c-a02e-da9501823d8d");
    public static final TransportVersion V_7_13_4 = new TransportVersion(7130499, "3143240d-1831-4186-8a19-963336c4cea0");
    public static final TransportVersion V_7_14_0 = new TransportVersion(7140099, "8cf0954c-b085-467f-b20b-3cb4b2e69e3e");
    public static final TransportVersion V_7_14_1 = new TransportVersion(7140199, "3dbb62c3-cf73-4c76-8d5a-4ca70afe2c70");
    public static final TransportVersion V_7_14_2 = new TransportVersion(7140299, "7943ae20-df60-45e5-97ba-82fc0dfc8b89");
    public static final TransportVersion V_7_15_0 = new TransportVersion(7150099, "2273ac0e-00bb-4024-9e2e-ab78981623c6");
    public static final TransportVersion V_7_15_1 = new TransportVersion(7150199, "a8c3503d-3452-45cf-b385-e855e16547fe");
    public static final TransportVersion V_7_15_2 = new TransportVersion(7150299, "fbb8ad69-02e2-4c90-b2e4-23947107f8b4");
    public static final TransportVersion V_7_16_0 = new TransportVersion(7160099, "59abadd2-25db-4547-a991-c92306a3934e");
    public static final TransportVersion V_7_16_1 = new TransportVersion(7160199, "4ace6b6b-8bba-427f-8755-9e3b40092138");
    public static final TransportVersion V_7_16_2 = new TransportVersion(7160299, "785567b9-b320-48ef-b538-1753228904cd");
    public static final TransportVersion V_7_16_3 = new TransportVersion(7160399, "facf5ae7-3d4e-479c-9142-72529b784e30");
    public static final TransportVersion V_7_17_0 = new TransportVersion(7170099, "322efe93-4c73-4e15-9274-bb76836c8fa8");
    public static final TransportVersion V_7_17_1 = new TransportVersion(7170199, "51c72842-7974-4669-ad25-bf13ba307307");
    public static final TransportVersion V_7_17_2 = new TransportVersion(7170299, "82bea8d0-bfea-47c2-b7d3-217d8feb67e3");
    public static final TransportVersion V_7_17_3 = new TransportVersion(7170399, "a909c2f4-5cb8-46bf-af0f-cd18d1b7e9d2");
    public static final TransportVersion V_7_17_4 = new TransportVersion(7170499, "5076e164-18a4-4373-8be7-15f1843c46db");
    public static final TransportVersion V_7_17_5 = new TransportVersion(7170599, "da7e3509-7f61-4dd2-8d23-a61f628a62f6");
    public static final TransportVersion V_7_17_6 = new TransportVersion(7170699, "a47ecf02-e457-474f-887d-ee15a7ebd969");
    public static final TransportVersion V_7_17_7 = new TransportVersion(7170799, "108ba576-bb28-42f4-bcbf-845a0ce52560");
    public static final TransportVersion V_7_17_8 = new TransportVersion(7170899, "82a3e70d-cf0e-4efb-ad16-6077ab9fe19f");
    public static final TransportVersion V_7_17_9 = new TransportVersion(7170999, "afd50dda-735f-4eae-9309-3218ffec1b2d");
    public static final TransportVersion V_7_17_10 = new TransportVersion(7171099, "18ae7108-6f7a-4205-adbb-cfcd6aa6ccc6");
    public static final TransportVersion V_8_0_0 = new TransportVersion(8000099, "c7d2372c-9f01-4a79-8b11-227d862dfe4f");
    public static final TransportVersion V_8_0_1 = new TransportVersion(8000199, "56e044c3-37e5-4f7e-bd38-f493927354ac");
    public static final TransportVersion V_8_1_0 = new TransportVersion(8010099, "3dc49dce-9cef-492a-ac8d-3cc79f6b4280");
    public static final TransportVersion V_8_1_1 = new TransportVersion(8010199, "40cf32e5-17b0-4187-9de1-022cdea69db9");
    public static final TransportVersion V_8_1_2 = new TransportVersion(8010299, "54aa6394-08f3-4db7-b82e-314ae4b5b562");
    public static final TransportVersion V_8_1_3 = new TransportVersion(8010399, "9772b54b-1e14-485f-92e8-8847b3a3d569");
    public static final TransportVersion V_8_2_0 = new TransportVersion(8020099, "8ce6d555-202e-47db-ab7d-ade9dda1b7e8");
    public static final TransportVersion V_8_2_1 = new TransportVersion(8020199, "ffbb67e8-cc33-4b02-a995-b461d9ee36c8");
    public static final TransportVersion V_8_2_2 = new TransportVersion(8020299, "2499ee77-187d-4e10-8366-8e60d5f03676");
    public static final TransportVersion V_8_2_3 = new TransportVersion(8020399, "046aae43-3090-4ece-8c27-8d489f097548");
    public static final TransportVersion V_8_3_0 = new TransportVersion(8030099, "559ddb66-d857-4208-bed5-a995ccf478ea");
    public static final TransportVersion V_8_3_1 = new TransportVersion(8030199, "31f9b136-dbbe-4fa1-b811-d6afa2a1b472");
    public static final TransportVersion V_8_3_2 = new TransportVersion(8030299, "f6e9cd4c-2a71-4f9b-80d4-7ba97ebd18b2");
    public static final TransportVersion V_8_3_3 = new TransportVersion(8030399, "a784de3e-533e-4844-8728-c55c6932dd8e");
    public static final TransportVersion V_8_4_0 = new TransportVersion(8040099, "c0d12906-aa5b-45d4-94c7-cbcf4d9818ca");
    public static final TransportVersion V_8_4_1 = new TransportVersion(8040199, "9a915f76-f259-4361-b53d-3f19c7797fd8");
    public static final TransportVersion V_8_4_2 = new TransportVersion(8040299, "87c5b7b2-0f57-4172-8a81-b9f9a0198525");
    public static final TransportVersion V_8_4_3 = new TransportVersion(8040399, "327cb1a0-9b5d-4be9-8033-285c2549f770");
    public static final TransportVersion V_8_5_0 = new TransportVersion(8050099, "be3d7f23-7240-4904-9d7f-e25a0f766eca");
    public static final TransportVersion V_8_5_1 = new TransportVersion(8050199, "d349d202-f01c-4dbb-85dd-947fb4267c99");
    public static final TransportVersion V_8_5_2 = new TransportVersion(8050299, "b68b1331-fd64-44d9-9e71-f6796ec2024c");
    public static final TransportVersion V_8_5_3 = new TransportVersion(8050399, "9ca3c835-e3b7-4622-a08e-d51e42403b06");
    public static final TransportVersion V_8_5_4 = new TransportVersion(8050499, "97ee525c-555d-45ca-83dc-59cd592c8e86");
    public static final TransportVersion V_8_6_0 = new TransportVersion(8060099, "e209c5ed-3488-4415-b561-33492ca3b789");
    public static final TransportVersion V_8_6_1 = new TransportVersion(8060199, "9f113acb-1b21-4fda-bef9-2a3e669b5c7b");
    public static final TransportVersion V_8_6_2 = new TransportVersion(8060299, "5a82fb68-b265-4a06-97c5-53496f823f51");
    public static final TransportVersion V_8_6_3 = new TransportVersion(8060399, "640b4f56-74a5-4d0e-bfb2-0a6395128d7f");
    public static final TransportVersion V_8_7_0;
    public static final TransportVersion CURRENT;
    public static final TransportVersion MINIMUM_COMPATIBLE;
    private static final NavigableMap<Integer, TransportVersion> VERSION_IDS;
    public final int id;
    private final String uniqueId;
    private TransportVersion minimumCompatibleVersion;

    static NavigableMap<Integer, TransportVersion> getAllVersionIds(Class<?> cls) {
        TreeMap<Integer, TransportVersion> builder = new TreeMap<Integer, TransportVersion>();
        HashMap<String, TransportVersion> uniqueIds = new HashMap<String, TransportVersion>();
        Set<String> ignore = Set.of("ZERO", "CURRENT", "MINIMUM_COMPATIBLE");
        for (Field declaredField : cls.getFields()) {
            String fieldName;
            if (!declaredField.getType().equals(TransportVersion.class) || ignore.contains(fieldName = declaredField.getName())) continue;
            try {
                TransportVersion version = (TransportVersion)declaredField.get(null);
                TransportVersion maybePrevious = builder.put(version.id, version);
                assert (maybePrevious == null) : "expected [" + version.id + "] to be uniquely mapped but saw [" + maybePrevious + "] and [" + version + "]";
                TransportVersion sameUniqueId = uniqueIds.put(version.uniqueId, version);
                if ($assertionsDisabled || sameUniqueId == null) continue;
                throw new AssertionError((Object)("Versions " + version + " and " + sameUniqueId + " have the same unique id. Each TransportVersion should have a different unique id"));
            }
            catch (IllegalAccessException e) {
                assert (false) : "Version field [" + fieldName + "] should be public";
            }
        }
        return Collections.unmodifiableNavigableMap(builder);
    }

    public static TransportVersion readVersion(StreamInput in) throws IOException {
        return TransportVersion.fromId(in.readVInt());
    }

    public static TransportVersion fromId(int id) {
        TransportVersion known = (TransportVersion)VERSION_IDS.get(id);
        if (known != null) {
            return known;
        }
        return new TransportVersion(id, "<unknown>");
    }

    public static void writeVersion(TransportVersion version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static TransportVersion min(TransportVersion version1, TransportVersion version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static TransportVersion max(TransportVersion version1, TransportVersion version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static Collection<TransportVersion> getAllVersions() {
        return VERSION_IDS.values();
    }

    TransportVersion(int id, String uniqueId) {
        this.id = id;
        this.uniqueId = Strings.requireNonEmpty(uniqueId, "Each TransportVersion needs a unique string id");
    }

    @Deprecated(forRemoval=true)
    public TransportVersion minimumCompatibilityVersion() {
        assert (this.equals(CURRENT)) : "Should be CURRENT, but was: " + this;
        return MINIMUM_COMPATIBLE;
    }

    @Deprecated(forRemoval=true)
    public boolean isCompatible(TransportVersion version) {
        return this.onOrAfter(version.calculateMinimumCompatVersion()) && version.onOrAfter(this.calculateMinimumCompatVersion());
    }

    @Deprecated(forRemoval=true)
    public TransportVersion calculateMinimumCompatVersion() {
        if (this.minimumCompatibleVersion == null) {
            this.minimumCompatibleVersion = Version.findVersion((TransportVersion)this).minimumCompatibilityVersion().transportVersion;
        }
        return this.minimumCompatibleVersion;
    }

    public boolean after(TransportVersion version) {
        return version.id < this.id;
    }

    public boolean onOrAfter(TransportVersion version) {
        return version.id <= this.id;
    }

    public boolean before(TransportVersion version) {
        return version.id > this.id;
    }

    public boolean onOrBefore(TransportVersion version) {
        return version.id >= this.id;
    }

    @Override
    public int compareTo(TransportVersion other) {
        return Integer.compare(this.id, other.id);
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportVersion version = (TransportVersion)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    static {
        CURRENT = V_8_7_0 = new TransportVersion(8070099, "f1ee7a85-4fa6-43f5-8679-33e2b750448b");
        MINIMUM_COMPATIBLE = V_7_17_0;
        VERSION_IDS = TransportVersion.getAllVersionIds(TransportVersion.class);
    }
}

