/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.CheckedConsumer;

public final class StepListener<Response>
implements ActionListener<Response> {
    private final AtomicBoolean hasBeenCalled = new AtomicBoolean(false);
    private final ListenableFuture<Response> delegate = new ListenableFuture();

    @Override
    public void onResponse(Response response) {
        if (this.hasBeenCalled.compareAndSet(false, true)) {
            this.delegate.onResponse(response);
        }
    }

    @Override
    public void onFailure(Exception e) {
        if (this.hasBeenCalled.compareAndSet(false, true)) {
            this.delegate.onFailure(e);
        }
    }

    public void whenComplete(CheckedConsumer<Response, Exception> onResponse, Consumer<Exception> onFailure) {
        this.addListener(ActionListener.wrap(onResponse, onFailure));
    }

    public <OtherResponse, OuterResponse> StepListener<OuterResponse> thenCombine(StepListener<OtherResponse> other, BiFunction<Response, OtherResponse, OuterResponse> fn) {
        StepListener combined = new StepListener();
        this.whenComplete(r1 -> other.whenComplete(r2 -> combined.onResponse(fn.apply(r1, r2)), combined::onFailure), combined::onFailure);
        return combined;
    }

    public Future<Response> asFuture() {
        return this.delegate;
    }

    public Response result() {
        if (!this.delegate.isDone()) {
            throw new IllegalStateException("step is not completed yet");
        }
        return FutureUtils.get(this.delegate, 0L, TimeUnit.NANOSECONDS);
    }

    public void addListener(ActionListener<Response> listener) {
        this.delegate.addListener(listener);
    }
}

