/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.support.nodes.BaseNodesXContentResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;

public class NodesStatsResponse
extends BaseNodesXContentResponse<NodeStats> {
    public NodesStatsResponse(StreamInput in) throws IOException {
        super(in);
    }

    public NodesStatsResponse(ClusterName clusterName, List<NodeStats> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    @Override
    protected List<NodeStats> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(NodeStats::new);
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<NodeStats> nodes) throws IOException {
        out.writeList(nodes);
    }

    @Override
    protected Iterator<? extends ToXContent> xContentChunks() {
        return Iterators.concat(Iterators.single((b, p) -> b.startObject("nodes")), this.getNodes().stream().map(nodeStats -> (b, p) -> {
            b.startObject(nodeStats.getNode().getId());
            b.field("timestamp", nodeStats.getTimestamp());
            nodeStats.toXContent(b, p);
            return b.endObject();
        }).iterator(), Iterators.single((b, p) -> b.endObject()));
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

