/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.reroute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresRequest;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.routing.allocation.command.AbstractAllocateAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocateStalePrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterRerouteAction
extends TransportMasterNodeAction<ClusterRerouteRequest, ClusterRerouteResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterRerouteAction.class);
    private final AllocationService allocationService;
    private static final String TASK_SOURCE = "cluster_reroute (api)";

    @Inject
    public TransportClusterRerouteAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/reroute", transportService, clusterService, threadPool, actionFilters, ClusterRerouteRequest::new, indexNameExpressionResolver, ClusterRerouteResponse::new, "same");
        this.allocationService = allocationService;
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterRerouteRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(Task task, ClusterRerouteRequest request, ClusterState state, ActionListener<ClusterRerouteResponse> listener) {
        HashMap<String, List<AbstractAllocateAllocationCommand>> stalePrimaryAllocations = new HashMap<String, List<AbstractAllocateAllocationCommand>>();
        for (AllocationCommand command : request.getCommands().commands()) {
            if (!(command instanceof AllocateStalePrimaryAllocationCommand)) continue;
            AllocateStalePrimaryAllocationCommand cmd = (AllocateStalePrimaryAllocationCommand)command;
            stalePrimaryAllocations.computeIfAbsent(cmd.index(), k -> new ArrayList()).add(cmd);
        }
        if (stalePrimaryAllocations.isEmpty()) {
            this.submitStateUpdate(request, listener);
        } else {
            this.verifyThenSubmitUpdate(request, listener, stalePrimaryAllocations);
        }
    }

    private void verifyThenSubmitUpdate(ClusterRerouteRequest request, ActionListener<ClusterRerouteResponse> listener, Map<String, List<AbstractAllocateAllocationCommand>> stalePrimaryAllocations) {
        this.transportService.sendRequest(this.transportService.getLocalNode(), "indices:monitor/shard_stores", new IndicesShardStoresRequest().indices(stalePrimaryAllocations.keySet().toArray(Strings.EMPTY_ARRAY)), new ActionListenerResponseHandler<IndicesShardStoresResponse>(ActionListener.wrap(response -> {
            Map<String, Map<Integer, List<IndicesShardStoresResponse.StoreStatus>>> status = response.getStoreStatuses();
            Exception e = null;
            for (Map.Entry entry : stalePrimaryAllocations.entrySet()) {
                String index = (String)entry.getKey();
                Map<Integer, List<IndicesShardStoresResponse.StoreStatus>> indexStatus = status.get(index);
                if (indexStatus == null) continue;
                for (AbstractAllocateAllocationCommand command : (List)entry.getValue()) {
                    List<IndicesShardStoresResponse.StoreStatus> shardStatus = indexStatus.get(command.shardId());
                    if (shardStatus == null || shardStatus.isEmpty()) {
                        e = ExceptionsHelper.useOrSuppress(e, new IllegalArgumentException("No data for shard [" + command.shardId() + "] of index [" + index + "] found on any node"));
                        continue;
                    }
                    if (!shardStatus.stream().noneMatch(storeStatus -> {
                        DiscoveryNode node = storeStatus.getNode();
                        String nodeInCommand = command.node();
                        return nodeInCommand.equals(node.getName()) || nodeInCommand.equals(node.getId());
                    })) continue;
                    e = ExceptionsHelper.useOrSuppress(e, new IllegalArgumentException("No data for shard [" + command.shardId() + "] of index [" + index + "] found on node [" + command.node() + "]"));
                }
            }
            if (e == null) {
                this.submitStateUpdate(request, listener);
            } else {
                listener.onFailure(e);
            }
        }, listener::onFailure), IndicesShardStoresResponse::new));
    }

    private void submitStateUpdate(ClusterRerouteRequest request, ActionListener<ClusterRerouteResponse> listener) {
        this.submitUnbatchedTask(TASK_SOURCE, new ClusterRerouteResponseAckedClusterStateUpdateTask(logger, this.allocationService, this.threadPool.getThreadContext(), request, listener.map(response -> {
            if (!request.dryRun()) {
                response.getExplanations().getYesDecisionMessages().forEach(arg_0 -> ((Logger)logger).info(arg_0));
            }
            return response;
        })));
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static class ClusterRerouteResponseAckedClusterStateUpdateTask
    extends ClusterStateUpdateTask
    implements ClusterStateAckListener {
        private final ClusterRerouteRequest request;
        private final AllocationActionListener<ClusterRerouteResponse> listener;
        private final Logger logger;
        private final AllocationService allocationService;
        private volatile ClusterState clusterStateToSend;
        private volatile RoutingExplanations explanations;

        ClusterRerouteResponseAckedClusterStateUpdateTask(Logger logger, AllocationService allocationService, ThreadContext context, ClusterRerouteRequest request, ActionListener<ClusterRerouteResponse> listener) {
            super(Priority.IMMEDIATE);
            this.request = request;
            this.listener = new AllocationActionListener<ClusterRerouteResponse>(listener, context);
            this.logger = logger;
            this.allocationService = allocationService;
        }

        @Override
        public boolean mustAck(DiscoveryNode discoveryNode) {
            return true;
        }

        @Override
        public TimeValue ackTimeout() {
            return this.request.ackTimeout();
        }

        @Override
        public void onAllNodesAcked() {
            this.listener.clusterStateUpdate().onResponse(new ClusterRerouteResponse(true, this.clusterStateToSend, this.explanations));
        }

        @Override
        public void onAckFailure(Exception e) {
            this.listener.clusterStateUpdate().onResponse(new ClusterRerouteResponse(false, this.clusterStateToSend, this.explanations));
        }

        @Override
        public void onAckTimeout() {
            this.listener.clusterStateUpdate().onResponse(new ClusterRerouteResponse(false, this.clusterStateToSend, new RoutingExplanations()));
        }

        @Override
        public void onFailure(Exception e) {
            this.logger.debug("failed to perform [cluster_reroute (api)]", (Throwable)e);
            this.listener.clusterStateUpdate().onFailure(e);
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            AllocationService.CommandsResult result = this.allocationService.reroute(currentState, this.request.getCommands(), this.request.explain(), this.request.isRetryFailed(), this.request.dryRun(), this.listener.reroute());
            this.clusterStateToSend = result.clusterState();
            this.explanations = result.explanations();
            return this.request.dryRun() ? currentState : result.clusterState();
        }
    }
}

