/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.reservedstate.ReservedComposableIndexTemplateAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutComposableIndexTemplateAction
extends AcknowledgedTransportMasterNodeAction<PutComposableIndexTemplateAction.Request> {
    private final MetadataIndexTemplateService indexTemplateService;

    @Inject
    public TransportPutComposableIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/index_template/put", transportService, clusterService, threadPool, actionFilters, PutComposableIndexTemplateAction.Request::new, indexNameExpressionResolver, "same");
        this.indexTemplateService = indexTemplateService;
    }

    @Override
    protected ClusterBlockException checkBlock(PutComposableIndexTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(Task task, PutComposableIndexTemplateAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        TransportPutComposableIndexTemplateAction.verifyIfUsingReservedComponentTemplates(request, state);
        ComposableIndexTemplate indexTemplate = request.indexTemplate();
        this.indexTemplateService.putIndexTemplateV2(request.cause(), request.create(), request.name(), request.masterNodeTimeout(), indexTemplate, listener);
    }

    public static void verifyIfUsingReservedComponentTemplates(PutComposableIndexTemplateAction.Request request, ClusterState state) {
        ComposableIndexTemplate indexTemplate = request.indexTemplate();
        Set<String> composedOfKeys = indexTemplate.composedOf().stream().map(c -> ReservedComposableIndexTemplateAction.reservedComponentName(c)).collect(Collectors.toSet());
        ArrayList<String> errors = new ArrayList<String>();
        for (ReservedStateMetadata metadata : state.metadata().reservedStateMetadata().values()) {
            Set<String> conflicts = metadata.conflicts("index_templates", composedOfKeys);
            if (conflicts.isEmpty()) continue;
            errors.add(Strings.format((String)"[%s] is reserved by [%s]", (Object[])new Object[]{String.join((CharSequence)", ", conflicts), metadata.namespace()}));
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(Strings.format((String)"Failed to process request [%s] with errors: [%s]", (Object[])new Object[]{request, String.join((CharSequence)", ", errors)}));
        }
    }

    @Override
    public Optional<String> reservedStateHandlerName() {
        return Optional.of("index_templates");
    }

    @Override
    public Set<String> modifiedKeys(PutComposableIndexTemplateAction.Request request) {
        return Set.of(ReservedComposableIndexTemplateAction.reservedComposableIndexName(request.name()));
    }
}

