/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;

final class FieldCapabilitiesIndexResponse
implements Writeable {
    private static final TransportVersion MAPPING_HASH_VERSION = TransportVersion.V_8_2_0;
    private final String indexName;
    @Nullable
    private final String indexMappingHash;
    private final Map<String, IndexFieldCapabilities> responseMap;
    private final boolean canMatch;
    private final transient TransportVersion originVersion;

    FieldCapabilitiesIndexResponse(String indexName, @Nullable String indexMappingHash, Map<String, IndexFieldCapabilities> responseMap, boolean canMatch) {
        this.indexName = indexName;
        this.indexMappingHash = indexMappingHash;
        this.responseMap = responseMap;
        this.canMatch = canMatch;
        this.originVersion = TransportVersion.CURRENT;
    }

    FieldCapabilitiesIndexResponse(StreamInput in) throws IOException {
        this.indexName = in.readString();
        this.responseMap = in.readMap(StreamInput::readString, IndexFieldCapabilities::new);
        this.canMatch = in.readBoolean();
        this.originVersion = in.getTransportVersion();
        this.indexMappingHash = in.getTransportVersion().onOrAfter(MAPPING_HASH_VERSION) ? in.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeMap(this.responseMap, StreamOutput::writeString, (valueOut, fc) -> fc.writeTo(valueOut));
        out.writeBoolean(this.canMatch);
        if (out.getTransportVersion().onOrAfter(MAPPING_HASH_VERSION)) {
            out.writeOptionalString(this.indexMappingHash);
        }
    }

    static List<FieldCapabilitiesIndexResponse> readList(StreamInput input) throws IOException {
        if (input.getTransportVersion().before(MAPPING_HASH_VERSION)) {
            return input.readList(FieldCapabilitiesIndexResponse::new);
        }
        List<FieldCapabilitiesIndexResponse> ungroupedList = input.readList(FieldCapabilitiesIndexResponse::new);
        List<GroupByMappingHash> groups = input.readList(GroupByMappingHash::new);
        return Stream.concat(ungroupedList.stream(), groups.stream().flatMap(g -> g.getResponses().stream())).toList();
    }

    static void writeList(StreamOutput output, List<FieldCapabilitiesIndexResponse> responses) throws IOException {
        if (output.getTransportVersion().before(MAPPING_HASH_VERSION)) {
            output.writeCollection(responses);
            return;
        }
        Predicate<FieldCapabilitiesIndexResponse> canGroup = r -> r.canMatch && r.indexMappingHash != null;
        List<FieldCapabilitiesIndexResponse> ungroupedResponses = responses.stream().filter(r -> !canGroup.test((FieldCapabilitiesIndexResponse)r)).toList();
        List<GroupByMappingHash> groupedResponses = responses.stream().filter(canGroup).collect(Collectors.groupingBy(r -> r.indexMappingHash)).values().stream().map(rs -> {
            String indexMappingHash = ((FieldCapabilitiesIndexResponse)rs.get((int)0)).indexMappingHash;
            Map<String, IndexFieldCapabilities> responseMap = ((FieldCapabilitiesIndexResponse)rs.get((int)0)).responseMap;
            List<String> indices = rs.stream().map(r -> r.indexName).toList();
            return new GroupByMappingHash(indices, indexMappingHash, responseMap);
        }).toList();
        output.writeList(ungroupedResponses);
        output.writeList(groupedResponses);
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Nullable
    public String getIndexMappingHash() {
        return this.indexMappingHash;
    }

    public boolean canMatch() {
        return this.canMatch;
    }

    public Map<String, IndexFieldCapabilities> get() {
        return this.responseMap;
    }

    public IndexFieldCapabilities getField(String field) {
        return this.responseMap.get(field);
    }

    TransportVersion getOriginVersion() {
        return this.originVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesIndexResponse that = (FieldCapabilitiesIndexResponse)o;
        return this.canMatch == that.canMatch && Objects.equals(this.indexName, that.indexName) && Objects.equals(this.indexMappingHash, that.indexMappingHash) && Objects.equals(this.responseMap, that.responseMap);
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.indexMappingHash, this.responseMap, this.canMatch);
    }

    private record GroupByMappingHash(List<String> indices, String indexMappingHash, Map<String, IndexFieldCapabilities> responseMap) implements Writeable
    {
        GroupByMappingHash(StreamInput in) throws IOException {
            this(in.readStringList(), in.readString(), in.readMap(StreamInput::readString, IndexFieldCapabilities::new));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.indices);
            out.writeString(this.indexMappingHash);
            out.writeMap(this.responseMap, StreamOutput::writeString, (valueOut, fc) -> fc.writeTo(valueOut));
        }

        List<FieldCapabilitiesIndexResponse> getResponses() {
            return this.indices.stream().map(index -> new FieldCapabilitiesIndexResponse((String)index, this.indexMappingHash, this.responseMap, true)).toList();
        }
    }
}

