/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.elasticsearch.action.ingest.WriteableIngestDocument;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class SimulateDocumentBaseResult
implements SimulateDocumentResult {
    private final WriteableIngestDocument ingestDocument;
    private final Exception failure;
    public static final ConstructingObjectParser<SimulateDocumentBaseResult, Void> PARSER = new ConstructingObjectParser("simulate_document_base_result", true, a -> {
        if (a[1] == null) {
            assert (a[0] != null);
            return new SimulateDocumentBaseResult(((WriteableIngestDocument)a[0]).getIngestDocument());
        }
        assert (a[0] == null);
        return new SimulateDocumentBaseResult((ElasticsearchException)a[1]);
    });

    public SimulateDocumentBaseResult(IngestDocument ingestDocument) {
        this.ingestDocument = ingestDocument != null ? new WriteableIngestDocument(ingestDocument) : null;
        this.failure = null;
    }

    public SimulateDocumentBaseResult(Exception failure) {
        this.ingestDocument = null;
        this.failure = failure;
    }

    public SimulateDocumentBaseResult(StreamInput in) throws IOException {
        this.failure = in.readException();
        this.ingestDocument = in.readOptionalWriteable(WriteableIngestDocument::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeException(this.failure);
        out.writeOptionalWriteable(this.ingestDocument);
    }

    public IngestDocument getIngestDocument() {
        if (this.ingestDocument == null) {
            return null;
        }
        return this.ingestDocument.getIngestDocument();
    }

    public Exception getFailure() {
        return this.failure;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.failure == null && this.ingestDocument == null) {
            builder.nullValue();
            return builder;
        }
        builder.startObject();
        if (this.failure == null) {
            this.ingestDocument.toXContent(builder, params);
        } else {
            ElasticsearchException.generateFailureXContent(builder, params, this.failure, true);
        }
        builder.endObject();
        return builder;
    }

    public static SimulateDocumentBaseResult fromXContent(XContentParser parser) {
        return (SimulateDocumentBaseResult)PARSER.apply(parser, null);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), WriteableIngestDocument.INGEST_DOC_PARSER, new ParseField("doc", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), new ParseField("error", new String[0]));
    }
}

