/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Strings;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;

public final class ChannelActionListener<Response extends TransportResponse, Request extends TransportRequest>
implements ActionListener<Response> {
    private static final Logger logger = LogManager.getLogger(ChannelActionListener.class);
    private final TransportChannel channel;
    private final Request request;
    private final String actionName;

    public ChannelActionListener(TransportChannel channel, String actionName, Request request) {
        this.channel = channel;
        this.request = request;
        this.actionName = actionName;
    }

    @Override
    public void onResponse(Response response) {
        ActionListener.run(this, l -> l.channel.sendResponse((TransportResponse)response));
    }

    @Override
    public void onFailure(Exception e) {
        try {
            this.channel.sendResponse(e);
        }
        catch (Exception sendException) {
            sendException.addSuppressed(e);
            logger.warn(() -> Strings.format((String)"Failed to send error response for action [%s] and request [%s]", (Object[])new Object[]{this.actionName, this.request}), (Throwable)sendException);
        }
    }

    public String toString() {
        return "ChannelActionListener{" + this.channel + "}{" + this.request + "}{" + this.actionName + "}";
    }
}

