/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.util.CopyOnFirstWriteMap;
import org.elasticsearch.index.shard.ShardId;

public class ClusterInfoSimulator {
    private final Map<String, DiskUsage> leastAvailableSpaceUsage;
    private final Map<String, DiskUsage> mostAvailableSpaceUsage;
    private final CopyOnFirstWriteMap<String, Long> shardSizes;
    private final Map<ShardId, Long> shardDataSetSizes;
    private final Map<ClusterInfo.NodeAndShard, String> dataPath;

    public ClusterInfoSimulator(ClusterInfo clusterInfo) {
        this.leastAvailableSpaceUsage = new HashMap<String, DiskUsage>(clusterInfo.getNodeLeastAvailableDiskUsages());
        this.mostAvailableSpaceUsage = new HashMap<String, DiskUsage>(clusterInfo.getNodeMostAvailableDiskUsages());
        this.shardSizes = new CopyOnFirstWriteMap<String, Long>(clusterInfo.shardSizes);
        this.shardDataSetSizes = Map.copyOf(clusterInfo.shardDataSetSizes);
        this.dataPath = Map.copyOf(clusterInfo.dataPath);
    }

    public void simulateShardStarted(ShardRouting shard) {
        assert (shard.initializing());
        Long size = this.getEstimatedShardSize(shard);
        if (size != null && size > 0L) {
            if (shard.relocatingNodeId() != null) {
                this.modifyDiskUsage(shard.relocatingNodeId(), size);
                this.modifyDiskUsage(shard.currentNodeId(), -size.longValue());
            } else {
                this.modifyDiskUsage(shard.currentNodeId(), -size.longValue());
                this.shardSizes.put(ClusterInfo.shardIdentifierFromRouting(shard), size);
            }
        }
    }

    private Long getEstimatedShardSize(ShardRouting routing) {
        if (routing.relocatingNodeId() != null) {
            return this.shardSizes.get(ClusterInfo.shardIdentifierFromRouting(routing));
        }
        if (!routing.primary()) {
            return this.shardSizes.get(ClusterInfo.shardIdentifierFromRouting(routing.shardId(), true));
        }
        return 0L;
    }

    private void modifyDiskUsage(String nodeId, long delta) {
        DiskUsage mostUsage;
        DiskUsage diskUsage = this.mostAvailableSpaceUsage.get(nodeId);
        if (diskUsage == null) {
            return;
        }
        String path = diskUsage.getPath();
        DiskUsage leastUsage = this.leastAvailableSpaceUsage.get(nodeId);
        if (leastUsage != null && Objects.equals(leastUsage.getPath(), path)) {
            this.leastAvailableSpaceUsage.put(nodeId, ClusterInfoSimulator.updateWithFreeBytes(leastUsage, delta));
        }
        if ((mostUsage = this.mostAvailableSpaceUsage.get(nodeId)) != null && Objects.equals(mostUsage.getPath(), path)) {
            this.mostAvailableSpaceUsage.put(nodeId, ClusterInfoSimulator.updateWithFreeBytes(mostUsage, delta));
        }
    }

    private static DiskUsage updateWithFreeBytes(DiskUsage usage, long delta) {
        long freeBytes = ClusterInfoSimulator.withinRange(0L, usage.getTotalBytes(), usage.freeBytes() + delta);
        return usage.copyWithFreeBytes(freeBytes);
    }

    private static long withinRange(long min, long max, long value) {
        return Math.max(min, Math.min(max, value));
    }

    public ClusterInfo getClusterInfo() {
        return new ClusterInfo(this.leastAvailableSpaceUsage, this.mostAvailableSpaceUsage, this.shardSizes.toImmutableMap(), this.shardDataSetSizes, this.dataPath, Map.of());
    }
}

