/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.Join;
import org.elasticsearch.cluster.coordination.NodeHealthCheckFailureException;
import org.elasticsearch.cluster.coordination.PreVoteRequest;
import org.elasticsearch.cluster.coordination.PreVoteResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.monitor.StatusInfo;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class PreVoteCollector {
    private static final Logger logger = LogManager.getLogger(PreVoteCollector.class);
    public static final String REQUEST_PRE_VOTE_ACTION_NAME = "internal:cluster/request_pre_vote";
    private final TransportService transportService;
    private final Runnable startElection;
    private final LongConsumer updateMaxTermSeen;
    private final ElectionStrategy electionStrategy;
    private NodeHealthService nodeHealthService;
    private volatile Tuple<DiscoveryNode, PreVoteResponse> state;

    PreVoteCollector(TransportService transportService, Runnable startElection, LongConsumer updateMaxTermSeen, ElectionStrategy electionStrategy, NodeHealthService nodeHealthService) {
        this.transportService = transportService;
        this.startElection = startElection;
        this.updateMaxTermSeen = updateMaxTermSeen;
        this.electionStrategy = electionStrategy;
        this.nodeHealthService = nodeHealthService;
        transportService.registerRequestHandler(REQUEST_PRE_VOTE_ACTION_NAME, "cluster_coordination", false, false, PreVoteRequest::new, (request, channel, task) -> channel.sendResponse(this.handlePreVoteRequest((PreVoteRequest)request)));
    }

    public Releasable start(ClusterState clusterState, Iterable<DiscoveryNode> broadcastNodes) {
        PreVotingRound preVotingRound = new PreVotingRound(clusterState, ((PreVoteResponse)this.state.v2()).getCurrentTerm());
        preVotingRound.start(broadcastNodes);
        return preVotingRound;
    }

    PreVoteResponse getPreVoteResponse() {
        return (PreVoteResponse)this.state.v2();
    }

    @Nullable
    DiscoveryNode getLeader() {
        return (DiscoveryNode)this.state.v1();
    }

    public void update(PreVoteResponse preVoteResponse, @Nullable DiscoveryNode leader) {
        logger.trace("updating with preVoteResponse={}, leader={}", (Object)preVoteResponse, (Object)leader);
        this.state = new Tuple((Object)leader, (Object)preVoteResponse);
    }

    private PreVoteResponse handlePreVoteRequest(PreVoteRequest request) {
        this.updateMaxTermSeen.accept(request.getCurrentTerm());
        Tuple<DiscoveryNode, PreVoteResponse> state = this.state;
        assert (state != null) : "received pre-vote request before fully initialised";
        DiscoveryNode leader = (DiscoveryNode)state.v1();
        PreVoteResponse response = (PreVoteResponse)state.v2();
        StatusInfo statusInfo = this.nodeHealthService.getHealth();
        if (statusInfo.getStatus() == StatusInfo.Status.UNHEALTHY) {
            String message = "rejecting " + request + " on unhealthy node: [" + statusInfo.getInfo() + "]";
            logger.debug(message);
            throw new NodeHealthCheckFailureException(message, new Object[0]);
        }
        if (leader == null) {
            return response;
        }
        if (leader.equals(request.getSourceNode())) {
            return response;
        }
        throw new CoordinationStateRejectedException("rejecting " + request + " as there is already a leader", new Object[0]);
    }

    public String toString() {
        return "PreVoteCollector{state=" + this.state + "}";
    }

    private class PreVotingRound
    implements Releasable {
        private final Map<DiscoveryNode, PreVoteResponse> preVotesReceived = ConcurrentCollections.newConcurrentMap();
        private final AtomicBoolean electionStarted = new AtomicBoolean();
        private final PreVoteRequest preVoteRequest;
        private final ClusterState clusterState;
        private final AtomicBoolean isClosed = new AtomicBoolean();

        PreVotingRound(ClusterState clusterState, long currentTerm) {
            this.clusterState = clusterState;
            this.preVoteRequest = new PreVoteRequest(PreVoteCollector.this.transportService.getLocalNode(), currentTerm);
        }

        void start(Iterable<DiscoveryNode> broadcastNodes) {
            logger.debug("{} requesting pre-votes from {}", (Object)this, broadcastNodes);
            broadcastNodes.forEach(n -> PreVoteCollector.this.transportService.sendRequest((DiscoveryNode)n, PreVoteCollector.REQUEST_PRE_VOTE_ACTION_NAME, this.preVoteRequest, new TransportResponseHandler<PreVoteResponse>(){

                @Override
                public PreVoteResponse read(StreamInput in) throws IOException {
                    return new PreVoteResponse(in);
                }

                @Override
                public void handleResponse(PreVoteResponse response) {
                    PreVotingRound.this.handlePreVoteResponse(response, n);
                }

                @Override
                public void handleException(TransportException exp) {
                    logger.debug(() -> Strings.format((String)"%s failed", (Object[])new Object[]{this}), (Throwable)exp);
                }

                @Override
                public String executor() {
                    return "cluster_coordination";
                }

                public String toString() {
                    return "TransportResponseHandler{" + PreVoteCollector.this + ", node=" + n + "}";
                }
            }));
        }

        private void handlePreVoteResponse(PreVoteResponse response, DiscoveryNode sender) {
            if (this.isClosed.get()) {
                logger.debug("{} is closed, ignoring {} from {}", (Object)this, (Object)response, (Object)sender);
                return;
            }
            PreVoteCollector.this.updateMaxTermSeen.accept(response.getCurrentTerm());
            if (response.getLastAcceptedTerm() > this.clusterState.term() || response.getLastAcceptedTerm() == this.clusterState.term() && response.getLastAcceptedVersion() > this.clusterState.version()) {
                logger.debug("{} ignoring {} from {} as it is fresher", (Object)this, (Object)response, (Object)sender);
                return;
            }
            this.preVotesReceived.put(sender, response);
            CoordinationState.VoteCollection voteCollection = new CoordinationState.VoteCollection();
            DiscoveryNode localNode = this.clusterState.nodes().getLocalNode();
            PreVoteResponse localPreVoteResponse = PreVoteCollector.this.getPreVoteResponse();
            this.preVotesReceived.forEach((node, preVoteResponse) -> voteCollection.addJoinVote(new Join((DiscoveryNode)node, localNode, preVoteResponse.getCurrentTerm(), preVoteResponse.getLastAcceptedTerm(), preVoteResponse.getLastAcceptedVersion())));
            if (!PreVoteCollector.this.electionStrategy.isElectionQuorum(this.clusterState.nodes().getLocalNode(), localPreVoteResponse.getCurrentTerm(), localPreVoteResponse.getLastAcceptedTerm(), localPreVoteResponse.getLastAcceptedVersion(), this.clusterState.getLastCommittedConfiguration(), this.clusterState.getLastAcceptedConfiguration(), voteCollection)) {
                logger.debug("{} added {} from {}, no quorum yet", (Object)this, (Object)response, (Object)sender);
                return;
            }
            if (!this.electionStarted.compareAndSet(false, true)) {
                logger.debug("{} added {} from {} but election has already started", (Object)this, (Object)response, (Object)sender);
                return;
            }
            logger.debug("{} added {} from {}, starting election", (Object)this, (Object)response, (Object)sender);
            PreVoteCollector.this.startElection.run();
        }

        public String toString() {
            return "PreVotingRound{preVotesReceived=" + this.preVotesReceived + ", electionStarted=" + this.electionStarted + ", preVoteRequest=" + this.preVoteRequest + ", isClosed=" + this.isClosed + "}";
        }

        public void close() {
            boolean isNotAlreadyClosed = this.isClosed.compareAndSet(false, true);
            assert (isNotAlreadyClosed);
        }
    }
}

