/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.desirednodes;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.DesiredNode;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;

public class DesiredNodesSettingsValidator {
    private final ClusterSettings clusterSettings;

    public DesiredNodesSettingsValidator(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
    }

    public void validate(List<DesiredNode> nodes) {
        ArrayList<DesiredNodeValidationError> validationErrors = new ArrayList<DesiredNodeValidationError>();
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            DesiredNode node = nodes.get(i2);
            try {
                this.validate(node);
                continue;
            }
            catch (IllegalArgumentException e) {
                validationErrors.add(new DesiredNodeValidationError(i2, node.externalId(), e));
            }
        }
        if (!validationErrors.isEmpty()) {
            String nodeIndicesWithFailures = validationErrors.stream().map(DesiredNodeValidationError::position).map(i -> Integer.toString(i)).collect(Collectors.joining(","));
            String nodeIdsWithFailures = validationErrors.stream().map(DesiredNodeValidationError::externalId).collect(Collectors.joining(","));
            IllegalArgumentException invalidSettingsException = new IllegalArgumentException(String.format(Locale.ROOT, "Nodes with ids [%s] in positions [%s] contain invalid settings", nodeIdsWithFailures, nodeIndicesWithFailures));
            for (DesiredNodeValidationError exceptionTuple : validationErrors) {
                invalidSettingsException.addSuppressed(exceptionTuple.exception);
            }
            throw invalidSettingsException;
        }
    }

    private void validate(DesiredNode node) {
        if (node.version().before(Version.CURRENT)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Illegal node version [%s]. Only [%s] or newer versions are supported", node.version(), Version.CURRENT));
        }
        if (node.version().after(Version.CURRENT)) {
            return;
        }
        Settings settings = node.settings();
        if (settings.hasValue(EsExecutors.NODE_PROCESSORS_SETTING.getKey())) {
            int minProcessors = node.roundedDownMinProcessors();
            Integer roundedUpMaxProcessors = node.roundedUpMaxProcessors();
            int maxProcessors = roundedUpMaxProcessors == null ? minProcessors : roundedUpMaxProcessors;
            Setting.doubleSetting(EsExecutors.NODE_PROCESSORS_SETTING.getKey(), (double)minProcessors, Double.MIN_VALUE, maxProcessors, Setting.Property.NodeScope).get(settings);
            Settings.Builder updatedSettings = Settings.builder().put(settings);
            updatedSettings.remove(EsExecutors.NODE_PROCESSORS_SETTING.getKey());
            settings = updatedSettings.build();
        }
        this.clusterSettings.validate(settings, true);
    }

    private record DesiredNodeValidationError(int position, @Nullable String externalId, RuntimeException exception) {
    }
}

