/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DesiredNode;
import org.elasticsearch.cluster.metadata.DesiredNodeWithStatus;
import org.elasticsearch.cluster.metadata.DesiredNodesMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.node.Node;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DesiredNodes
implements Writeable,
ToXContentObject,
Iterable<DesiredNodeWithStatus> {
    public static final String CONTEXT_MODE_PARAM = "desired_nodes_x_content_context";
    public static final String CONTEXT_MODE_API = SerializationContext.GET_DESIRED_NODES_API.toString();
    public static final String CONTEXT_MODE_CLUSTER_STATE = SerializationContext.CLUSTER_STATE.toString();
    private static final ParseField HISTORY_ID_FIELD = new ParseField("history_id", new String[0]);
    private static final ParseField VERSION_FIELD = new ParseField("version", new String[0]);
    private static final ParseField NODES_FIELD = new ParseField("nodes", new String[0]);
    public static final ConstructingObjectParser<DesiredNodes, Void> PARSER = new ConstructingObjectParser("desired_nodes", false, (args, unused) -> DesiredNodes.create((String)args[0], (Long)args[1], (List)args[2]));
    private final String historyID;
    private final long version;
    private final Map<String, DesiredNodeWithStatus> nodes;
    private final Set<DesiredNode> actualized;
    private final Set<DesiredNode> pending;

    private DesiredNodes(String historyID, long version, Map<String, DesiredNodeWithStatus> nodes) {
        assert (historyID != null && !historyID.isBlank());
        assert (version != Long.MIN_VALUE);
        this.historyID = historyID;
        this.version = version;
        this.nodes = Collections.unmodifiableMap(nodes);
        this.actualized = nodes.values().stream().filter(DesiredNodeWithStatus::actualized).map(DesiredNodeWithStatus::desiredNode).collect(Collectors.toUnmodifiableSet());
        this.pending = nodes.values().stream().filter(DesiredNodeWithStatus::pending).map(DesiredNodeWithStatus::desiredNode).collect(Collectors.toUnmodifiableSet());
    }

    public static DesiredNodes readFrom(StreamInput in) throws IOException {
        String historyId = in.readString();
        long version = in.readLong();
        List<DesiredNodeWithStatus> nodesWithStatus = in.readList(DesiredNodeWithStatus::readFrom);
        return DesiredNodes.create(historyId, version, nodesWithStatus);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.historyID);
        out.writeLong(this.version);
        out.writeCollection(this.nodes.values());
    }

    static DesiredNodes fromXContent(XContentParser parser) throws IOException {
        return (DesiredNodes)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(HISTORY_ID_FIELD.getPreferredName(), this.historyID);
        builder.field(VERSION_FIELD.getPreferredName(), this.version);
        builder.xContentList(NODES_FIELD.getPreferredName(), this.nodes.values(), params);
        builder.endObject();
        return builder;
    }

    public static DesiredNodes createIncludingStatusFromPreviousVersion(String historyId, long version, List<DesiredNode> nodes, @Nullable DesiredNodes previousDesiredNodes) {
        if (previousDesiredNodes == null || !previousDesiredNodes.historyID.equals(historyId)) {
            return DesiredNodes.create(historyId, version, nodes.stream().map(desiredNode -> new DesiredNodeWithStatus((DesiredNode)desiredNode, DesiredNodeWithStatus.Status.PENDING)).toList());
        }
        return DesiredNodes.create(historyId, version, previousDesiredNodes.transferStatusInformation(nodes));
    }

    public static DesiredNodes create(String historyID, long version, List<DesiredNodeWithStatus> nodes) {
        DesiredNodes.checkForDuplicatedExternalIDs(nodes);
        return new DesiredNodes(historyID, version, DesiredNodes.toMap(nodes));
    }

    @Nullable
    public static DesiredNodes latestFromClusterState(ClusterState clusterState) {
        return DesiredNodesMetadata.fromClusterState(clusterState).getLatestDesiredNodes();
    }

    public boolean isSupersededBy(DesiredNodes otherDesiredNodes) {
        return !this.historyID.equals(otherDesiredNodes.historyID) || this.version < otherDesiredNodes.version;
    }

    public boolean hasSameVersion(DesiredNodes other) {
        return this.historyID.equals(other.historyID) && this.version == other.version;
    }

    public boolean hasSameHistoryId(DesiredNodes other) {
        return other != null && this.historyID.equals(other.historyID);
    }

    private static void checkForDuplicatedExternalIDs(List<DesiredNodeWithStatus> nodes) {
        Set<String> nodeIDs = Sets.newHashSetWithExpectedSize(nodes.size());
        HashSet<String> duplicatedIDs = new HashSet<String>();
        for (DesiredNodeWithStatus node : nodes) {
            String externalID = node.desiredNode().externalId();
            assert (externalID != null);
            if (nodeIDs.add(externalID)) continue;
            duplicatedIDs.add(externalID);
        }
        if (!duplicatedIDs.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Some nodes contain the same setting value %s for [%s]", duplicatedIDs, Node.NODE_EXTERNAL_ID_SETTING.getKey()));
        }
    }

    public boolean equalsWithProcessorsCloseTo(DesiredNodes that) {
        return that != null && this.version == that.version && Objects.equals(this.historyID, that.historyID) && this.equalsNodesWithProcessorsCloseTo(that);
    }

    public boolean equalsNodesWithProcessorsCloseTo(DesiredNodes that) {
        if (that == null || this.nodes.size() != that.nodes.size()) {
            return false;
        }
        for (Map.Entry<String, DesiredNodeWithStatus> desiredNodeEntry : this.nodes.entrySet()) {
            DesiredNodeWithStatus otherDesiredNodeWithStatus;
            DesiredNodeWithStatus desiredNodeWithStatus = desiredNodeEntry.getValue();
            if (desiredNodeWithStatus.equalsWithProcessorsCloseTo(otherDesiredNodeWithStatus = that.nodes.get(desiredNodeEntry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DesiredNodes that = (DesiredNodes)o;
        return this.version == that.version && Objects.equals(this.historyID, that.historyID) && Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.historyID, this.version, this.nodes);
    }

    public String toString() {
        return "DesiredNodes{historyID='" + this.historyID + "', version=" + this.version + ", nodes=" + this.nodes + "}";
    }

    public String historyID() {
        return this.historyID;
    }

    public long version() {
        return this.version;
    }

    public Set<DesiredNodeWithStatus> nodes() {
        return Set.copyOf(this.nodes.values());
    }

    public Set<DesiredNode> actualized() {
        return this.actualized;
    }

    public Set<DesiredNode> pending() {
        return this.pending;
    }

    @Override
    public Iterator<DesiredNodeWithStatus> iterator() {
        return this.nodes.values().iterator();
    }

    @Nullable
    public DesiredNodeWithStatus find(String externalId) {
        return this.nodes.get(externalId);
    }

    private static Map<String, DesiredNodeWithStatus> toMap(List<DesiredNodeWithStatus> desiredNodes) {
        return Collections.unmodifiableMap(desiredNodes.stream().collect(Collectors.toMap(DesiredNodeWithStatus::externalId, Function.identity(), (left, right) -> {
            assert (!left.desiredNode().externalId().equals(right.externalId()));
            throw new IllegalStateException("duplicate desired node external id [" + left.externalId() + "]");
        }, TreeMap::new)));
    }

    private List<DesiredNodeWithStatus> transferStatusInformation(List<DesiredNode> proposedDesiredNodes) {
        ArrayList<DesiredNodeWithStatus> desiredNodesWithStatus = new ArrayList<DesiredNodeWithStatus>(proposedDesiredNodes.size());
        for (DesiredNode desiredNode : proposedDesiredNodes) {
            DesiredNodeWithStatus desiredNodeWithStatus = this.nodes.get(desiredNode.externalId());
            if (desiredNodeWithStatus != null) {
                desiredNodesWithStatus.add(new DesiredNodeWithStatus(desiredNode, desiredNodeWithStatus.status()));
                continue;
            }
            desiredNodesWithStatus.add(new DesiredNodeWithStatus(desiredNode, DesiredNodeWithStatus.Status.PENDING));
        }
        return Collections.unmodifiableList(desiredNodesWithStatus);
    }

    public static ClusterState updateDesiredNodesStatusIfNeeded(ClusterState clusterState) {
        DesiredNodes updatedDesiredNodes;
        DesiredNodes desiredNodes = DesiredNodes.latestFromClusterState(clusterState);
        return desiredNodes == (updatedDesiredNodes = DesiredNodes.updateDesiredNodesStatusIfNeeded(clusterState.nodes(), desiredNodes)) ? clusterState : clusterState.copyAndUpdateMetadata(metadata -> metadata.putCustom("desired_nodes", new DesiredNodesMetadata(updatedDesiredNodes)));
    }

    public static DesiredNodes updateDesiredNodesStatusIfNeeded(DiscoveryNodes discoveryNodes, DesiredNodes desiredNodes) {
        if (desiredNodes == null) {
            return null;
        }
        HashMap<String, DesiredNodeWithStatus> desiredNodesWithUpdatedStatus = null;
        for (DiscoveryNode discoveryNode : discoveryNodes) {
            DesiredNodeWithStatus desiredNode = desiredNodes.find(discoveryNode.getExternalId());
            if (desiredNode == null || !desiredNode.pending()) continue;
            if (desiredNodesWithUpdatedStatus == null) {
                desiredNodesWithUpdatedStatus = new HashMap<String, DesiredNodeWithStatus>(desiredNodes.nodes);
            }
            desiredNodesWithUpdatedStatus.put(desiredNode.externalId(), new DesiredNodeWithStatus(desiredNode.desiredNode(), DesiredNodeWithStatus.Status.ACTUALIZED));
        }
        return desiredNodesWithUpdatedStatus == null ? desiredNodes : new DesiredNodes(desiredNodes.historyID(), desiredNodes.version(), desiredNodesWithUpdatedStatus);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), HISTORY_ID_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> DesiredNodeWithStatus.fromXContent(p), NODES_FIELD);
    }

    public static enum SerializationContext {
        GET_DESIRED_NODES_API,
        CLUSTER_STATE;

    }
}

