/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.indices.IndicesService;

public class MetadataMappingService {
    private static final Logger logger = LogManager.getLogger(MetadataMappingService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    final PutMappingExecutor putMappingExecutor = new PutMappingExecutor();

    @Inject
    public MetadataMappingService(ClusterService clusterService, IndicesService indicesService) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    public void putMapping(PutMappingClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) {
        Metadata metadata = this.clusterService.state().metadata();
        boolean noop = true;
        for (Index index : request.indices()) {
            IndexMetadata indexMetadata = metadata.index(index);
            if (indexMetadata == null) {
                noop = false;
                break;
            }
            MappingMetadata mappingMetadata = indexMetadata.mapping();
            if (mappingMetadata == null) {
                noop = false;
                break;
            }
            if (request.source().equals(mappingMetadata.source())) continue;
            noop = false;
            break;
        }
        if (noop) {
            listener.onResponse(AcknowledgedResponse.TRUE);
            return;
        }
        PutMappingClusterStateUpdateTask task = new PutMappingClusterStateUpdateTask(request, listener);
        this.clusterService.submitStateUpdateTask("put-mapping " + Strings.arrayToCommaDelimitedString(request.indices()), task, ClusterStateTaskConfig.build(Priority.HIGH, request.masterNodeTimeout()), this.putMappingExecutor);
    }

    class PutMappingExecutor
    implements ClusterStateTaskExecutor<PutMappingClusterStateUpdateTask> {
        PutMappingExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<PutMappingClusterStateUpdateTask> batchExecutionContext) throws Exception {
            HashMap<Index, MapperService> indexMapperServices = new HashMap<Index, MapperService>();
            try {
                ClusterState currentState = batchExecutionContext.initialState();
                for (ClusterStateTaskExecutor.TaskContext<PutMappingClusterStateUpdateTask> taskContext : batchExecutionContext.taskContexts()) {
                    PutMappingClusterStateUpdateTask task = taskContext.getTask();
                    PutMappingClusterStateUpdateRequest request = task.request;
                    try {
                        Releasable ignored = taskContext.captureResponseHeaders();
                        try {
                            for (Index index : request.indices()) {
                                IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
                                if (indexMapperServices.containsKey(indexMetadata.getIndex())) continue;
                                MapperService mapperService = MetadataMappingService.this.indicesService.createIndexMapperServiceForValidation(indexMetadata);
                                indexMapperServices.put(index, mapperService);
                                mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
                            }
                            currentState = PutMappingExecutor.applyRequest(currentState, request, indexMapperServices);
                            taskContext.success(task);
                        }
                        finally {
                            if (ignored == null) continue;
                            ignored.close();
                        }
                    }
                    catch (Exception e) {
                        taskContext.onFailure(e);
                    }
                }
                ClusterState clusterState = currentState;
                return clusterState;
            }
            finally {
                IOUtils.close(indexMapperServices.values());
            }
        }

        private static ClusterState applyRequest(ClusterState currentState, PutMappingClusterStateUpdateRequest request, Map<Index, MapperService> indexMapperServices) {
            CompressedXContent mappingUpdateSource = request.source();
            Metadata metadata = currentState.metadata();
            ArrayList<IndexMetadata> updateList = new ArrayList<IndexMetadata>();
            for (Index index : request.indices()) {
                MapperService mapperService = indexMapperServices.get(index);
                IndexMetadata indexMetadata = currentState.getMetadata().getIndexSafe(index);
                DocumentMapper existingMapper = mapperService.documentMapper();
                if (existingMapper != null && existingMapper.mappingSource().equals(mappingUpdateSource)) continue;
                updateList.add(indexMetadata);
                Mapping mapping = mapperService.parseMapping("_doc", mappingUpdateSource);
                MapperService.mergeMappings(mapperService.documentMapper(), mapping, MapperService.MergeReason.MAPPING_UPDATE);
            }
            Metadata.Builder builder = Metadata.builder(metadata);
            boolean updated = false;
            for (IndexMetadata indexMetadata : updateList) {
                boolean updatedMapping = false;
                Index index = indexMetadata.getIndex();
                MapperService mapperService = indexMapperServices.get(index);
                CompressedXContent existingSource = null;
                DocumentMapper existingMapper = mapperService.documentMapper();
                if (existingMapper != null) {
                    existingSource = existingMapper.mappingSource();
                }
                DocumentMapper mergedMapper = mapperService.merge("_doc", mappingUpdateSource, MapperService.MergeReason.MAPPING_UPDATE);
                CompressedXContent updatedSource = mergedMapper.mappingSource();
                if (existingSource != null) {
                    if (!existingSource.equals(updatedSource)) {
                        updatedMapping = true;
                        if (logger.isDebugEnabled()) {
                            logger.debug("{} update_mapping [{}] with source [{}]", (Object)index, (Object)mergedMapper.type(), (Object)updatedSource);
                        } else if (logger.isInfoEnabled()) {
                            logger.info("{} update_mapping [{}]", (Object)index, (Object)mergedMapper.type());
                        }
                    }
                } else {
                    updatedMapping = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} create_mapping with source [{}]", (Object)index, (Object)updatedSource);
                    } else if (logger.isInfoEnabled()) {
                        logger.info("{} create_mapping", (Object)index);
                    }
                }
                IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexMetadata);
                DocumentMapper mapper = mapperService.documentMapper();
                if (mapper != null) {
                    indexMetadataBuilder.putMapping(new MappingMetadata(mapper));
                }
                if (updatedMapping) {
                    indexMetadataBuilder.mappingVersion(1L + indexMetadataBuilder.mappingVersion());
                }
                builder.put(indexMetadataBuilder);
                updated |= updatedMapping;
            }
            if (updated) {
                return ClusterState.builder(currentState).metadata(builder).build();
            }
            return currentState;
        }
    }

    record PutMappingClusterStateUpdateTask(PutMappingClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) implements ClusterStateTaskListener,
    ClusterStateAckListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        @Override
        public boolean mustAck(DiscoveryNode discoveryNode) {
            return true;
        }

        @Override
        public void onAllNodesAcked() {
            this.listener.onResponse(AcknowledgedResponse.of(true));
        }

        @Override
        public void onAckFailure(Exception e) {
            this.listener.onResponse(AcknowledgedResponse.of(false));
        }

        @Override
        public void onAckTimeout() {
            this.listener.onResponse(AcknowledgedResponse.FALSE);
        }

        @Override
        public TimeValue ackTimeout() {
            return this.request.ackTimeout();
        }
    }
}

