/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.NodeAllocationOrdering;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardAssignment;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.PriorityComparator;
import org.elasticsearch.index.shard.ShardId;

public class DesiredBalanceReconciler {
    private static final Logger logger = LogManager.getLogger(DesiredBalanceReconciler.class);
    private final DesiredBalance desiredBalance;
    private final RoutingAllocation allocation;
    private final RoutingNodes routingNodes;
    private final NodeAllocationOrdering allocationOrdering;

    DesiredBalanceReconciler(DesiredBalance desiredBalance, RoutingAllocation routingAllocation, NodeAllocationOrdering allocationOrdering) {
        this.desiredBalance = desiredBalance;
        this.allocation = routingAllocation;
        this.routingNodes = routingAllocation.routingNodes();
        this.allocationOrdering = allocationOrdering;
    }

    void run() {
        logger.debug("Reconciling desired balance for [{}]", (Object)this.desiredBalance.lastConvergedIndex());
        if (this.routingNodes.size() == 0) {
            this.failAllocationOfNewPrimaries(this.allocation);
            logger.trace("no nodes available, nothing to reconcile");
            return;
        }
        if (this.desiredBalance.assignments().isEmpty()) {
            logger.trace("desired balance is empty, nothing to reconcile");
            return;
        }
        logger.trace("Reconciler#allocateUnassigned");
        this.allocateUnassigned();
        assert (this.allocateUnassignedInvariant());
        logger.trace("Reconciler#moveShards");
        this.moveShards();
        logger.trace("Reconciler#balance");
        this.balance();
        logger.debug("Reconciliation is complete");
    }

    private boolean allocateUnassignedInvariant() {
        assert (this.routingNodes.unassigned().isEmpty());
        Map<ShardId, Integer> shardCounts = this.allocation.metadata().stream().filter(indexMetadata -> indexMetadata.getCreationVersion().onOrAfter(Version.V_7_2_0) || indexMetadata.getState() == IndexMetadata.State.OPEN || MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata)).flatMap(indexMetadata -> IntStream.range(0, indexMetadata.getNumberOfShards()).mapToObj(shardId -> Tuple.tuple((Object)new ShardId(indexMetadata.getIndex(), shardId), (Object)(indexMetadata.getNumberOfReplicas() + 1)))).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
        for (ShardRouting shardRouting : this.routingNodes.unassigned().ignored()) {
            shardCounts.computeIfPresent(shardRouting.shardId(), (ignored, count) -> count == 1 ? null : Integer.valueOf(count - 1));
        }
        for (RoutingNode routingNode : this.routingNodes) {
            for (ShardRouting shardRouting : routingNode) {
                shardCounts.computeIfPresent(shardRouting.shardId(), (ignored, count) -> count == 1 ? null : Integer.valueOf(count - 1));
            }
        }
        assert (shardCounts.isEmpty()) : shardCounts;
        return true;
    }

    private void failAllocationOfNewPrimaries(RoutingAllocation allocation) {
        RoutingNodes routingNodes = allocation.routingNodes();
        assert (routingNodes.size() == 0) : routingNodes;
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            ShardRouting shardRouting = unassignedIterator.next();
            UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
            if (!shardRouting.primary() || unassignedInfo.getLastAllocationStatus() != UnassignedInfo.AllocationStatus.NO_ATTEMPT) continue;
            unassignedIterator.updateUnassigned(new UnassignedInfo(unassignedInfo.getReason(), unassignedInfo.getMessage(), unassignedInfo.getFailure(), unassignedInfo.getNumFailedAllocations(), unassignedInfo.getUnassignedTimeInNanos(), unassignedInfo.getUnassignedTimeInMillis(), unassignedInfo.isDelayed(), UnassignedInfo.AllocationStatus.DECIDERS_NO, unassignedInfo.getFailedNodeIds(), unassignedInfo.getLastAllocatedNodeId()), shardRouting.recoverySource(), allocation.changes());
        }
    }

    private void allocateUnassigned() {
        RoutingNodes.UnassignedShards unassigned = this.routingNodes.unassigned();
        if (logger.isTraceEnabled()) {
            logger.trace("Start allocating unassigned shards: {}", (Object)this.routingNodes.toString());
        }
        if (unassigned.isEmpty()) {
            return;
        }
        PriorityComparator secondaryComparator = PriorityComparator.getAllocationComparator(this.allocation);
        Comparator comparator = (o1, o2) -> {
            if (o1.primary() ^ o2.primary()) {
                return o1.primary() ? -1 : 1;
            }
            if (o1.getIndexName().compareTo(o2.getIndexName()) == 0) {
                return o1.getId() - o2.getId();
            }
            int secondary = secondaryComparator.compare((ShardRouting)o1, (ShardRouting)o2);
            assert (secondary != 0) : "Index names are equal, should be returned early.";
            return secondary;
        };
        Object[] primary = unassigned.drain();
        Object[] secondary = new ShardRouting[primary.length];
        int secondaryLength = 0;
        int primaryLength = primary.length;
        ArrayUtil.timSort((Object[])primary, (Comparator)comparator);
        do {
            block6: for (int i = 0; i < primaryLength; ++i) {
                Object shard = primary[i];
                ShardAssignment assignment = this.desiredBalance.getAssignment(((ShardRouting)shard).shardId());
                AtomicBoolean isThrottled = new AtomicBoolean(false);
                if (assignment != null) {
                    for (Iterable<String> nodeIdIterator : List.of(this.getDesiredNodesIds((ShardRouting)shard, assignment), this.getFallbackNodeIds((ShardRouting)shard, isThrottled))) {
                        for (String desiredNodeId : nodeIdIterator) {
                            RoutingNode routingNode = this.routingNodes.node(desiredNodeId);
                            if (routingNode == null) continue;
                            Decision decision = this.allocation.deciders().canAllocate((ShardRouting)shard, routingNode, this.allocation);
                            switch (decision.type()) {
                                case YES: {
                                    if (logger.isTraceEnabled()) {
                                        logger.trace("Assigned shard [{}] to [{}]", shard, (Object)desiredNodeId);
                                    }
                                    long shardSize = DiskThresholdDecider.getExpectedShardSize((ShardRouting)shard, -1L, this.allocation.clusterInfo(), this.allocation.snapshotShardSizeInfo(), this.allocation.metadata(), this.allocation.routingTable());
                                    this.routingNodes.initializeShard((ShardRouting)shard, desiredNodeId, null, shardSize, this.allocation.changes());
                                    this.allocationOrdering.recordAllocation(desiredNodeId);
                                    if (((ShardRouting)shard).primary()) continue block6;
                                    while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                                        secondary[secondaryLength++] = primary[++i];
                                    }
                                    continue block6;
                                }
                                case THROTTLE: {
                                    isThrottled.set(true);
                                    break;
                                }
                                case NO: {
                                    if (logger.isTraceEnabled()) {
                                        logger.trace("Couldn't assign shard [{}] to [{}]", (Object)((ShardRouting)shard).shardId(), (Object)desiredNodeId);
                                    } else {
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("No eligible node found to assign shard [{}] amongst [{}]", shard, (Object)assignment);
                }
                UnassignedInfo.AllocationStatus allocationStatus = assignment == null || assignment.isIgnored(((ShardRouting)shard).primary()) ? UnassignedInfo.AllocationStatus.NO_ATTEMPT : (isThrottled.get() ? UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED : UnassignedInfo.AllocationStatus.DECIDERS_NO);
                unassigned.ignoreShard((ShardRouting)shard, allocationStatus, this.allocation.changes());
                if (((ShardRouting)shard).primary()) continue;
                while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                    unassigned.ignoreShard((ShardRouting)primary[++i], allocationStatus, this.allocation.changes());
                }
            }
            primaryLength = secondaryLength;
            Object[] tmp = primary;
            primary = secondary;
            secondary = tmp;
            secondaryLength = 0;
        } while (primaryLength > 0);
    }

    private Iterable<String> getDesiredNodesIds(ShardRouting shard, ShardAssignment assignment) {
        return this.allocationOrdering.sort((Collection<String>)this.allocation.deciders().getForcedInitialShardAllocationToNodes(shard, this.allocation).map(forced -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Shard [{}] assignment is ignored. Initial allocation forced to {}", (Object)shard.shardId(), forced);
            }
            return forced;
        }).orElse(assignment.nodeIds()));
    }

    private Iterable<String> getFallbackNodeIds(ShardRouting shard, AtomicBoolean isThrottled) {
        return () -> {
            if (shard.primary() && !isThrottled.get()) {
                List<String> fallbackNodeIds = this.allocation.routingNodes().stream().map(RoutingNode::nodeId).toList();
                if (logger.isDebugEnabled()) {
                    logger.trace("Shard [{}] assignment is temporary not possible. Falling back to {}", (Object)shard.shardId(), fallbackNodeIds);
                }
                return this.allocationOrdering.sort(fallbackNodeIds).iterator();
            }
            return Collections.emptyIterator();
        };
    }

    private void moveShards() {
        Iterator<ShardRouting> iterator = this.routingNodes.nodeInterleavedShardIterator();
        while (iterator.hasNext()) {
            DiscoveryNode moveTarget;
            ShardAssignment assignment;
            ShardRouting shardRouting = iterator.next();
            if (!shardRouting.started() || (assignment = this.desiredBalance.getAssignment(shardRouting.shardId())) == null || assignment.nodeIds().contains(shardRouting.currentNodeId()) || this.allocation.deciders().canAllocate(shardRouting, this.allocation).type() != Decision.Type.YES) continue;
            RoutingNode routingNode = this.routingNodes.node(shardRouting.currentNodeId());
            Decision canRemainDecision = this.allocation.deciders().canRemain(shardRouting, routingNode, this.allocation);
            if (canRemainDecision.type() != Decision.Type.NO || (moveTarget = this.findRelocationTarget(shardRouting, assignment.nodeIds())) == null) continue;
            this.routingNodes.relocateShard(shardRouting, moveTarget.getId(), this.allocation.clusterInfo().getShardSize(shardRouting, -1L), this.allocation.changes());
        }
    }

    private void balance() {
        if (this.allocation.deciders().canRebalance(this.allocation).type() != Decision.Type.YES) {
            return;
        }
        Iterator<ShardRouting> iterator = this.routingNodes.nodeInterleavedShardIterator();
        while (iterator.hasNext()) {
            DiscoveryNode rebalanceTarget;
            ShardAssignment assignment;
            ShardRouting shardRouting = iterator.next();
            if (!shardRouting.started() || (assignment = this.desiredBalance.getAssignment(shardRouting.shardId())) == null || assignment.nodeIds().contains(shardRouting.currentNodeId()) || this.allocation.deciders().canRebalance(shardRouting, this.allocation).type() != Decision.Type.YES || this.allocation.deciders().canAllocate(shardRouting, this.allocation).type() != Decision.Type.YES || (rebalanceTarget = this.findRelocationTarget(shardRouting, assignment.nodeIds(), this::decideCanAllocate)) == null) continue;
            this.routingNodes.relocateShard(shardRouting, rebalanceTarget.getId(), this.allocation.clusterInfo().getShardSize(shardRouting, -1L), this.allocation.changes());
        }
    }

    private DiscoveryNode findRelocationTarget(ShardRouting shardRouting, Set<String> desiredNodeIds) {
        boolean shardsOnReplacedNode;
        DiscoveryNode moveDecision = this.findRelocationTarget(shardRouting, desiredNodeIds, this::decideCanAllocate);
        if (moveDecision != null) {
            return moveDecision;
        }
        SingleNodeShutdownMetadata shutdown = this.allocation.metadata().nodeShutdowns().get(shardRouting.currentNodeId());
        boolean bl = shardsOnReplacedNode = shutdown != null && shutdown.getType().equals((Object)SingleNodeShutdownMetadata.Type.REPLACE);
        if (shardsOnReplacedNode) {
            return this.findRelocationTarget(shardRouting, desiredNodeIds, this::decideCanForceAllocateForVacate);
        }
        return null;
    }

    private DiscoveryNode findRelocationTarget(ShardRouting shardRouting, Set<String> desiredNodeIds, BiFunction<ShardRouting, RoutingNode, Decision> canAllocateDecider) {
        for (String nodeId : desiredNodeIds) {
            RoutingNode node;
            if (nodeId.equals(shardRouting.currentNodeId()) || (node = this.routingNodes.node(nodeId)) == null) continue;
            Decision decision = canAllocateDecider.apply(shardRouting, node);
            logger.trace("relocate {} to {}: {}", (Object)shardRouting, (Object)nodeId, (Object)decision);
            if (decision.type() != Decision.Type.YES) continue;
            return node.node();
        }
        return null;
    }

    private Decision decideCanAllocate(ShardRouting shardRouting, RoutingNode target) {
        assert (target != null) : "Target node is not found";
        return this.allocation.deciders().canAllocate(shardRouting, target, this.allocation);
    }

    private Decision decideCanForceAllocateForVacate(ShardRouting shardRouting, RoutingNode target) {
        assert (target != null) : "Target node is not found";
        return this.allocation.deciders().canForceAllocateDuringReplace(shardRouting, target, this.allocation);
    }
}

