/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.threadpool.ThreadPool;

public class PendingListenersQueue {
    private static final Logger logger = LogManager.getLogger(PendingListenersQueue.class);
    private final ThreadPool threadPool;
    private final Queue<PendingListener> pendingListeners = new LinkedList<PendingListener>();
    private volatile long completedIndex = -1L;

    public PendingListenersQueue(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long index, ActionListener<Void> listener) {
        Queue<PendingListener> queue = this.pendingListeners;
        synchronized (queue) {
            this.pendingListeners.add(new PendingListener(index, listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(long convergedIndex) {
        assert (MasterService.assertMasterUpdateOrTestThread());
        Queue<PendingListener> queue = this.pendingListeners;
        synchronized (queue) {
            if (convergedIndex > this.completedIndex) {
                this.completedIndex = convergedIndex;
            }
        }
        this.executeListeners(this.completedIndex, true);
    }

    public void completeAllAsNotMaster() {
        assert (MasterService.assertMasterUpdateOrTestThread());
        this.completedIndex = -1L;
        this.executeListeners(Long.MAX_VALUE, false);
    }

    public long getCompletedIndex() {
        return this.completedIndex;
    }

    private void executeListeners(long convergedIndex, boolean isMaster) {
        Collection<ActionListener<Void>> listeners = this.pollListeners(convergedIndex);
        if (!listeners.isEmpty()) {
            this.threadPool.generic().execute(() -> {
                if (isMaster) {
                    ActionListener.onResponse(listeners, null);
                } else {
                    ActionListener.onFailure(listeners, new NotMasterException("no longer master"));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ActionListener<Void>> pollListeners(long maxIndex) {
        ArrayList<ActionListener<Void>> listeners = new ArrayList<ActionListener<Void>>();
        Queue<PendingListener> queue = this.pendingListeners;
        synchronized (queue) {
            PendingListener listener;
            while ((listener = this.pendingListeners.peek()) != null && listener.index <= maxIndex) {
                listeners.add(this.pendingListeners.poll().listener);
            }
            logger.trace("Polled listeners up to [{}]. Poll {}, remaining {}", (Object)maxIndex, listeners, this.pendingListeners);
        }
        return listeners;
    }

    private record PendingListener(long index, ActionListener<Void> listener) {
    }
}

