/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.util.set.Sets;

public class AllocationDeciders {
    private static final Logger logger = LogManager.getLogger(AllocationDeciders.class);
    private static final Decision NO_IGNORING_SHARD_FOR_NODE = Decision.single(Decision.Type.NO, "ignored_shards_for_node", "shard temporarily ignored for node due to earlier failure", new Object[0]);
    private final AllocationDecider[] allocations;

    public AllocationDeciders(Collection<AllocationDecider> allocations) {
        this.allocations = (AllocationDecider[])allocations.toArray(AllocationDecider[]::new);
    }

    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRebalance(shardRouting, allocation);
            if (decision.type() == Decision.Type.NO) {
                if (!allocation.debugDecision()) {
                    return Decision.NO;
                }
                ret.add(decision);
                continue;
            }
            AllocationDeciders.addDecision(ret, decision, allocation);
        }
        return ret;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return NO_IGNORING_SHARD_FOR_NODE;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(shardRouting, node, allocation);
            if (decision.type() == Decision.Type.NO) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Can not allocate [{}] on node [{}] due to [{}]", (Object)shardRouting, (Object)node.node(), (Object)allocationDecider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return Decision.NO;
                }
                ret.add(decision);
                continue;
            }
            AllocationDeciders.addDecision(ret, decision, allocation);
        }
        return ret;
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            if (logger.isTraceEnabled()) {
                logger.trace("Shard [{}] should be ignored for node [{}]", (Object)shardRouting, (Object)node.nodeId());
            }
            return NO_IGNORING_SHARD_FOR_NODE;
        }
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
        if (allocation.debugDecision()) {
            Decision.Multi ret = new Decision.Multi();
            for (AllocationDecider allocationDecider : this.allocations) {
                Decision decision = allocationDecider.canRemain(indexMetadata, shardRouting, node, allocation);
                if (decision.type() == Decision.Type.NO) {
                    this.maybeTraceLogNoDecision(shardRouting, node, allocationDecider);
                    ret.add(decision);
                    continue;
                }
                AllocationDeciders.addDecision(ret, decision, allocation);
            }
            return ret;
        }
        Decision ret = Decision.YES;
        for (AllocationDecider allocationDecider : this.allocations) {
            switch (allocationDecider.canRemain(indexMetadata, shardRouting, node, allocation).type()) {
                case NO: {
                    this.maybeTraceLogNoDecision(shardRouting, node, allocationDecider);
                    return Decision.NO;
                }
                case THROTTLE: {
                    ret = Decision.THROTTLE;
                }
            }
        }
        return ret;
    }

    private void maybeTraceLogNoDecision(ShardRouting shardRouting, RoutingNode node, AllocationDecider allocationDecider) {
        if (logger.isTraceEnabled()) {
            logger.trace("Shard [{}] can not remain on node [{}] due to [{}]", (Object)shardRouting, (Object)node.nodeId(), (Object)allocationDecider.getClass().getSimpleName());
        }
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(indexMetadata, node, allocation);
            if (decision.type() == Decision.Type.NO) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Can not allocate [{}] on node [{}] due to [{}]", (Object)indexMetadata.getIndex().getName(), (Object)node.node(), (Object)allocationDecider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return Decision.NO;
                }
                ret.add(decision);
                continue;
            }
            AllocationDeciders.addDecision(ret, decision, allocation);
        }
        return ret;
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.shouldAutoExpandToNode(indexMetadata, node, allocation);
            if (decision.type() == Decision.Type.NO) {
                if (!allocation.debugDecision()) {
                    return Decision.NO;
                }
                ret.add(decision);
                continue;
            }
            AllocationDeciders.addDecision(ret, decision, allocation);
        }
        return ret;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(shardRouting, allocation);
            if (decision.type() == Decision.Type.NO) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Can not allocate [{}] on any node due to [{}]", (Object)shardRouting, (Object)allocationDecider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return Decision.NO;
                }
                ret.add(decision);
                continue;
            }
            AllocationDeciders.addDecision(ret, decision, allocation);
        }
        return ret;
    }

    public Decision canRebalance(RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRebalance(allocation);
            if (decision.type() == Decision.Type.NO) {
                if (!allocation.debugDecision()) {
                    return Decision.NO;
                }
                ret.add(decision);
                continue;
            }
            AllocationDeciders.addDecision(ret, decision, allocation);
        }
        return ret;
    }

    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard routing " + shardRouting;
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return NO_IGNORING_SHARD_FOR_NODE;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider decider : this.allocations) {
            Decision decision = decider.canForceAllocatePrimary(shardRouting, node, allocation);
            if (decision.type() == Decision.Type.NO) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Shard [{}] can not be forcefully allocated to node [{}] due to [{}].", (Object)shardRouting.shardId(), (Object)node.nodeId(), (Object)decider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return Decision.NO;
                }
                ret.add(decision);
                continue;
            }
            AllocationDeciders.addDecision(ret, decision, allocation);
        }
        return ret;
    }

    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canForceAllocateDuringReplace(shardRouting, node, allocation);
            if (decision.type() == Decision.Type.NO) {
                if (!allocation.debugDecision()) {
                    return Decision.NO;
                }
                ret.add(decision);
                continue;
            }
            AllocationDeciders.addDecision(ret, decision, allocation);
        }
        return ret;
    }

    public Decision canAllocateReplicaWhenThereIsRetentionLease(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return NO_IGNORING_SHARD_FOR_NODE;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocateReplicaWhenThereIsRetentionLease(shardRouting, node, allocation);
            if (decision.type() == Decision.Type.NO) {
                if (!allocation.debugDecision()) {
                    return Decision.NO;
                }
                ret.add(decision);
                continue;
            }
            AllocationDeciders.addDecision(ret, decision, allocation);
        }
        return ret;
    }

    private static void addDecision(Decision.Multi ret, Decision decision, RoutingAllocation allocation) {
        if (decision != Decision.ALWAYS && (allocation.getDebugMode() == RoutingAllocation.DebugMode.ON || decision.type() != Decision.Type.YES)) {
            ret.add(decision);
        }
    }

    public Optional<Set<String>> getForcedInitialShardAllocationToNodes(ShardRouting shardRouting, RoutingAllocation allocation) {
        Optional<Set<String>> result = Optional.empty();
        for (AllocationDecider allocationDecider : this.allocations) {
            Optional<Set<String>> r = allocationDecider.getForcedInitialShardAllocationToNodes(shardRouting, allocation);
            if (!r.isPresent()) continue;
            result = result.isEmpty() ? r : Optional.of(Sets.intersection(result.get(), r.get()));
        }
        return result;
    }
}

