/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Map;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public class NodeShutdownAllocationDecider
extends AllocationDecider {
    private static final String NAME = "node_shutdown";
    private static final Decision YES_EMPTY_SHUTDOWN_METADATA = Decision.single(Decision.Type.YES, "node_shutdown", "no nodes are shutting down", new Object[0]);
    private static final Decision YES_NODE_NOT_SHUTTING_DOWN = Decision.single(Decision.Type.YES, "node_shutdown", "this node is not shutting down", new Object[0]);

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return NodeShutdownAllocationDecider.getDecision(allocation, node.nodeId());
    }

    @Override
    public Decision canRemain(IndexMetadata indexMetadata, ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }

    @Override
    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        return NodeShutdownAllocationDecider.getDecision(allocation, node.getId());
    }

    private static Decision getDecision(RoutingAllocation allocation, String nodeId) {
        Map<String, SingleNodeShutdownMetadata> nodeShutdowns = allocation.metadata().nodeShutdowns();
        if (nodeShutdowns.isEmpty()) {
            return YES_EMPTY_SHUTDOWN_METADATA;
        }
        SingleNodeShutdownMetadata thisNodeShutdownMetadata = nodeShutdowns.get(nodeId);
        if (thisNodeShutdownMetadata == null) {
            return YES_NODE_NOT_SHUTTING_DOWN;
        }
        return switch (thisNodeShutdownMetadata.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case SingleNodeShutdownMetadata.Type.REPLACE, SingleNodeShutdownMetadata.Type.REMOVE -> allocation.decision(Decision.NO, NAME, "node [%s] is preparing to be removed from the cluster", nodeId);
            case SingleNodeShutdownMetadata.Type.RESTART -> allocation.decision(Decision.YES, NAME, "node [%s] is preparing to restart, but will remain in the cluster", nodeId);
        };
    }
}

