/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;

class BytesReferenceStreamInput
extends StreamInput {
    protected final BytesReference bytesReference;
    private BytesRefIterator iterator;
    private int sliceIndex;
    private BytesRef slice;
    private int sliceStartOffset;
    private int mark = 0;

    BytesReferenceStreamInput(BytesReference bytesReference) throws IOException {
        this.bytesReference = bytesReference;
        this.iterator = bytesReference.iterator();
        this.slice = this.iterator.next();
        this.sliceStartOffset = 0;
        this.sliceIndex = 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.maybeNextSlice();
        return this.slice.bytes[this.slice.offset + this.sliceIndex++];
    }

    @Override
    public short readShort() throws IOException {
        if (this.slice.length - this.sliceIndex >= 2) {
            this.sliceIndex += 2;
            return Numbers.bytesToShort(this.slice.bytes, this.slice.offset + this.sliceIndex - 2);
        }
        return super.readShort();
    }

    @Override
    public int readInt() throws IOException {
        if (this.slice.length - this.sliceIndex >= 4) {
            this.sliceIndex += 4;
            return Numbers.bytesToInt(this.slice.bytes, this.slice.offset + this.sliceIndex - 4);
        }
        return super.readInt();
    }

    @Override
    public long readLong() throws IOException {
        if (this.slice.length - this.sliceIndex >= 8) {
            this.sliceIndex += 8;
            return Numbers.bytesToLong(this.slice.bytes, this.slice.offset + this.sliceIndex - 8);
        }
        return super.readLong();
    }

    @Override
    public int readVInt() throws IOException {
        if (this.slice.length - this.sliceIndex >= 5) {
            byte b;
            byte[] buf = this.slice.bytes;
            int offset = this.slice.offset;
            if ((b = buf[offset + this.sliceIndex++]) >= 0) {
                return b;
            }
            int i = b & 0x7F;
            b = buf[offset + this.sliceIndex++];
            i |= (b & 0x7F) << 7;
            if (b >= 0) {
                return i;
            }
            b = buf[offset + this.sliceIndex++];
            i |= (b & 0x7F) << 14;
            if (b >= 0) {
                return i;
            }
            b = buf[offset + this.sliceIndex++];
            i |= (b & 0x7F) << 21;
            if (b >= 0) {
                return i;
            }
            b = buf[offset + this.sliceIndex++];
            i |= (b & 0xF) << 28;
            if ((b & 0xF0) == 0) {
                return i;
            }
            BytesReferenceStreamInput.throwOnBrokenVInt(b, i);
        }
        return super.readVInt();
    }

    @Override
    public long readVLong() throws IOException {
        if (this.slice.length - this.sliceIndex >= 10) {
            byte[] buf = this.slice.bytes;
            int offset = this.slice.offset;
            byte b = buf[offset + this.sliceIndex++];
            long i = (long)b & 0x7FL;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = buf[offset + this.sliceIndex++];
            i |= ((long)b & 0x7FL) << 7;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = buf[offset + this.sliceIndex++];
            i |= ((long)b & 0x7FL) << 14;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = buf[offset + this.sliceIndex++];
            i |= ((long)b & 0x7FL) << 21;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = buf[offset + this.sliceIndex++];
            i |= ((long)b & 0x7FL) << 28;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = buf[offset + this.sliceIndex++];
            i |= ((long)b & 0x7FL) << 35;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = buf[offset + this.sliceIndex++];
            i |= ((long)b & 0x7FL) << 42;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = buf[offset + this.sliceIndex++];
            i |= ((long)b & 0x7FL) << 49;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = buf[offset + this.sliceIndex++];
            i |= ((long)b & 0x7FL) << 56;
            if ((b & 0x80) == 0) {
                return i;
            }
            if ((b = buf[offset + this.sliceIndex++]) != 0 && b != 1) {
                BytesReferenceStreamInput.throwOnBrokenVLong(b, i);
            }
            return i |= (long)b << 63;
        }
        return super.readVLong();
    }

    protected int offset() {
        return this.sliceStartOffset + this.sliceIndex;
    }

    private void maybeNextSlice() throws IOException {
        if (this.sliceIndex == this.slice.length) {
            this.moveToNextSlice();
        }
    }

    private void moveToNextSlice() throws IOException {
        this.slice = this.iterator.next();
        while (this.slice != null && this.slice.length == 0) {
            this.slice = this.iterator.next();
        }
        if (this.slice == null) {
            throw new EOFException();
        }
        this.sliceStartOffset += this.sliceIndex;
        this.sliceIndex = 0;
    }

    @Override
    public void readBytes(byte[] b, int bOffset, int len) throws IOException {
        int length = this.bytesReference.length();
        int offset = this.offset();
        if (offset + len > length) {
            BytesReferenceStreamInput.throwIndexOutOfBounds(len, length, offset);
        }
        int bytesRead = this.read(b, bOffset, len);
        assert (bytesRead == len) : bytesRead + " vs " + len;
    }

    private static void throwIndexOutOfBounds(int len, int length, int offset) {
        throw new IndexOutOfBoundsException("Cannot read " + len + " bytes from stream with length " + length + " at offset " + offset);
    }

    @Override
    public int read() throws IOException {
        if (this.offset() >= this.bytesReference.length()) {
            return -1;
        }
        return Byte.toUnsignedInt(this.readByte());
    }

    @Override
    public int read(byte[] b, int bOffset, int len) throws IOException {
        int numBytesToCopy;
        int length = this.bytesReference.length();
        int offset = this.offset();
        if (offset >= length) {
            return -1;
        }
        int remaining = numBytesToCopy = Math.min(len, length - offset);
        int destOffset = bOffset;
        while (remaining > 0) {
            this.maybeNextSlice();
            int currentLen = Math.min(remaining, this.slice.length - this.sliceIndex);
            assert (currentLen > 0) : "length has to be > 0 to make progress but was: " + currentLen;
            System.arraycopy(this.slice.bytes, this.slice.offset + this.sliceIndex, b, destOffset, currentLen);
            destOffset += currentLen;
            this.sliceIndex += currentLen;
            assert ((remaining -= currentLen) >= 0) : "remaining: " + remaining;
        }
        return numBytesToCopy;
    }

    @Override
    public void close() {
    }

    @Override
    public int available() {
        return this.bytesReference.length() - this.offset();
    }

    @Override
    protected void ensureCanReadBytes(int bytesToRead) throws EOFException {
        int bytesAvailable = this.bytesReference.length() - this.offset();
        if (bytesAvailable < bytesToRead) {
            BytesReferenceStreamInput.throwEOF(bytesToRead, bytesAvailable);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        int numBytesSkipped;
        if (n <= 0L) {
            return 0L;
        }
        assert (this.offset() <= this.bytesReference.length()) : this.offset() + " vs " + this.bytesReference.length();
        int remaining = numBytesSkipped = (int)Math.min(n, (long)(this.bytesReference.length() - this.offset()));
        while (remaining > 0) {
            this.maybeNextSlice();
            int currentLen = Math.min(remaining, this.slice.length - this.sliceIndex);
            this.sliceIndex += currentLen;
            assert ((remaining -= currentLen) >= 0) : "remaining: " + remaining;
        }
        return numBytesSkipped;
    }

    @Override
    public void reset() throws IOException {
        if (this.sliceStartOffset <= this.mark) {
            this.sliceIndex = this.mark - this.sliceStartOffset;
        } else {
            this.iterator = this.bytesReference.iterator();
            this.slice = this.iterator.next();
            this.sliceStartOffset = 0;
            this.sliceIndex = 0;
            long skipped = this.skip(this.mark);
            assert (skipped == (long)this.mark) : skipped + " vs " + this.mark;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        this.mark = this.offset();
    }
}

