/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.core.Nullable;

public class BytesStreamOutput
extends BytesStream {
    protected final BigArrays bigArrays;
    @Nullable
    protected ByteArray bytes;
    protected int count;

    public BytesStreamOutput() {
        this(0);
    }

    public BytesStreamOutput(int expectedSize) {
        this(expectedSize, BigArrays.NON_RECYCLING_INSTANCE);
    }

    protected BytesStreamOutput(int expectedSize, BigArrays bigArrays) {
        this.bigArrays = bigArrays;
        if (expectedSize != 0) {
            this.bytes = bigArrays.newByteArray(expectedSize, false);
        }
    }

    @Override
    public long position() {
        return this.count;
    }

    @Override
    public void writeByte(byte b) {
        this.ensureCapacity((long)this.count + 1L);
        this.bytes.set(this.count, b);
        ++this.count;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (b.length < offset + length) {
            throw new IllegalArgumentException("Illegal offset " + offset + "/length " + length + " for byte[] of length " + b.length);
        }
        this.ensureCapacity((long)this.count + (long)length);
        this.bytes.set(this.count, b, offset, length);
        this.count += length;
    }

    public void reset() {
        if (this.bytes != null && this.bytes.size() > 16384L) {
            this.bytes = this.bigArrays.resize(this.bytes, 16384L);
        }
        this.count = 0;
    }

    @Override
    public void flush() {
    }

    public void seek(long position) {
        this.ensureCapacity(position);
        this.count = (int)position;
    }

    public void skip(int length) {
        this.seek((long)this.count + (long)length);
    }

    @Override
    public void close() {
    }

    public int size() {
        return this.count;
    }

    @Override
    public BytesReference bytes() {
        if (this.bytes == null) {
            return BytesArray.EMPTY;
        }
        return BytesReference.fromByteArray(this.bytes, this.count);
    }

    public BytesReference copyBytes() {
        BytesReference bytesReference = this.bytes();
        byte[] arr = new byte[this.count];
        if (bytesReference.hasArray()) {
            System.arraycopy(bytesReference.array(), bytesReference.arrayOffset(), arr, 0, bytesReference.length());
        } else {
            BytesStreamOutput.copyToArray(bytesReference, arr);
        }
        return new BytesArray(arr);
    }

    private static void copyToArray(BytesReference bytesReference, byte[] arr) {
        int offset = 0;
        BytesRefIterator iterator = bytesReference.iterator();
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                System.arraycopy(slice.bytes, slice.offset, arr, offset, slice.length);
                offset += slice.length;
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void ensureCapacity(long offset) {
        if (offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " cannot hold more than 2GB of data");
        }
        this.bytes = this.bytes == null ? this.bigArrays.newByteArray(BigArrays.overSize(offset, 16384, 1), false) : this.bigArrays.grow(this.bytes, offset);
    }
}

