/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public abstract class StreamInput
extends InputStream {
    private TransportVersion version = TransportVersion.CURRENT;
    private static final int SMALL_STRING_LIMIT = 1024;
    private static final ThreadLocal<byte[]> stringReadBuffer = ThreadLocal.withInitial(() -> new byte[1024]);
    private static final ThreadLocal<char[]> smallSpare = ThreadLocal.withInitial(() -> new char[1024]);
    private char[] largeSpare;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final TimeUnit[] TIME_UNITS = TimeUnit.values();

    @Deprecated(forRemoval=true)
    public Version getVersion() {
        return Version.fromId(this.version.id);
    }

    public TransportVersion getTransportVersion() {
        return this.version;
    }

    @Deprecated(forRemoval=true)
    public void setVersion(Version version) {
        this.version = version.transportVersion;
    }

    public void setTransportVersion(TransportVersion version) {
        this.version = version;
    }

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public BytesReference readBytesReference() throws IOException {
        int length = this.readArraySize();
        return this.readBytesReference(length);
    }

    public ReleasableBytesReference readReleasableBytesReference() throws IOException {
        return ReleasableBytesReference.wrap(this.readBytesReference());
    }

    @Nullable
    public BytesReference readOptionalBytesReference() throws IOException {
        int length = this.readVInt() - 1;
        if (length < 0) {
            return null;
        }
        return this.readBytesReference(length);
    }

    public BytesReference readBytesReference(int length) throws IOException {
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesArray(bytes, 0, length);
    }

    public BytesRef readBytesRef() throws IOException {
        int length = this.readArraySize();
        return this.readBytesRef(length);
    }

    public BytesRef readBytesRef(int length) throws IOException {
        if (length == 0) {
            return new BytesRef();
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesRef(bytes, 0, length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readBytes(b, 0, b.length);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public Integer readOptionalInt() throws IOException {
        if (this.readBoolean()) {
            return this.readInt();
        }
        return null;
    }

    public int readVInt() throws IOException {
        return this.readVIntSlow();
    }

    protected final int readVIntSlow() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if ((b & 0x80) != 0) {
            StreamInput.throwOnBrokenVInt(b, i);
        }
        return i | (b & 0x7F) << 28;
    }

    protected static void throwOnBrokenVInt(byte b, int accumulated) throws IOException {
        throw new IOException("Invalid vInt ((" + Integer.toHexString(b) + " & 0x7f) << 28) | " + Integer.toHexString(accumulated));
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        return this.readVLongSlow();
    }

    protected final long readVLongSlow() throws IOException {
        byte b = this.readByte();
        long i = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 56;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if (b != 0 && b != 1) {
            StreamInput.throwOnBrokenVLong(b, i);
        }
        return i |= (long)b << 63;
    }

    protected static void throwOnBrokenVLong(byte b, long accumulated) throws IOException {
        throw new IOException("Invalid vlong (" + Integer.toHexString(b) + " << 63) | " + Long.toHexString(accumulated));
    }

    @Nullable
    public Long readOptionalVLong() throws IOException {
        if (this.readBoolean()) {
            return this.readVLong();
        }
        return null;
    }

    public long readZLong() throws IOException {
        long currentByte;
        long accumulator = 0L;
        int i = 0;
        while (((currentByte = (long)this.readByte()) & 0x80L) != 0L) {
            accumulator |= (currentByte & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IOException("variable-length stream is too long");
        }
        return BitUtil.zigZagDecode((long)(accumulator | currentByte << i));
    }

    @Nullable
    public Long readOptionalLong() throws IOException {
        if (this.readBoolean()) {
            return this.readLong();
        }
        return null;
    }

    public BigInteger readBigInteger() throws IOException {
        return new BigInteger(this.readString());
    }

    @Nullable
    public Text readOptionalText() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        return new Text(this.readBytesReference(length));
    }

    public Text readText() throws IOException {
        int length = this.readInt();
        return new Text(this.readBytesReference(length));
    }

    @Nullable
    public String readOptionalString() throws IOException {
        if (this.readBoolean()) {
            return this.readString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SecureString readOptionalSecureString() throws IOException {
        SecureString value = null;
        BytesReference bytesRef = this.readOptionalBytesReference();
        if (bytesRef != null) {
            byte[] bytes = BytesReference.toBytes(bytesRef);
            try {
                value = new SecureString(CharArrays.utf8BytesToChars((byte[])bytes));
            }
            finally {
                Arrays.fill(bytes, (byte)0);
            }
        }
        return value;
    }

    @Nullable
    public Float readOptionalFloat() throws IOException {
        if (this.readBoolean()) {
            return Float.valueOf(this.readFloat());
        }
        return null;
    }

    @Nullable
    public Integer readOptionalVInt() throws IOException {
        if (this.readBoolean()) {
            return this.readVInt();
        }
        return null;
    }

    private char[] ensureLargeSpare(int charCount) {
        char[] spare = this.largeSpare;
        if (spare == null || spare.length < charCount) {
            this.largeSpare = spare = new char[ArrayUtil.oversize((int)charCount, (int)2)];
        }
        return spare;
    }

    public String readString() throws IOException {
        int charCount = this.readArraySize();
        char[] charBuffer = charCount > 1024 ? this.ensureLargeSpare(charCount) : smallSpare.get();
        int charsOffset = 0;
        int offsetByteArray = 0;
        int sizeByteArray = 0;
        int missingFromPartial = 0;
        byte[] byteBuffer = stringReadBuffer.get();
        while (charsOffset < charCount) {
            int toRead;
            int minRemainingBytes;
            int charsLeft = charCount - charsOffset;
            int bufferFree = byteBuffer.length - sizeByteArray;
            if (missingFromPartial > 0) {
                minRemainingBytes = missingFromPartial + charsLeft - 1;
                missingFromPartial = 0;
            } else {
                minRemainingBytes = charsLeft;
            }
            if (bufferFree < minRemainingBytes) {
                if (offsetByteArray > 0) {
                    switch (sizeByteArray -= offsetByteArray) {
                        case 1: {
                            byteBuffer[0] = byteBuffer[offsetByteArray];
                            break;
                        }
                        case 2: {
                            byteBuffer[0] = byteBuffer[offsetByteArray];
                            byteBuffer[1] = byteBuffer[offsetByteArray + 1];
                        }
                    }
                    assert (sizeByteArray <= 2) : "We never copy more than 2 bytes here since a char is 3 bytes max";
                    toRead = Math.min(bufferFree + offsetByteArray, minRemainingBytes);
                    offsetByteArray = 0;
                } else {
                    toRead = bufferFree;
                }
            } else {
                toRead = minRemainingBytes;
            }
            this.readBytes(byteBuffer, sizeByteArray, toRead);
            sizeByteArray += toRead;
            while (offsetByteArray < sizeByteArray - 2) {
                int c = byteBuffer[offsetByteArray] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        charBuffer[charsOffset++] = (char)c;
                        break;
                    }
                    case 12: 
                    case 13: {
                        charBuffer[charsOffset++] = (char)((c & 0x1F) << 6 | byteBuffer[++offsetByteArray] & 0x3F);
                        break;
                    }
                    case 14: {
                        charBuffer[charsOffset++] = (char)((c & 0xF) << 12 | (byteBuffer[++offsetByteArray] & 0x3F) << 6 | byteBuffer[++offsetByteArray] & 0x3F);
                        break;
                    }
                    default: {
                        StreamInput.throwOnBrokenChar(c);
                    }
                }
                ++offsetByteArray;
            }
            int bufferedBytesRemaining = sizeByteArray - offsetByteArray;
            block16: for (int i = 0; i < bufferedBytesRemaining; ++i) {
                int c = byteBuffer[offsetByteArray] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        charBuffer[charsOffset++] = (char)c;
                        ++offsetByteArray;
                        continue block16;
                    }
                    case 12: 
                    case 13: {
                        missingFromPartial = 2 - (bufferedBytesRemaining - i);
                        if (missingFromPartial == 0) {
                            int n = charsOffset++;
                            int n2 = ++offsetByteArray;
                            ++offsetByteArray;
                            charBuffer[n] = (char)((c & 0x1F) << 6 | byteBuffer[n2] & 0x3F);
                        }
                        ++i;
                        continue block16;
                    }
                    case 14: {
                        missingFromPartial = 3 - (bufferedBytesRemaining - i);
                        ++i;
                        continue block16;
                    }
                    default: {
                        StreamInput.throwOnBrokenChar(c);
                    }
                }
            }
        }
        return new String(charBuffer, 0, charCount);
    }

    private static void throwOnBrokenChar(int c) throws IOException {
        throw new IOException("Invalid string; unexpected character: " + c + " hex: " + Integer.toHexString(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureString readSecureString() throws IOException {
        BytesReference bytesRef = this.readBytesReference();
        byte[] bytes = BytesReference.toBytes(bytesRef);
        try {
            SecureString secureString = new SecureString(CharArrays.utf8BytesToChars((byte[])bytes));
            return secureString;
        }
        finally {
            Arrays.fill(bytes, (byte)0);
        }
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Nullable
    public final Double readOptionalDouble() throws IOException {
        if (this.readBoolean()) {
            return this.readDouble();
        }
        return null;
    }

    public final boolean readBoolean() throws IOException {
        return StreamInput.readBoolean(this.readByte());
    }

    private static boolean readBoolean(byte value) {
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        String message = String.format(Locale.ROOT, "unexpected byte [0x%02x]", value);
        throw new IllegalStateException(message);
    }

    @Nullable
    public final Boolean readOptionalBoolean() throws IOException {
        byte value = this.readByte();
        if (value == 2) {
            return null;
        }
        return StreamInput.readBoolean(value);
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract int available() throws IOException;

    public String[] readStringArray() throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Strings.EMPTY_ARRAY;
        }
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readString();
        }
        return ret;
    }

    @Nullable
    public String[] readOptionalStringArray() throws IOException {
        if (this.readBoolean()) {
            return this.readStringArray();
        }
        return null;
    }

    @Nullable
    public byte[] readOptionalByteArray() throws IOException {
        if (this.readBoolean()) {
            return this.readByteArray();
        }
        return null;
    }

    public <K, V> Map<K, V> readMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        return this.readMap(keyReader, valueReader, Maps::newHashMapWithExpectedSize);
    }

    public <K, V> Map<K, V> readOrderedMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        return this.readMap(keyReader, valueReader, Maps::newLinkedHashMapWithExpectedSize);
    }

    private <K, V> Map<K, V> readMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader, IntFunction<Map<K, V>> constructor) throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Collections.emptyMap();
        }
        Map<K, V> map = constructor.apply(size);
        for (int i = 0; i < size; ++i) {
            K key = keyReader.read(this);
            V value = valueReader.read(this);
            map.put(key, value);
        }
        return map;
    }

    public <K, V> Map<K, List<V>> readMapOfLists(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Collections.emptyMap();
        }
        Map<K, List<V>> map = Maps.newMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            map.put(keyReader.read(this), this.readList(valueReader));
        }
        return map;
    }

    public <K, V> Map<K, V> readMapValues(Writeable.Reader<V> valueReader, Function<V, K> keyMapper) throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Map.of();
        }
        Map<K, V> map = Maps.newMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            V value = valueReader.read(this);
            map.put(keyMapper.apply(value), value);
        }
        return map;
    }

    @Nullable
    public Map<String, Object> readMap() throws IOException {
        return (Map)this.readGenericValue();
    }

    public <K, V> Map<K, V> readImmutableMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        int size = this.readVInt();
        if (size == 0) {
            return Map.of();
        }
        if (size == 1) {
            return Map.of(keyReader.read(this), valueReader.read(this));
        }
        Map.Entry[] entries = new Map.Entry[size];
        for (int i = 0; i < size; ++i) {
            entries[i] = Map.entry(keyReader.read(this), valueReader.read(this));
        }
        return Map.ofEntries(entries);
    }

    public <K, V> ImmutableOpenMap<K, V> readImmutableOpenMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        int size = this.readVInt();
        if (size == 0) {
            return ImmutableOpenMap.of();
        }
        ImmutableOpenMap.Builder<K, V> builder = ImmutableOpenMap.builder(size);
        for (int i = 0; i < size; ++i) {
            builder.put(keyReader.read(this), valueReader.read(this));
        }
        return builder.build();
    }

    @Nullable
    public Object readGenericValue() throws IOException {
        byte type = this.readByte();
        return switch (type) {
            case -1 -> null;
            case 0 -> this.readString();
            case 1 -> this.readInt();
            case 2 -> this.readLong();
            case 3 -> Float.valueOf(this.readFloat());
            case 4 -> this.readDouble();
            case 5 -> this.readBoolean();
            case 6 -> this.readByteArray();
            case 7 -> this.readArrayList();
            case 8 -> this.readArray();
            case 9 -> {
                if (this.getTransportVersion().onOrAfter(TransportVersion.V_8_7_0)) {
                    yield this.readOrderedMap(StreamInput::readGenericValue, StreamInput::readGenericValue);
                }
                yield this.readOrderedMap(StreamInput::readString, StreamInput::readGenericValue);
            }
            case 10 -> {
                if (this.getTransportVersion().onOrAfter(TransportVersion.V_8_7_0)) {
                    yield this.readMap(StreamInput::readGenericValue, StreamInput::readGenericValue);
                }
                yield this.readMap(StreamInput::readString, StreamInput::readGenericValue);
            }
            case 11 -> this.readByte();
            case 12 -> this.readDate();
            case 13 -> this.readZonedDateTime();
            case 14 -> this.readBytesReference();
            case 15 -> this.readText();
            case 16 -> this.readShort();
            case 17 -> this.readIntArray();
            case 18 -> this.readLongArray();
            case 19 -> this.readFloatArray();
            case 20 -> this.readDoubleArray();
            case 21 -> this.readBytesRef();
            case 22 -> this.readGeoPoint();
            case 23 -> this.readZonedDateTime();
            case 24 -> this.readCollection(StreamInput::readGenericValue, Sets::newLinkedHashSetWithExpectedSize, Collections.emptySet());
            case 25 -> this.readCollection(StreamInput::readGenericValue, Sets::newHashSetWithExpectedSize, Collections.emptySet());
            case 26 -> this.readBigInteger();
            case 27 -> this.readOffsetTime();
            default -> throw new IOException("Can't read unknown type [" + type + "]");
        };
    }

    public final Instant readInstant() throws IOException {
        return Instant.ofEpochSecond(this.readLong(), this.readInt());
    }

    @Nullable
    public final Instant readOptionalInstant() throws IOException {
        boolean present = this.readBoolean();
        return present ? this.readInstant() : null;
    }

    private List<Object> readArrayList() throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readGenericValue());
        }
        return list;
    }

    private ZonedDateTime readZonedDateTime() throws IOException {
        String timeZoneId = this.readString();
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.readLong()), ZoneId.of(timeZoneId));
    }

    private OffsetTime readOffsetTime() throws IOException {
        String zoneOffsetId = this.readString();
        return OffsetTime.of(LocalTime.ofNanoOfDay(this.readLong()), ZoneOffset.of(zoneOffsetId));
    }

    private Object[] readArray() throws IOException {
        int size8 = this.readArraySize();
        if (size8 == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] list8 = new Object[size8];
        for (int i = 0; i < size8; ++i) {
            list8[i] = this.readGenericValue();
        }
        return list8;
    }

    private Date readDate() throws IOException {
        return new Date(this.readLong());
    }

    public GeoPoint readGeoPoint() throws IOException {
        return new GeoPoint(this.readDouble(), this.readDouble());
    }

    public ZoneId readZoneId() throws IOException {
        return ZoneId.of(this.readString());
    }

    public ZoneId readOptionalZoneId() throws IOException {
        if (this.readBoolean()) {
            return ZoneId.of(this.readString());
        }
        return null;
    }

    public int[] readIntArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readInt();
        }
        return values;
    }

    public int[] readVIntArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readVInt();
        }
        return values;
    }

    public long[] readLongArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] values = new long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readLong();
        }
        return values;
    }

    public long[] readVLongArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] values = new long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readVLong();
        }
        return values;
    }

    public float[] readFloatArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] values = new float[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readFloat();
        }
        return values;
    }

    public double[] readDoubleArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readDouble();
        }
        return values;
    }

    public byte[] readByteArray() throws IOException {
        int length = this.readArraySize();
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, bytes.length);
        return bytes;
    }

    public <T> T[] readArray(Writeable.Reader<T> reader, IntFunction<T[]> arraySupplier) throws IOException {
        int length = this.readArraySize();
        T[] values = arraySupplier.apply(length);
        for (int i = 0; i < length; ++i) {
            values[i] = reader.read(this);
        }
        return values;
    }

    public <T> T[] readOptionalArray(Writeable.Reader<T> reader, IntFunction<T[]> arraySupplier) throws IOException {
        return this.readBoolean() ? this.readArray(reader, arraySupplier) : null;
    }

    @Nullable
    public <T extends Writeable> T readOptionalWriteable(Writeable.Reader<T> reader) throws IOException {
        if (this.readBoolean()) {
            Writeable t = (Writeable)reader.read(this);
            if (t == null) {
                StreamInput.throwOnNullRead(reader);
            }
            return (T)t;
        }
        return null;
    }

    protected static void throwOnNullRead(Writeable.Reader<?> reader) throws IOException {
        IOException e = new IOException("Writeable.Reader [" + reader + "] returned null which is not allowed.");
        assert (false) : e;
        throw e;
    }

    @Nullable
    public <T extends Exception> T readException() throws IOException {
        return (T)((Exception)ElasticsearchException.readException(this));
    }

    public NamedWriteableRegistry namedWriteableRegistry() {
        return null;
    }

    @Nullable
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass) throws IOException {
        throw new UnsupportedOperationException("can't read named writeable from StreamInput");
    }

    @Nullable
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass, String name) throws IOException {
        throw new UnsupportedOperationException("can't read named writeable from StreamInput");
    }

    @Nullable
    public <C extends NamedWriteable> C readOptionalNamedWriteable(Class<C> categoryClass) throws IOException {
        if (this.readBoolean()) {
            return this.readNamedWriteable(categoryClass);
        }
        return null;
    }

    public <T> List<T> readList(Writeable.Reader<T> reader) throws IOException {
        return this.readCollection(reader, ArrayList::new, Collections.emptyList());
    }

    public <T> List<T> readImmutableList(Writeable.Reader<T> reader) throws IOException {
        int count = this.readArraySize();
        if (count == 0) {
            return List.of();
        }
        if (count == 1) {
            return List.of(reader.read(this));
        }
        if (count == 2) {
            return List.of(reader.read(this), reader.read(this));
        }
        Object[] entries = new Object[count];
        for (int i = 0; i < count; ++i) {
            entries[i] = reader.read(this);
        }
        Object[] typedEntries = entries;
        return List.of(typedEntries);
    }

    public List<String> readImmutableStringList() throws IOException {
        return this.readImmutableList(StreamInput::readString);
    }

    public List<String> readStringList() throws IOException {
        return this.readList(StreamInput::readString);
    }

    public <T> List<T> readOptionalList(Writeable.Reader<T> reader) throws IOException {
        boolean isPresent = this.readBoolean();
        return isPresent ? this.readList(reader) : null;
    }

    public List<String> readOptionalStringList() throws IOException {
        return this.readOptionalList(StreamInput::readString);
    }

    public <T> Set<T> readSet(Writeable.Reader<T> reader) throws IOException {
        return this.readCollection(reader, Sets::newHashSetWithExpectedSize, Collections.emptySet());
    }

    private <T, C extends Collection<? super T>> C readCollection(Writeable.Reader<T> reader, IntFunction<C> constructor, C empty) throws IOException {
        int count = this.readArraySize();
        if (count == 0) {
            return empty;
        }
        Collection builder = (Collection)constructor.apply(count);
        for (int i = 0; i < count; ++i) {
            builder.add(reader.read(this));
        }
        return (C)builder;
    }

    public <T extends NamedWriteable> List<T> readNamedWriteableList(Class<T> categoryClass) throws IOException {
        throw new UnsupportedOperationException("can't read named writeable from StreamInput");
    }

    public <E extends Enum<E>> E readEnum(Class<E> enumClass) throws IOException {
        return (E)this.readEnum(enumClass, (Enum[])enumClass.getEnumConstants());
    }

    @Nullable
    public <E extends Enum<E>> E readOptionalEnum(Class<E> enumClass) throws IOException {
        if (this.readBoolean()) {
            return (E)this.readEnum(enumClass, (Enum[])enumClass.getEnumConstants());
        }
        return null;
    }

    private <E extends Enum<E>> E readEnum(Class<E> enumClass, E[] values) throws IOException {
        int ordinal = this.readVInt();
        if (ordinal < 0 || ordinal >= values.length) {
            throw new IOException("Unknown " + enumClass.getSimpleName() + " ordinal [" + ordinal + "]");
        }
        return values[ordinal];
    }

    public <E extends Enum<E>> EnumSet<E> readEnumSet(Class<E> enumClass) throws IOException {
        int size = this.readVInt();
        EnumSet<Enum> res = EnumSet.noneOf(enumClass);
        if (size == 0) {
            return res;
        }
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        for (int i = 0; i < size; ++i) {
            res.add(this.readEnum(enumClass, values));
        }
        return res;
    }

    public static StreamInput wrap(byte[] bytes) {
        return StreamInput.wrap(bytes, 0, bytes.length);
    }

    public static StreamInput wrap(byte[] bytes, int offset, int length) {
        return new ByteBufferStreamInput(ByteBuffer.wrap(bytes, offset, length));
    }

    protected int readArraySize() throws IOException {
        int arraySize = this.readVInt();
        if (arraySize > ArrayUtil.MAX_ARRAY_LENGTH) {
            StreamInput.throwExceedsMaxArraySize(arraySize);
        }
        if (arraySize < 0) {
            StreamInput.throwNegative(arraySize);
        }
        this.ensureCanReadBytes(arraySize);
        return arraySize;
    }

    private static void throwNegative(int arraySize) {
        throw new NegativeArraySizeException("array size must be positive but was: " + arraySize);
    }

    private static void throwExceedsMaxArraySize(int arraySize) {
        throw new IllegalStateException("array length must be <= to " + ArrayUtil.MAX_ARRAY_LENGTH + " but was: " + arraySize);
    }

    protected abstract void ensureCanReadBytes(int var1) throws EOFException;

    protected static void throwEOF(int bytesToRead, int bytesAvailable) throws EOFException {
        throw new EOFException("tried to read: " + bytesToRead + " bytes but only " + bytesAvailable + " remaining");
    }

    public TimeValue readTimeValue() throws IOException {
        long duration = this.readZLong();
        TimeUnit timeUnit = TIME_UNITS[this.readByte()];
        return new TimeValue(duration, timeUnit);
    }

    @Nullable
    public TimeValue readOptionalTimeValue() throws IOException {
        if (this.readBoolean()) {
            return this.readTimeValue();
        }
        return null;
    }

    static {
        if (!Arrays.equals((Object[])TIME_UNITS, (Object[])new TimeUnit[]{TimeUnit.NANOSECONDS, TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS})) {
            throw new AssertionError((Object)"Incompatible JDK version used that breaks assumptions on the structure of the TimeUnit enum");
        }
    }
}

