/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.metrics;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.metrics.CounterMetric;

public class Counters
implements Writeable {
    private final ConcurrentMap<String, CounterMetric> counters = new ConcurrentHashMap<String, CounterMetric>();

    public Counters(StreamInput in) throws IOException {
        int numCounters = in.readVInt();
        for (int i = 0; i < numCounters; ++i) {
            this.inc(in.readString(), in.readVLong());
        }
    }

    public Counters(String ... names) {
        for (String name : names) {
            this.counters.put(name, new CounterMetric());
        }
    }

    public void inc(String name) {
        this.inc(name, 1L);
    }

    public void inc(String name, long count) {
        this.counters.computeIfAbsent(name, ignored -> new CounterMetric()).inc(count);
    }

    public long get(String name) {
        if (this.counters.containsKey(name)) {
            return ((CounterMetric)this.counters.get(name)).count();
        }
        throw new IllegalArgumentException("Counter with name " + name + " does not exist.");
    }

    public long size() {
        return this.counters.size();
    }

    public boolean hasCounters() {
        return !this.counters.isEmpty();
    }

    public Map<String, Object> toMutableNestedMap() {
        HashMap<String, Object> root = new HashMap<String, Object>();
        for (Map.Entry counter : this.counters.entrySet()) {
            Map<String, Object> currentLevel = root;
            String[] parts = ((String)counter.getKey()).split("\\.");
            for (int i = 0; i < parts.length - 1; ++i) {
                if (currentLevel.get(parts[i]) != null && !(currentLevel.get(parts[i]) instanceof Map)) {
                    throw new IllegalStateException("Failed to convert counter '" + (String)counter.getKey() + "' because '" + parts[i] + "' is already a leaf.");
                }
                currentLevel = (Map)currentLevel.computeIfAbsent(parts[i], k -> new HashMap());
            }
            String leaf = parts[parts.length - 1];
            if (currentLevel.containsKey(leaf)) {
                throw new IllegalStateException("Failed to convert counter '" + (String)counter.getKey() + "' because this is the path of another metric.");
            }
            currentLevel.put(leaf, ((CounterMetric)counter.getValue()).count());
        }
        return root;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.counters.size());
        for (Map.Entry entry : this.counters.entrySet()) {
            out.writeString((String)entry.getKey());
            out.writeVLong(((CounterMetric)entry.getValue()).count());
        }
    }

    public static Counters merge(List<Counters> counters) {
        Counters result = new Counters(new String[0]);
        for (Counters c : counters) {
            for (Map.Entry entry : c.counters.entrySet()) {
                result.inc((String)entry.getKey(), ((CounterMetric)entry.getValue()).count());
            }
        }
        return result;
    }
}

