/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.JavaDateFormatter;
import org.elasticsearch.common.time.LegacyFormatNames;

public interface DateFormatter {
    public TemporalAccessor parse(String var1);

    default public long parseMillis(String input) {
        return DateFormatters.from(this.parse(input)).toInstant().toEpochMilli();
    }

    public DateFormatter withZone(ZoneId var1);

    public DateFormatter withLocale(Locale var1);

    public String format(TemporalAccessor var1);

    default public String formatMillis(long millis) {
        ZoneId zone = this.zone() != null ? this.zone() : ZoneOffset.UTC;
        return this.format(Instant.ofEpochMilli(millis).atZone(zone));
    }

    public String pattern();

    public Locale locale();

    public ZoneId zone();

    public DateMathParser toDateMathParser();

    public static DateFormatter forPattern(String input) {
        return DateFormatter.forPattern(input, Version.CURRENT);
    }

    public static DateFormatter forPattern(String input, Version supportedVersion) {
        if (!Strings.hasLength(input)) {
            throw new IllegalArgumentException("No date pattern provided");
        }
        if (input.startsWith("8")) {
            input = input.substring(1);
        }
        String[] patterns = DateFormatter.splitCombinedPatterns(input);
        ArrayList<DateFormatter> formatters = new ArrayList<DateFormatter>(patterns.length);
        for (String pattern : patterns) {
            if (supportedVersion.before(Version.V_8_0_0)) {
                pattern = LegacyFormatNames.camelCaseToSnakeCase(pattern);
            }
            formatters.add(DateFormatters.forPattern(pattern));
        }
        if (formatters.size() == 1) {
            return (DateFormatter)formatters.get(0);
        }
        return JavaDateFormatter.combined(input, formatters);
    }

    public static String[] splitCombinedPatterns(String input) {
        String[] patterns;
        for (String pattern : patterns = Strings.delimitedListToStringArray(input, "||")) {
            if (Strings.hasLength(pattern)) continue;
            throw new IllegalArgumentException("Cannot have empty element in multi date format pattern: " + input);
        }
        return patterns;
    }
}

