/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class BytesRefArray
implements Accountable,
Releasable,
Writeable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BytesRefArray.class);
    private final BigArrays bigArrays;
    private LongArray startOffsets;
    private ByteArray bytes;
    private long size;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesRefArray(long capacity, BigArrays bigArrays) {
        this.bigArrays = bigArrays;
        boolean success = false;
        try {
            this.startOffsets = bigArrays.newLongArray(capacity + 1L, false);
            this.startOffsets.set(0L, 0L);
            this.bytes = bigArrays.newByteArray(capacity * 3L, false);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
        this.size = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesRefArray(StreamInput in, BigArrays bigArrays) throws IOException {
        this.bigArrays = bigArrays;
        boolean success = false;
        try {
            this.size = in.readVLong();
            long sizeOfStartOffsets = this.size + 1L;
            this.startOffsets = bigArrays.newLongArray(sizeOfStartOffsets, false);
            for (long i = 0L; i < sizeOfStartOffsets; ++i) {
                this.startOffsets.set(i, in.readVLong());
            }
            long sizeOfBytes = in.readVLong();
            this.bytes = bigArrays.newByteArray(sizeOfBytes, false);
            for (long i = 0L; i < sizeOfBytes; ++i) {
                this.bytes.set(i, in.readByte());
            }
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    private BytesRefArray(LongArray startOffsets, ByteArray bytes, long size, BigArrays bigArrays) {
        this.bytes = bytes;
        this.startOffsets = startOffsets;
        this.size = size;
        this.bigArrays = bigArrays;
    }

    public void append(BytesRef key) {
        assert (this.startOffsets != null) : "using BytesRefArray after ownership taken";
        long startOffset = this.startOffsets.get(this.size);
        this.startOffsets = this.bigArrays.grow(this.startOffsets, this.size + 2L);
        this.startOffsets.set(this.size + 1L, startOffset + (long)key.length);
        ++this.size;
        if (key.length > 0) {
            this.bytes = this.bigArrays.grow(this.bytes, startOffset + (long)key.length);
            this.bytes.set(startOffset, key.bytes, key.offset, key.length);
        }
    }

    public BytesRef get(long id, BytesRef dest) {
        assert (this.startOffsets != null) : "using BytesRefArray after ownership taken";
        long startOffset = this.startOffsets.get(id);
        int length = (int)(this.startOffsets.get(id + 1L) - startOffset);
        this.bytes.get(startOffset, length, dest);
        return dest;
    }

    public long size() {
        return this.size;
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.bytes, this.startOffsets});
    }

    public static BytesRefArray takeOwnershipOf(BytesRefArray other) {
        BytesRefArray b = new BytesRefArray(other.startOffsets, other.bytes, other.size, other.bigArrays);
        other.startOffsets = null;
        other.bytes = null;
        other.size = 0L;
        return b;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (this.startOffsets != null) : "using BytesRefArray after ownership taken";
        out.writeVLong(this.size);
        long sizeOfStartOffsets = this.size + 1L;
        for (long i = 0L; i < sizeOfStartOffsets; ++i) {
            out.writeVLong(this.startOffsets.get(i));
        }
        long sizeOfBytes = this.startOffsets.get(this.size);
        out.writeVLong(sizeOfBytes);
        for (long i = 0L; i < sizeOfBytes; ++i) {
            out.writeByte(this.bytes.get(i));
        }
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.startOffsets.ramBytesUsed() + this.bytes.ramBytesUsed();
    }
}

