/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.util.concurrent.BaseFuture;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Tuple;

public final class ListenableFuture<V>
extends BaseFuture<V>
implements ActionListener<V> {
    private volatile boolean done = false;
    private List<Tuple<ActionListener<V>, ExecutorService>> listeners;

    public void addListener(ActionListener<V> listener) {
        this.addListener(listener, EsExecutors.DIRECT_EXECUTOR_SERVICE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ActionListener<V> listener, ExecutorService executor, ThreadContext threadContext) {
        if (this.done) {
            this.notifyListenerDirectly(listener);
        } else {
            boolean run;
            ListenableFuture listenableFuture = this;
            synchronized (listenableFuture) {
                if (this.done) {
                    run = true;
                } else {
                    ActionListener<V> wrappedListener = threadContext == null ? listener : ContextPreservingActionListener.wrapPreservingContext(listener, threadContext);
                    if (this.listeners == null) {
                        this.listeners = new ArrayList<Tuple<ActionListener<V>, ExecutorService>>();
                    }
                    this.listeners.add(new Tuple(wrappedListener, (Object)executor));
                    run = false;
                }
            }
            if (run) {
                this.notifyListenerDirectly(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done(boolean ignored) {
        List<Tuple<ActionListener<V>, ExecutorService>> existingListeners;
        ListenableFuture listenableFuture = this;
        synchronized (listenableFuture) {
            this.done = true;
            existingListeners = this.listeners;
            if (existingListeners == null) {
                return;
            }
            this.listeners = null;
        }
        for (Tuple tuple : existingListeners) {
            ExecutorService executorService = (ExecutorService)tuple.v2();
            ActionListener listener = (ActionListener)tuple.v1();
            if (executorService == EsExecutors.DIRECT_EXECUTOR_SERVICE) {
                this.notifyListenerDirectly(listener);
                continue;
            }
            this.notifyListener(listener, executorService);
        }
    }

    private void notifyListenerDirectly(ActionListener<V> listener) {
        assert (this.done);
        ActionListener.completeWith(listener, () -> FutureUtils.get(this, 0L, TimeUnit.NANOSECONDS));
    }

    private void notifyListener(ActionListener<V> listener, ExecutorService executorService) {
        ActionListener.run(listener, l -> executorService.execute(new Runnable(){
            final /* synthetic */ ActionListener val$l;
            {
                this.val$l = actionListener;
            }

            @Override
            public void run() {
                ListenableFuture.this.notifyListenerDirectly(this.val$l);
            }

            public String toString() {
                return "ListenableFuture notification";
            }
        }));
    }

    @Override
    public void onResponse(V v) {
        boolean set = this.set(v);
        if (!set) {
            assert (false);
            throw new IllegalStateException("did not set value, value or exception already set?");
        }
    }

    @Override
    public void onFailure(Exception e) {
        boolean set = this.setException(e);
        if (!set) {
            assert (false);
            throw new IllegalStateException("did not set exception, value already set or exception already set?");
        }
    }
}

