/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class XContentHelper {
    @Deprecated
    public static XContentParser createParser(NamedXContentRegistry registry, DeprecationHandler deprecation, BytesReference bytes) throws IOException {
        return XContentHelper.createParser(XContentParserConfiguration.EMPTY.withRegistry(registry).withDeprecationHandler(deprecation), bytes);
    }

    @Deprecated
    public static XContentParser createParser(XContentParserConfiguration config, BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            InputStream compressedInput = compressor.threadLocalInputStream(bytes.streamInput());
            if (!compressedInput.markSupported()) {
                compressedInput = new BufferedInputStream(compressedInput);
            }
            XContentType contentType = XContentFactory.xContentType((InputStream)compressedInput);
            return XContentFactory.xContent((XContentType)contentType).createParser(config, compressedInput);
        }
        return XContentFactory.xContent((XContentType)XContentHelper.xContentType(bytes)).createParser(config, (InputStream)bytes.streamInput());
    }

    @Deprecated
    public static XContentParser createParser(NamedXContentRegistry registry, DeprecationHandler deprecation, BytesReference bytes, XContentType xContentType) throws IOException {
        return XContentHelper.createParser(XContentParserConfiguration.EMPTY.withRegistry(registry).withDeprecationHandler(deprecation), bytes, xContentType);
    }

    public static XContentParser createParser(XContentParserConfiguration config, BytesReference bytes, XContentType xContentType) throws IOException {
        Objects.requireNonNull(xContentType);
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            InputStream compressedInput = compressor.threadLocalInputStream(bytes.streamInput());
            if (!compressedInput.markSupported()) {
                compressedInput = new BufferedInputStream(compressedInput);
            }
            return XContentFactory.xContent((XContentType)xContentType).createParser(config, compressedInput);
        }
        if (bytes.hasArray()) {
            return xContentType.xContent().createParser(config, bytes.array(), bytes.arrayOffset(), bytes.length());
        }
        return xContentType.xContent().createParser(config, (InputStream)bytes.streamInput());
    }

    @Deprecated
    public static Tuple<XContentType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered) throws ElasticsearchParseException {
        return XContentHelper.convertToMap(bytes, ordered, null);
    }

    public static Tuple<XContentType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered, XContentType xContentType) {
        return XContentHelper.convertToMap(bytes, ordered, xContentType, null, null);
    }

    public static Tuple<XContentType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered, XContentType xContentType, @Nullable Set<String> include, @Nullable Set<String> exclude) throws ElasticsearchParseException {
        Tuple tuple;
        block12: {
            XContentType contentType;
            InputStream input;
            Compressor compressor = CompressorFactory.compressor(bytes);
            if (compressor != null) {
                InputStream compressedStreamInput = compressor.threadLocalInputStream(bytes.streamInput());
                if (!compressedStreamInput.markSupported()) {
                    compressedStreamInput = new BufferedInputStream(compressedStreamInput);
                }
                input = compressedStreamInput;
                contentType = xContentType != null ? xContentType : XContentFactory.xContentType((InputStream)input);
            } else {
                if (bytes.hasArray()) {
                    byte[] raw = bytes.array();
                    int offset = bytes.arrayOffset();
                    int length = bytes.length();
                    XContentType contentType2 = xContentType != null ? xContentType : XContentFactory.xContentType((byte[])raw, (int)offset, (int)length);
                    return new Tuple((Object)Objects.requireNonNull(contentType2), XContentHelper.convertToMap(XContentFactory.xContent((XContentType)contentType2), raw, offset, length, ordered, include, exclude));
                }
                input = bytes.streamInput();
                contentType = xContentType != null ? xContentType : XContentFactory.xContentType((InputStream)input);
            }
            InputStream stream = input;
            try {
                tuple = new Tuple((Object)Objects.requireNonNull(contentType), XContentHelper.convertToMap(XContentFactory.xContent((XContentType)contentType), stream, ordered, include, exclude));
                if (stream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            stream.close();
        }
        return tuple;
    }

    public static Map<String, Object> convertToMap(XContent xContent, String string, boolean ordered) throws ElasticsearchParseException {
        Map map;
        block8: {
            XContentParser parser = xContent.createParser(XContentParserConfiguration.EMPTY, string);
            try {
                Map map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    public static Map<String, Object> convertToMap(XContent xContent, InputStream input, boolean ordered) throws ElasticsearchParseException {
        return XContentHelper.convertToMap(xContent, input, ordered, null, null);
    }

    public static Map<String, Object> convertToMap(XContent xContent, InputStream input, boolean ordered, @Nullable Set<String> include, @Nullable Set<String> exclude) throws ElasticsearchParseException {
        Map map;
        block8: {
            XContentParser parser = xContent.createParser(XContentParserConfiguration.EMPTY.withFiltering(include, exclude, false), input);
            try {
                Map map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    public static Map<String, Object> convertToMap(XContent xContent, byte[] bytes, int offset, int length, boolean ordered) throws ElasticsearchParseException {
        return XContentHelper.convertToMap(xContent, bytes, offset, length, ordered, null, null);
    }

    public static Map<String, Object> convertToMap(XContent xContent, byte[] bytes, int offset, int length, boolean ordered, @Nullable Set<String> include, @Nullable Set<String> exclude) throws ElasticsearchParseException {
        Map map;
        block8: {
            XContentParser parser = xContent.createParser(XContentParserConfiguration.EMPTY.withFiltering(include, exclude, false), bytes, offset, length);
            try {
                Map map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    @Deprecated
    public static String convertToJson(BytesReference bytes, boolean reformatJson) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, false);
    }

    @Deprecated
    public static String convertToJson(BytesReference bytes, boolean reformatJson, boolean prettyPrint) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, prettyPrint, XContentFactory.xContentType((byte[])bytes.toBytesRef().bytes));
    }

    public static String convertToJson(BytesReference bytes, boolean reformatJson, XContentType xContentType) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, false, xContentType);
    }

    public static String stripWhitespace(String json) throws IOException {
        return XContentHelper.convertToJson((BytesReference)new BytesArray(json), true, XContentType.JSON);
    }

    public static String convertToJson(BytesReference bytes, boolean reformatJson, boolean prettyPrint, XContentType xContentType) throws IOException {
        Objects.requireNonNull(xContentType);
        if (xContentType.canonical() == XContentType.JSON && !reformatJson) {
            return bytes.utf8ToString();
        }
        if (bytes.hasArray()) {
            try (XContentParser parser = XContentFactory.xContent((XContentType)xContentType).createParser(XContentParserConfiguration.EMPTY, bytes.array(), bytes.arrayOffset(), bytes.length());){
                String string = XContentHelper.toJsonString(prettyPrint, parser);
                return string;
            }
        }
        try (StreamInput stream = bytes.streamInput();){
            String string;
            block20: {
                XContentParser parser = XContentFactory.xContent((XContentType)xContentType).createParser(XContentParserConfiguration.EMPTY, (InputStream)stream);
                try {
                    string = XContentHelper.toJsonString(prettyPrint, parser);
                    if (parser == null) break block20;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return string;
        }
    }

    private static String toJsonString(boolean prettyPrint, XContentParser parser) throws IOException {
        parser.nextToken();
        XContentBuilder builder = XContentFactory.jsonBuilder();
        if (prettyPrint) {
            builder.prettyPrint();
        }
        builder.copyCurrentStructure(parser);
        return Strings.toString(builder);
    }

    public static boolean update(Map<String, Object> source, Map<String, Object> changes, boolean checkUpdatesAreUnequal) {
        boolean modified = false;
        for (Map.Entry<String, Object> changesEntry : changes.entrySet()) {
            if (!source.containsKey(changesEntry.getKey())) {
                source.put(changesEntry.getKey(), changesEntry.getValue());
                modified = true;
                continue;
            }
            Object old = source.get(changesEntry.getKey());
            if (old instanceof Map && changesEntry.getValue() instanceof Map) {
                modified |= XContentHelper.update((Map)source.get(changesEntry.getKey()), (Map)changesEntry.getValue(), checkUpdatesAreUnequal && !modified);
                continue;
            }
            source.put(changesEntry.getKey(), changesEntry.getValue());
            if (modified) continue;
            if (!checkUpdatesAreUnequal) {
                modified = true;
                continue;
            }
            modified = !Objects.equals(old, changesEntry.getValue());
        }
        return modified;
    }

    public static void mergeDefaults(Map<String, Object> content, Map<String, Object> defaults) {
        for (Map.Entry<String, Object> defaultEntry : defaults.entrySet()) {
            if (!content.containsKey(defaultEntry.getKey())) {
                content.put(defaultEntry.getKey(), defaultEntry.getValue());
                continue;
            }
            if (content.get(defaultEntry.getKey()) instanceof Map && defaultEntry.getValue() instanceof Map) {
                XContentHelper.mergeDefaults((Map)content.get(defaultEntry.getKey()), (Map)defaultEntry.getValue());
                continue;
            }
            if (!(content.get(defaultEntry.getKey()) instanceof List) || !(defaultEntry.getValue() instanceof List)) continue;
            List defaultList = (List)defaultEntry.getValue();
            List contentList = (List)content.get(defaultEntry.getKey());
            if (XContentHelper.allListValuesAreMapsOfOne(defaultList) && XContentHelper.allListValuesAreMapsOfOne(contentList)) {
                Map.Entry entry;
                Map map;
                LinkedHashMap<String, Map> processed = new LinkedHashMap<String, Map>();
                for (Object o : contentList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    processed.put((String)entry.getKey(), map);
                }
                for (Object o : defaultList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    if (processed.containsKey(entry.getKey())) {
                        XContentHelper.mergeDefaults((Map)processed.get(entry.getKey()), map);
                        continue;
                    }
                    processed.put((String)entry.getKey(), map);
                }
                content.put(defaultEntry.getKey(), new ArrayList(processed.values()));
                continue;
            }
            ArrayList mergedList = new ArrayList(defaultList);
            for (Object o : contentList) {
                if (mergedList.contains(o)) continue;
                mergedList.add(o);
            }
            content.put(defaultEntry.getKey(), mergedList);
        }
    }

    private static boolean allListValuesAreMapsOfOne(List<Object> list) {
        for (Object o : list) {
            if (!(o instanceof Map)) {
                return false;
            }
            if (((Map)o).size() == 1) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static void writeRawField(String field, BytesReference source, XContentBuilder builder, ToXContent.Params params) throws IOException {
        Compressor compressor = CompressorFactory.compressor(source);
        if (compressor != null) {
            try (InputStream compressedStreamInput = compressor.threadLocalInputStream(source.streamInput());){
                builder.rawField(field, compressedStreamInput);
            }
        }
        try (StreamInput stream = source.streamInput();){
            builder.rawField(field, (InputStream)stream);
        }
    }

    public static void writeRawField(String field, BytesReference source, XContentType xContentType, XContentBuilder builder, ToXContent.Params params) throws IOException {
        Objects.requireNonNull(xContentType);
        Compressor compressor = CompressorFactory.compressor(source);
        if (compressor != null) {
            try (InputStream compressedStreamInput = compressor.threadLocalInputStream(source.streamInput());){
                builder.rawField(field, compressedStreamInput, xContentType);
            }
        }
        try (StreamInput stream = source.streamInput();){
            builder.rawField(field, (InputStream)stream, xContentType);
        }
    }

    public static BytesReference toXContent(ToXContent toXContent, XContentType xContentType, boolean humanReadable) throws IOException {
        return XContentHelper.toXContent(toXContent, xContentType, ToXContent.EMPTY_PARAMS, humanReadable);
    }

    public static BytesReference toXContent(ToXContent toXContent, XContentType xContentType, ToXContent.Params params, boolean humanReadable) throws IOException {
        try (XContentBuilder builder = XContentBuilder.builder((XContent)xContentType.xContent());){
            builder.humanReadable(humanReadable);
            if (toXContent.isFragment()) {
                builder.startObject();
            }
            toXContent.toXContent(builder, params);
            if (toXContent.isFragment()) {
                builder.endObject();
            }
            BytesReference bytesReference = BytesReference.bytes(builder);
            return bytesReference;
        }
    }

    @Deprecated
    public static XContentType xContentTypeMayCompressed(BytesReference bytes) {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            try {
                InputStream compressedStreamInput = compressor.threadLocalInputStream(bytes.streamInput());
                if (!compressedStreamInput.markSupported()) {
                    compressedStreamInput = new BufferedInputStream(compressedStreamInput);
                }
                return XContentFactory.xContentType((InputStream)compressedStreamInput);
            }
            catch (IOException e) {
                assert (false) : "Should not happen, we're just reading bytes from memory";
                throw new UncheckedIOException(e);
            }
        }
        return XContentHelper.xContentType(bytes);
    }

    @Deprecated
    public static XContentType xContentType(BytesReference bytes) {
        if (bytes.hasArray()) {
            return XContentFactory.xContentType((byte[])bytes.array(), (int)bytes.arrayOffset(), (int)bytes.length());
        }
        try {
            StreamInput inputStream = bytes.streamInput();
            assert (inputStream.markSupported());
            return XContentFactory.xContentType((InputStream)inputStream);
        }
        catch (IOException e) {
            assert (false) : "Should not happen, we're just reading bytes from memory";
            throw new UncheckedIOException(e);
        }
    }

    public static BytesReference childBytes(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(parser.getTokenLocation(), "Expected [START_OBJECT] but got [" + parser.currentToken() + "]");
        }
        XContentBuilder builder = XContentBuilder.builder((XContent)parser.contentType().xContent());
        builder.copyCurrentStructure(parser);
        return BytesReference.bytes(builder);
    }

    public static void writeTo(StreamOutput out, XContentType xContentType) throws IOException {
        if (out.getTransportVersion().before(TransportVersion.V_8_0_0)) {
            out.writeVInt(xContentType.canonical().ordinal());
        } else {
            out.writeVInt(xContentType.ordinal());
        }
    }

    public static XContentParser mapToXContentParser(XContentParserConfiguration config, Map<String, ?> source) {
        XContentParser xContentParser;
        block8: {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            try {
                builder.map(source);
                xContentParser = XContentFactory.xContent((XContentType)builder.contentType()).createParser(config, Strings.toString(builder));
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
                }
            }
            builder.close();
        }
        return xContentParser;
    }
}

