/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;

public record Diagnosis(Definition definition, @Nullable List<Resource> affectedResources) implements ChunkedToXContent
{
    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        Iterator<Object> resourcesIterator = this.affectedResources == null ? Collections.emptyIterator() : Iterators.flatMap(this.affectedResources.iterator(), s -> s.toXContentChunked(outerParams));
        return Iterators.concat(Iterators.single((builder, params) -> {
            builder.startObject();
            builder.field("id", this.definition.getUniqueId());
            builder.field("cause", this.definition.cause);
            builder.field("action", this.definition.action);
            builder.field("help_url", this.definition.helpURL);
            if (this.affectedResources != null && this.affectedResources.size() > 0) {
                builder.startObject("affected_resources");
            }
            return builder;
        }), resourcesIterator, Iterators.single((builder, params) -> {
            if (this.affectedResources != null && this.affectedResources.size() > 0) {
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }));
    }

    public record Definition(String indicatorName, String id, String cause, String action, String helpURL) {
        public String getUniqueId() {
            return "elasticsearch:health:" + this.indicatorName + ":diagnosis:" + this.id;
        }
    }

    public static class Resource
    implements ChunkedToXContent {
        public static final String ID_FIELD = "id";
        public static final String NAME_FIELD = "name";
        private final Type type;
        @Nullable
        private Collection<String> values;
        @Nullable
        private Collection<DiscoveryNode> nodes;

        public Resource(Type type, Collection<String> values) {
            if (type == Type.NODE) {
                throw new IllegalArgumentException("Nodes should be modelled using the dedicated constructor");
            }
            this.type = type;
            this.values = values;
        }

        public Resource(Collection<DiscoveryNode> nodes) {
            this.type = Type.NODE;
            this.nodes = nodes;
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            Iterator valuesIterator = this.nodes != null ? this.nodes.stream().map(node -> (builder, params) -> {
                builder.startObject();
                builder.field(ID_FIELD, node.getId());
                if (node.getName() != null) {
                    builder.field(NAME_FIELD, node.getName());
                }
                builder.endObject();
                return builder;
            }).iterator() : this.values.stream().map(value -> (builder, params) -> builder.value(value)).iterator();
            return ChunkedToXContentHelper.array(this.type.displayValue, valuesIterator);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resource resource = (Resource)o;
            return this.type == resource.type && Objects.equals(this.values, resource.values) && Objects.equals(this.nodes, resource.nodes);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.values, this.nodes});
        }

        public Type getType() {
            return this.type;
        }

        @Nullable
        public Collection<String> getValues() {
            return this.values;
        }

        @Nullable
        public Collection<DiscoveryNode> getNodes() {
            return this.nodes;
        }

        public static enum Type {
            INDEX("indices"),
            NODE("nodes"),
            SLM_POLICY("slm_policies"),
            FEATURE_STATE("feature_states"),
            SNAPSHOT_REPOSITORY("snapshot_repositories");

            private final String displayValue;

            private Type(String displayValue) {
                this.displayValue = displayValue;
            }
        }
    }
}

