/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.health.Diagnosis;
import org.elasticsearch.health.HealthIndicatorDetails;
import org.elasticsearch.health.HealthIndicatorImpact;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.health.node.HealthInfo;

public interface HealthIndicatorService {
    public static final int MAX_AFFECTED_RESOURCES_COUNT = 1000;

    public String name();

    default public HealthIndicatorResult calculate(boolean verbose, HealthInfo healthInfo) {
        return this.calculate(verbose, 1000, healthInfo);
    }

    public HealthIndicatorResult calculate(boolean var1, int var2, HealthInfo var3);

    default public HealthIndicatorResult createIndicator(HealthStatus status, String symptom, HealthIndicatorDetails details, Collection<HealthIndicatorImpact> impacts, List<Diagnosis> diagnosisList) {
        List<HealthIndicatorImpact> impactsList = impacts.stream().sorted(Comparator.comparingInt(HealthIndicatorImpact::severity)).limit(3L).collect(Collectors.toList());
        return new HealthIndicatorResult(this.name(), status, symptom, details, impactsList, diagnosisList);
    }
}

