/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.health.GetHealthAction;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestChunkedToXContentListener;

public class RestGetHealthAction
extends BaseRestHandler {
    private static final String VERBOSE_PARAM = "verbose";
    private static final String SIZE_PARAM = "size";

    @Override
    public String getName() {
        return "health_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_health_report"), new RestHandler.Route(RestRequest.Method.GET, "/_health_report/{indicator}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String indicatorName = request.param("indicator");
        boolean verbose = request.paramAsBoolean(VERBOSE_PARAM, true);
        int size = request.paramAsInt(SIZE_PARAM, 1000);
        GetHealthAction.Request getHealthRequest = new GetHealthAction.Request(indicatorName, verbose, size);
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute(GetHealthAction.INSTANCE, getHealthRequest, new RestChunkedToXContentListener((RestChannel)channel));
    }
}

