/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.metadata;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.health.metadata.HealthMetadata;
import org.elasticsearch.health.node.selection.HealthNodeTaskExecutor;

public class HealthMetadataService {
    private static final Logger logger = LogManager.getLogger(HealthMetadataService.class);
    private final ClusterService clusterService;
    private final ClusterStateListener clusterStateListener;
    private final Settings settings;
    private final ClusterStateTaskExecutor<UpsertHealthMetadataTask> executor = new UpsertHealthMetadataTask.Executor();
    private volatile boolean enabled;
    private volatile boolean readyToPublish = false;
    private volatile boolean isMaster = false;

    private HealthMetadataService(ClusterService clusterService, Settings settings) {
        this.clusterService = clusterService;
        this.settings = settings;
        this.clusterStateListener = this::updateOnClusterStateChange;
        this.enabled = HealthNodeTaskExecutor.ENABLED_SETTING.get(settings);
    }

    public static HealthMetadataService create(ClusterService clusterService, Settings settings) {
        HealthMetadataService healthMetadataService = new HealthMetadataService(clusterService, settings);
        healthMetadataService.registerListeners();
        return healthMetadataService;
    }

    private void registerListeners() {
        if (this.enabled) {
            this.clusterService.addListener(this.clusterStateListener);
        }
        ClusterSettings clusterSettings = this.clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING, value -> this.updateOnSettingsUpdated(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), value.getStringRep()));
        clusterSettings.addSettingsUpdateConsumer(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING, value -> this.updateOnSettingsUpdated(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), value.getStringRep()));
        clusterSettings.addSettingsUpdateConsumer(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING, value -> this.updateOnSettingsUpdated(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING.getKey(), value.getStringRep()));
        clusterSettings.addSettingsUpdateConsumer(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING, value -> this.updateOnSettingsUpdated(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING.getKey(), value.getStringRep()));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(HealthNodeTaskExecutor.ENABLED_SETTING, this::enable);
        clusterSettings.addSettingsUpdateConsumer(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING, value -> this.updateOnSettingsUpdated(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING.getKey(), value.getStringRep()));
        clusterSettings.addSettingsUpdateConsumer(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING, value -> this.updateOnSettingsUpdated(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING.getKey(), value.getStringRep()));
    }

    private void enable(boolean enabled) {
        this.enabled = enabled;
        if (this.enabled) {
            this.clusterService.addListener(this.clusterStateListener);
            this.resetHealthMetadata("health-node-enabled");
        } else {
            this.clusterService.removeListener(this.clusterStateListener);
            this.readyToPublish = false;
        }
    }

    private void updateOnClusterStateChange(ClusterChangedEvent event) {
        boolean wasMaster = event.previousState().nodes().isLocalNodeElectedMaster();
        this.isMaster = event.localNodeMaster();
        if (this.isMaster && !wasMaster) {
            this.readyToPublish = true;
        } else if (!this.isMaster) {
            this.readyToPublish = false;
        }
        if (event.state().nodesIfRecovered().getMinNodeVersion().onOrAfter(Version.V_8_5_0) && this.readyToPublish) {
            this.resetHealthMetadata("health-metadata-update-master-election");
            this.readyToPublish = false;
        }
    }

    private void updateOnSettingsUpdated(String setting, String value) {
        ClusterState clusterState;
        if (this.isMaster && this.enabled && (clusterState = this.clusterService.state()).nodesIfRecovered().getMinNodeVersion().onOrAfter(Version.V_8_5_0)) {
            UpdateHealthMetadata task = new UpdateHealthMetadata(setting, value);
            ClusterStateTaskConfig config = ClusterStateTaskConfig.build(Priority.NORMAL);
            this.clusterService.submitStateUpdateTask("health-metadata-update", task, config, this.executor);
        }
    }

    private void resetHealthMetadata(String source) {
        InsertHealthMetadata task = new InsertHealthMetadata(this.settings);
        ClusterStateTaskConfig config = ClusterStateTaskConfig.build(Priority.NORMAL);
        this.clusterService.submitStateUpdateTask(source, task, config, this.executor);
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(ClusterState.Custom.class, "health", HealthMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "health", HealthMetadata::readDiffFrom));
    }

    static abstract class UpsertHealthMetadataTask
    implements ClusterStateTaskListener {
        UpsertHealthMetadataTask() {
        }

        @Override
        public void onFailure(@Nullable Exception e) {
            logger.log(MasterService.isPublishFailureException(e) ? Level.DEBUG : Level.WARN, () -> "failure during health metadata update", (Throwable)e);
        }

        abstract ClusterState execute(ClusterState var1);

        static class Executor
        extends SimpleBatchedExecutor<UpsertHealthMetadataTask, Void> {
            Executor() {
            }

            @Override
            public Tuple<ClusterState, Void> executeTask(UpsertHealthMetadataTask task, ClusterState clusterState) {
                return Tuple.tuple((Object)task.execute(clusterState), null);
            }

            @Override
            public void taskSucceeded(UpsertHealthMetadataTask task, Void unused) {
            }
        }
    }

    static class UpdateHealthMetadata
    extends UpsertHealthMetadataTask {
        private final String setting;
        private final String value;

        UpdateHealthMetadata(String setting, String value) {
            this.setting = setting;
            this.value = value;
        }

        @Override
        ClusterState execute(ClusterState clusterState) {
            HealthMetadata finalHealthMetadata;
            HealthMetadata initialHealthMetadata = HealthMetadata.getFromClusterState(clusterState);
            assert (initialHealthMetadata != null) : "health metadata should have been initialized";
            HealthMetadata.Disk.Builder builder = HealthMetadata.Disk.newBuilder(initialHealthMetadata.getDiskMetadata());
            if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey().equals(this.setting)) {
                builder.highWatermark(this.value, this.setting);
            }
            if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey().equals(this.setting)) {
                builder.floodStageWatermark(this.value, this.setting);
            }
            if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING.getKey().equals(this.setting)) {
                builder.frozenFloodStageWatermark(this.value, this.setting);
            }
            if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING.getKey().equals(this.setting)) {
                builder.frozenFloodStageMaxHeadroom(this.value, this.setting);
            }
            if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING.getKey().equals(this.setting)) {
                builder.highMaxHeadroom(this.value, this.setting);
            }
            if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING.getKey().equals(this.setting)) {
                builder.floodStageMaxHeadroom(this.value, this.setting);
            }
            return (finalHealthMetadata = new HealthMetadata(builder.build())).equals(initialHealthMetadata) ? clusterState : clusterState.copyAndUpdate(b -> b.putCustom("health", finalHealthMetadata));
        }
    }

    static class InsertHealthMetadata
    extends UpsertHealthMetadataTask {
        private final Settings settings;

        InsertHealthMetadata(Settings settings) {
            this.settings = settings;
        }

        @Override
        ClusterState execute(ClusterState clusterState) {
            HealthMetadata initialHealthMetadata = HealthMetadata.getFromClusterState(clusterState);
            HealthMetadata finalHealthMetadata = new HealthMetadata(new HealthMetadata.Disk(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.get(this.settings), DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING.get(this.settings), DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.get(this.settings), DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING.get(this.settings), DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING.get(this.settings), DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING.get(this.settings)));
            return finalHealthMetadata.equals(initialHealthMetadata) ? clusterState : clusterState.copyAndUpdate(b -> b.putCustom("health", finalHealthMetadata));
        }
    }
}

