/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.packed.DirectMonotonicWriter;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.tsdb.ES87TSDBDocValuesEncoder;

final class ES87TSDBDocValuesConsumer
extends DocValuesConsumer {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;
    private final int numericBlockShift;
    private final int numericBlockSize;
    private final int directMonotonicBlockShift;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ES87TSDBDocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension, int numericBlockShift, int numericBlockSize, int directMonotonicBlockShift) throws IOException {
        boolean success = false;
        this.numericBlockShift = numericBlockShift;
        this.numericBlockSize = numericBlockSize;
        this.directMonotonicBlockShift = directMonotonicBlockShift;
        try {
            String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeIndexHeader((DataOutput)this.data, (String)dataCodec, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeIndexHeader((DataOutput)this.meta, (String)metaCodec, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            this.maxDoc = state.segmentInfo.maxDoc();
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)this));
            }
        }
    }

    public void addNumericField(FieldInfo field, final DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeByte((byte)0);
        this.writeNumericField(field, (DocValuesProducer)new EmptyDocValuesProducer(){

            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                return DocValues.singleton((NumericDocValues)valuesProducer.getNumeric(field));
            }
        });
    }

    private long[] writeNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        int numDocsWithValue = 0;
        long numValues = 0L;
        SortedNumericDocValues values = valuesProducer.getSortedNumeric(field);
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithValue;
            int count = values.docValueCount();
            numValues += (long)count;
            doc = values.nextDoc();
        }
        if (numDocsWithValue == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else if (numDocsWithValue == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values = valuesProducer.getSortedNumeric(field);
            short jumpTableEntryCount = IndexedDISI.writeBitSet((DocIdSetIterator)values, (IndexOutput)this.data, (byte)9);
            this.meta.writeLong(this.data.getFilePointer() - offset);
            this.meta.writeShort(jumpTableEntryCount);
            this.meta.writeByte((byte)9);
        }
        this.meta.writeLong(numValues);
        if (numValues > 0L) {
            this.meta.writeInt(this.directMonotonicBlockShift);
            ByteBuffersDataOutput indexOut = new ByteBuffersDataOutput();
            DirectMonotonicWriter indexWriter = DirectMonotonicWriter.getInstance((IndexOutput)this.meta, (IndexOutput)new ByteBuffersIndexOutput(indexOut, "temp-dv-index", "temp-dv-index"), (long)(1L + (numValues - 1L >>> this.numericBlockShift)), (int)this.directMonotonicBlockShift);
            long[] buffer = new long[this.numericBlockSize];
            int bufferSize = 0;
            long valuesDataOffset = this.data.getFilePointer();
            ES87TSDBDocValuesEncoder encoder = new ES87TSDBDocValuesEncoder(this.numericBlockSize);
            values = valuesProducer.getSortedNumeric(field);
            int doc2 = values.nextDoc();
            while (doc2 != Integer.MAX_VALUE) {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    buffer[bufferSize++] = values.nextValue();
                    if (bufferSize != this.numericBlockSize) continue;
                    indexWriter.add(this.data.getFilePointer() - valuesDataOffset);
                    encoder.encode(buffer, (DataOutput)this.data);
                    bufferSize = 0;
                }
                doc2 = values.nextDoc();
            }
            if (bufferSize > 0) {
                indexWriter.add(this.data.getFilePointer() - valuesDataOffset);
                Arrays.fill(buffer, bufferSize, this.numericBlockSize, 0L);
                encoder.encode(buffer, (DataOutput)this.data);
            }
            long valuesDataLength = this.data.getFilePointer() - valuesDataOffset;
            indexWriter.finish();
            long indexDataOffset = this.data.getFilePointer();
            this.data.copyBytes((DataInput)indexOut.toDataInput(), indexOut.size());
            this.meta.writeLong(indexDataOffset);
            this.meta.writeLong(this.data.getFilePointer() - indexDataOffset);
            this.meta.writeLong(valuesDataOffset);
            this.meta.writeLong(valuesDataLength);
        }
        return new long[]{numDocsWithValue, numValues};
    }

    public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        throw new UnsupportedOperationException("Unsupported binary doc values for field [" + field.name + "]");
    }

    public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        throw new UnsupportedOperationException("Unsupported sorted doc values for field [" + field.name + "]");
    }

    public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeByte((byte)4);
        this.writeSortedNumericField(field, valuesProducer);
    }

    private void writeSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        long[] stats = this.writeNumericField(field, valuesProducer);
        int numDocsWithField = Math.toIntExact(stats[0]);
        long numValues = stats[1];
        assert (numValues >= (long)numDocsWithField);
        this.meta.writeInt(numDocsWithField);
        if (numValues > (long)numDocsWithField) {
            long start = this.data.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(this.directMonotonicBlockShift);
            DirectMonotonicWriter addressesWriter = DirectMonotonicWriter.getInstance((IndexOutput)this.meta, (IndexOutput)this.data, (long)((long)numDocsWithField + 1L), (int)this.directMonotonicBlockShift);
            long addr = 0L;
            addressesWriter.add(addr);
            SortedNumericDocValues values = valuesProducer.getSortedNumeric(field);
            int doc = values.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                addressesWriter.add(addr += (long)values.docValueCount());
                doc = values.nextDoc();
            }
            addressesWriter.finish();
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
    }

    public void addSortedSetField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        throw new UnsupportedOperationException("Unsupported sorted set doc values for field [" + field.name + "]");
    }

    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeInt(-1);
                        CodecUtil.writeFooter((IndexOutput)this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter((IndexOutput)this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                break block7;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
        }
        this.data = null;
        this.meta = null;
    }
}

