/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.index.codec.tsdb.ES87TSDBDocValuesConsumer;
import org.elasticsearch.index.codec.tsdb.ES87TSDBDocValuesProducer;

public class ES87TSDBDocValuesFormat
extends DocValuesFormat {
    static final int DEFAULT_NUMERIC_BLOCK_SHIFT = 7;
    static final int DEFAULT_NUMERIC_BLOCK_SIZE = 128;
    static final int DEFAULT_DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    static final String CODEC_NAME = "ES87TSDB";
    static final String DATA_CODEC = "ES87TSDBDocValuesData";
    static final String DATA_EXTENSION = "dvd";
    static final String META_CODEC = "ES87TSDBDocValuesMetadata";
    static final String META_EXTENSION = "dvm";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    static final byte NUMERIC = 0;
    static final byte BINARY = 1;
    static final byte SORTED = 2;
    static final byte SORTED_SET = 3;
    static final byte SORTED_NUMERIC = 4;
    private final int numericBlockShift;
    private final int numericBlockSize;
    private final int numericBlockMask;
    private final int directMonotonicBlockShift;

    public ES87TSDBDocValuesFormat() {
        this(7, 16);
    }

    public ES87TSDBDocValuesFormat(int numericBlockShift, int directMonotonicBlockShift) {
        super(CODEC_NAME);
        this.numericBlockShift = numericBlockShift;
        this.numericBlockSize = 1 << numericBlockShift;
        this.numericBlockMask = this.numericBlockSize - 1;
        this.directMonotonicBlockShift = directMonotonicBlockShift;
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new ES87TSDBDocValuesConsumer(state, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION, this.numericBlockShift, this.numericBlockSize, this.directMonotonicBlockShift);
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new ES87TSDBDocValuesProducer(state, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION, this.numericBlockShift, this.numericBlockSize, this.numericBlockMask);
    }

    public int getNumericBlockShift() {
        return this.numericBlockShift;
    }

    public int getNumericBlockSize() {
        return this.numericBlockSize;
    }

    public int getNumericBlockMask() {
        return this.numericBlockMask;
    }

    public int getDirectMonotonicBlockShift() {
        return this.directMonotonicBlockShift;
    }
}

